package mekanism.client.render.entity;

import mekanism.api.EnumColor;
import mekanism.client.model.ModelBalloon;
import mekanism.common.entity.EntityBalloon;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderBalloon extends Render<EntityBalloon>
{
	private Minecraft mc = Minecraft.func_71410_x();

	public ModelBalloon model = new ModelBalloon();

	public RenderBalloon(RenderManager renderManager)
	{
		super(renderManager);
	}

	@Override
	protected ResourceLocation func_110775_a(EntityBalloon entity)
	{
		return MekanismUtils.getResource(ResourceType.RENDER, "Balloon.png");
	}

	@Override
	public void func_76986_a(EntityBalloon balloon, double x, double y, double z, float f, float partialTick)
	{
		double renderPosX = x - (balloon.field_70142_S + (balloon.field_70165_t - balloon.field_70142_S)*partialTick);
		double renderPosY = y - (balloon.field_70137_T + (balloon.field_70163_u - balloon.field_70137_T)*partialTick);
		double renderPosZ = z - (balloon.field_70136_U + (balloon.field_70161_v - balloon.field_70136_U)*partialTick);
		
		if(balloon.isLatchedToEntity())
		{
			x = (balloon.latchedEntity.field_70142_S + (balloon.latchedEntity.field_70165_t - balloon.latchedEntity.field_70142_S)*partialTick);
			y = (balloon.latchedEntity.field_70137_T + (balloon.latchedEntity.field_70163_u - balloon.latchedEntity.field_70137_T)*partialTick);
			z = (balloon.latchedEntity.field_70136_U + (balloon.latchedEntity.field_70161_v - balloon.latchedEntity.field_70136_U)*partialTick);

			x += renderPosX;
			y += renderPosY;
			z += renderPosZ;

			y += balloon.getAddedHeight();
		}

		render(balloon.color, x, y, z);
	}

	public void render(EnumColor color, double x, double y, double z)
	{
		GlStateManager.func_179094_E();
		GL11.glTranslated(x, y, z);
		GlStateManager.func_179114_b(180, 1, 0, 0);

		mc.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.RENDER, "Balloon.png"));

		model.render(0.0625F, color);

		GlStateManager.func_179121_F();
	}
}
