package mekanism.client.render;

import java.util.Random;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismAPI;
import mekanism.api.Pos3D;
import mekanism.client.ClientTickHandler;
import mekanism.client.render.particle.EntityJetpackFlameFX;
import mekanism.client.render.particle.EntityJetpackSmokeFX;
import mekanism.client.render.particle.EntityScubaBubbleFX;
import mekanism.common.ColourRGBA;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemConfigurator.ConfiguratorMode;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent.Phase;
import net.minecraftforge.fml.common.gameevent.TickEvent.RenderTickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class RenderTickHandler
{
	public Random rand = new Random();
	public Minecraft mc = Minecraft.func_71410_x();
	public static int modeSwitchTimer = 0;

	@SubscribeEvent
	public void tickEnd(RenderTickEvent event)
	{
		if(event.phase == Phase.END)
		{
			if(mc.field_71439_g != null && mc.field_71441_e != null && !mc.func_147113_T())
			{
				EntityPlayer player = mc.field_71439_g;
				World world = mc.field_71439_g.field_70170_p;
				FontRenderer font = mc.field_71466_p;
				RayTraceResult pos = player.func_174822_a(40.0D, 1.0F);
				
				if(font == null)
				{
					return;
				}
	
				if(pos != null)
				{	
					Coord4D obj = new Coord4D(pos.func_178782_a(), world);
					Block block = obj.getBlock(world);
	
					if(block != null && MekanismAPI.debug && mc.field_71462_r == null && !mc.field_71474_y.field_74330_P)
					{
						String tileDisplay = "";
	
						if(obj.getTileEntity(world) != null)
						{
							if(obj.getTileEntity(world).getClass() != null)
							{
								tileDisplay = obj.getTileEntity(world).getClass().getSimpleName();
							}
						}
	
						font.func_175063_a("Block: " + block.func_149739_a(), 1, 1, 0x404040);
						font.func_175063_a("Metadata: " + obj.getBlockState(world), 1, 10, 0x404040);
						font.func_175063_a("Location: " + MekanismUtils.getCoordDisplay(obj), 1, 19, 0x404040);
						font.func_175063_a("TileEntity: " + tileDisplay, 1, 28, 0x404040);
						font.func_175063_a("Side: " + pos.field_178784_b, 1, 37, 0x404040);
					}
				}
				
				if(modeSwitchTimer > 1 && mc.field_71462_r == null && player.func_184614_ca().func_77973_b() instanceof ItemConfigurator)
				{
					ItemStack stack = player.func_184614_ca();
					ScaledResolution scaledresolution = new ScaledResolution(mc);
					ConfiguratorMode mode = ((ItemConfigurator)stack.func_77973_b()).getState(stack);
					
					int x = scaledresolution.func_78326_a();
					int y = scaledresolution.func_78328_b();
					int stringWidth = font.func_78256_a(mode.getName());
					int color = new ColourRGBA(1, 1, 1, (float)modeSwitchTimer/100F).argb();
					font.func_78276_b(mode.getColor() + mode.getName(), x/2 - stringWidth/2, y-60, color);
				}
				
				modeSwitchTimer = Math.max(modeSwitchTimer-1, 0);
				
				if(modeSwitchTimer == 0)
				{
					ClientTickHandler.wheelStatus = 0;
				}
	
				if(mc.field_71462_r == null && !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b())
				{
					ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
	
					ScaledResolution scaledresolution = new ScaledResolution(mc);
	
					int x = scaledresolution.func_78326_a();
					int y = scaledresolution.func_78328_b();
	
					if(stack.func_77973_b() instanceof ItemJetpack)
					{
						ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();
	
						font.func_175063_a("Mode: " + jetpack.getMode(stack).getName(), 1, y - 20, 0x404040);
						font.func_175063_a("Hydrogen: " + jetpack.getStored(stack), 1, y - 11, 0x404040);
					}
					else if(stack.func_77973_b() instanceof ItemScubaTank)
					{
						ItemScubaTank scubaTank = (ItemScubaTank)stack.func_77973_b();
						String state = (scubaTank.getFlowing(stack) ? EnumColor.DARK_GREEN + "On" : EnumColor.DARK_RED + "Off");
	
						font.func_175063_a("Mode: " + state, 1, y - 20, 0x404040);
						font.func_175063_a("Oxygen: " + scubaTank.getStored(stack), 1, y - 11, 0x404040);
					}
				}

				synchronized(Mekanism.jetpackOn)
				{
					for(String s : Mekanism.jetpackOn)
					{
						EntityPlayer p = mc.field_71441_e.func_72924_a(s);

						if(p == null)
						{
							continue;
						}

						Pos3D playerPos = new Pos3D(p).translate(0, 1.7, 0);
						
						float random = (rand.nextFloat() - 0.5F) * 0.1F;

						Pos3D vLeft = new Pos3D(-0.43, -0.55, -0.54).func_178789_a(p.func_70093_af() ? 20 : 0).func_178785_b(p.field_70761_aq);
						Pos3D vRight = new Pos3D(0.43, -0.55, -0.54).func_178789_a(p.func_70093_af() ? 20 : 0).func_178785_b(p.field_70761_aq);
						Pos3D vCenter = new Pos3D((rand.nextFloat() - 0.5F) * 0.4F, -0.86, -0.30).func_178789_a(p.func_70093_af() ? 25 : 0).func_178785_b(p.field_70761_aq);

						Pos3D rLeft = vLeft.func_186678_a(random);
						Pos3D rRight = vRight.func_186678_a(random);

						Pos3D mLeft = vLeft.func_186678_a(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
						Pos3D mRight = vRight.func_186678_a(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
						Pos3D mCenter = vCenter.func_186678_a(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));

						mLeft = mLeft.translate(rLeft);
						mRight = mRight.translate(rRight);

						Pos3D v = playerPos.translate(vLeft).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
						spawnAndSetParticle(EnumParticleTypes.FLAME, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mLeft.field_72450_a, mLeft.field_72448_b, mLeft.field_72449_c);
						spawnAndSetParticle(EnumParticleTypes.SMOKE_NORMAL, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mLeft.field_72450_a, mLeft.field_72448_b, mLeft.field_72449_c);

						v = playerPos.translate(vRight).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
						spawnAndSetParticle(EnumParticleTypes.FLAME, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mRight.field_72450_a, mRight.field_72448_b, mRight.field_72449_c);
						spawnAndSetParticle(EnumParticleTypes.SMOKE_NORMAL, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mRight.field_72450_a, mRight.field_72448_b, mRight.field_72449_c);

						v = playerPos.translate(vCenter).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
						spawnAndSetParticle(EnumParticleTypes.FLAME, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mCenter.field_72450_a, mCenter.field_72448_b, mCenter.field_72449_c);
						spawnAndSetParticle(EnumParticleTypes.SMOKE_NORMAL, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mCenter.field_72450_a, mCenter.field_72448_b, mCenter.field_72449_c);
					}
				}
				
				synchronized(Mekanism.gasmaskOn)
				{
					if(world.func_72820_D() % 4 == 0)
					{
						for(String s : Mekanism.gasmaskOn)
						{
							EntityPlayer p = mc.field_71441_e.func_72924_a(s);
	
							if(p == null || !p.func_70090_H())
							{
								continue;
							}
							
							Pos3D playerPos = new Pos3D(p).translate(0, 1.7, 0);
							
							float xRand = (rand.nextFloat() - 0.5F) * 0.08F;
							float yRand = (rand.nextFloat() - 0.5F) * 0.05F;
							
							Pos3D vec = new Pos3D(0.4, 0.4, 0.4).multiply(new Pos3D(p.func_70676_i(1))).translate(0, -0.2, 0);
							Pos3D motion = vec.func_186678_a(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
							
							Pos3D v = playerPos.translate(vec);
							spawnAndSetParticle(EnumParticleTypes.WATER_BUBBLE, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.2, motion.field_72449_c);
						}
					}
				}
				
				if(world.func_72820_D() % 4 == 0)
				{
					for(EntityPlayer p : world.field_73010_i)
					{
						if(!Mekanism.flamethrowerActive.contains(p.func_70005_c_()) && !p.field_82175_bq && !p.field_71071_by.func_70448_g().func_190926_b() && p.field_71071_by.func_70448_g().func_77973_b() instanceof ItemFlamethrower)
						{
							if(((ItemFlamethrower)p.field_71071_by.func_70448_g().func_77973_b()).getGas(p.field_71071_by.func_70448_g()) != null)
							{
								Pos3D playerPos = new Pos3D(p);
								Pos3D flameVec;

								double flameXCoord = 0;
								double flameYCoord = 1.5;
								double flameZCoord = 0;
								
								Pos3D flameMotion = new Pos3D(p.field_70159_w, p.field_70122_E ? 0 : p.field_70181_x, p.field_70179_y);
								
								if(player == p && mc.field_71474_y.field_74320_O == 0)
								{
									flameVec = new Pos3D(1, 1, 1).multiply(p.func_70676_i(1)).func_178785_b(5).translate(flameXCoord, flameYCoord+0.1, flameZCoord);
								}
								else {
									flameXCoord += 0.25F;
									flameXCoord -= 0.45F;
									flameZCoord += 0.15F;
									
									if(p.func_70093_af())
									{
										flameYCoord -= 0.55F;
										flameZCoord -= 0.15F;
									}
									
									if(player == p)
									{
										flameYCoord -= 0.5F;
									}
									else {
										flameYCoord -= 0.5F;
									}
									
									flameZCoord += 1.05F;
									
									flameVec = new Pos3D(flameXCoord, flameYCoord, flameZCoord).func_178785_b(p.field_70761_aq);
								}
								
								Pos3D mergedVec = playerPos.translate(flameVec);
								
								spawnAndSetParticle(EnumParticleTypes.FLAME, world, mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c, flameMotion.field_72450_a, flameMotion.field_72448_b, flameMotion.field_72449_c);
							}
						}
					}
				}
			}
		}
	}

	public void spawnAndSetParticle(EnumParticleTypes s, World world, double x, double y, double z, double velX, double velY, double velZ)
	{
		Particle fx = null;

		if(s.equals(EnumParticleTypes.FLAME))
		{
			fx = new EntityJetpackFlameFX(world, x, y, z, velX, velY, velZ);
		}
		else if(s.equals(EnumParticleTypes.SMOKE_NORMAL))
		{
			fx = new EntityJetpackSmokeFX(world, x, y, z, velX, velY, velZ);
		}
		else if(s.equals(EnumParticleTypes.WATER_BUBBLE))
		{
			fx = new EntityScubaBubbleFX(world, x, y, z, velX, velY, velZ);
		}

		mc.field_71452_i.func_78873_a(fx);
	}
}
