package mekanism.client.render;

import mekanism.client.model.ModelArmoredJetpack;
import mekanism.client.model.ModelFreeRunners;
import mekanism.client.model.ModelGasMask;
import mekanism.client.model.ModelJetpack;
import mekanism.client.model.ModelScubaTank;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelCustomArmor extends ModelBiped
{
	public static ModelCustomArmor INSTANCE = new ModelCustomArmor();

	public static GlowArmor GLOW_BIG = new GlowArmor(1.0F);
	public static GlowArmor GLOW_SMALL = new GlowArmor(0.5F);

	public static Minecraft mc = Minecraft.func_71410_x();

	public ArmorModel modelType;

	public ModelCustomArmor()
	{
		resetPart(field_78116_c, 0, 0, 0);
		resetPart(field_78115_e, 0, 0, 0);
		resetPart(field_178723_h, 5, 2, 0);
		resetPart(field_178724_i, -5, 2, 0);
		resetPart(field_178721_j, 0, 0, 0);
		resetPart(field_178722_k, 0, 0, 0);

		field_178720_f.field_78804_l.clear();
	}

	public void init(Entity entity, float f, float f1, float f2, float f3, float f4, float size)
	{
		reset();

		field_78117_n = entity.func_70093_af();
		field_78093_q = entity.func_184218_aH();

		if(entity instanceof EntityLivingBase)
		{
			field_78091_s = ((EntityLivingBase)entity).func_70631_g_();
		}

		if(modelType.armorSlot == 0)
		{
			field_78116_c.field_78807_k = false;
			field_78116_c.field_78806_j = true;
		}
		else if(modelType.armorSlot == 1)
		{
			field_78115_e.field_78807_k = false;
			field_78115_e.field_78806_j = true;
		}
		else if(modelType.armorSlot == 3)
		{
			field_178722_k.field_78807_k = false;
			field_178722_k.field_78806_j = true;
			field_178721_j.field_78807_k = false;
			field_178721_j.field_78806_j = true;
		}

		func_78087_a(f, f1, f2, f3, f4, size, entity);
	}

	public void reset()
	{
		field_78116_c.field_78807_k = true;
		field_78115_e.field_78807_k = true;
		field_178723_h.field_78807_k = true;
		field_178724_i.field_78807_k = true;
		field_178721_j.field_78807_k = true;
		field_178722_k.field_78807_k = true;

		field_78116_c.field_78806_j = false;
		field_78115_e.field_78806_j = false;
		field_178723_h.field_78806_j = false;
		field_178724_i.field_78806_j = false;
		field_178721_j.field_78806_j = false;
		field_178722_k.field_78806_j = false;
	}

	public void resetPart(ModelRenderer renderer, float x, float y, float z)
	{
		renderer.field_78804_l.clear();
		ModelCustom model = new ModelCustom(this, renderer);
		renderer.func_78792_a(model);
		setOffset(renderer, x, y, z);
	}

	public void setOffset(ModelRenderer renderer, float x, float y, float z)
	{
		renderer.field_82906_o = x;
		renderer.field_82908_p = y;
		renderer.field_82907_q = z;
	}

	public class ModelCustom extends ModelRenderer
	{
		public ModelCustomArmor biped;
		public ModelRenderer partRender;

		public ModelCustom(ModelCustomArmor base, ModelRenderer renderer)
		{
			super(base);
			biped = base;
			partRender = renderer;
		}

		@Override
		public void func_78785_a(float size)
		{
			if(ModelCustomArmor.this.modelType != null)
			{
				GlStateManager.func_179094_E();
				GlStateManager.func_179109_b(0, 0, 0.06F);

				mc.field_71446_o.func_110577_a(modelType.resource);

				if(useModel(biped.modelType, partRender, biped))
				{
					if(biped.modelType == ArmorModel.JETPACK)
					{
						ArmorModel.jetpackModel.render(0.0625F);
					}
					else if(biped.modelType == ArmorModel.ARMOREDJETPACK)
					{
						ArmorModel.armoredJetpackModel.render(0.0625F);
					}
					else if(biped.modelType == ArmorModel.SCUBATANK)
					{
						ArmorModel.scubaTankModel.render(0.0625F);
					}
					else if(biped.modelType == ArmorModel.GASMASK)
					{
						GlStateManager.func_179109_b(0, 0, -0.05F);
						ArmorModel.gasMaskModel.render(0.0625F);
					}
					else if(biped.modelType == ArmorModel.FREERUNNERS)
					{
						GlStateManager.func_179152_a(1.02F, 1.02F, 1.02F);

						if(partRender == biped.field_178722_k)
						{
							GlStateManager.func_179109_b(-0.1375F, -0.75F, -0.0625F);
							ArmorModel.freeRunnersModel.renderLeft(0.0625F);
						}
						else if(partRender == biped.field_178721_j)
						{
							GlStateManager.func_179109_b(0.1375F, -0.75F, -0.0625F);
							ArmorModel.freeRunnersModel.renderRight(0.0625F);
						}
					}
				}

				GlStateManager.func_179121_F();
			}
		}
	}

	@Override
	public void func_78088_a(Entity entity, float par2, float par3, float par4, float par5, float par6, float par7)
	{
		init(entity, par2, par3, par4, par5, par6, par7);
		super.func_78088_a(entity, par2, par3, par4, par5, par6, par7);
	}

	public static boolean useModel(ArmorModel type, ModelRenderer partRender, ModelCustomArmor biped)
	{
		if(type.armorSlot == 0)
		{
			return partRender == biped.field_78116_c;
		}
		else if(type.armorSlot == 1)
		{
			return partRender == biped.field_78115_e;
		}
		else if(type.armorSlot == 3)
		{
			return partRender == biped.field_178722_k || partRender == biped.field_178721_j;
		}

		return false;
	}

	public static enum ArmorModel
	{
		JETPACK(1, MekanismUtils.getResource(ResourceType.RENDER, "Jetpack.png")),
		ARMOREDJETPACK(1, MekanismUtils.getResource(ResourceType.RENDER, "Jetpack.png")),
		SCUBATANK(1, MekanismUtils.getResource(ResourceType.RENDER, "ScubaSet.png")),
		GASMASK(0, MekanismUtils.getResource(ResourceType.RENDER, "ScubaSet.png")),
		FREERUNNERS(3, MekanismUtils.getResource(ResourceType.RENDER, "FreeRunners.png"));

		public int armorSlot;
		public ResourceLocation resource;

		public static ModelJetpack jetpackModel = new ModelJetpack();
		public static ModelArmoredJetpack armoredJetpackModel = new ModelArmoredJetpack();
		public static ModelGasMask gasMaskModel = new ModelGasMask();
		public static ModelScubaTank scubaTankModel = new ModelScubaTank();
		public static ModelFreeRunners freeRunnersModel = new ModelFreeRunners();

		private ArmorModel(int i, ResourceLocation r)
		{
			armorSlot = i;
			resource = r;
		}
	}

	public static ModelBiped getGlow(EntityEquipmentSlot index)
	{
		ModelBiped biped = index != EntityEquipmentSlot.LEGS ? GLOW_BIG : GLOW_SMALL;

		biped.field_78116_c.field_78806_j = index == EntityEquipmentSlot.HEAD;
		biped.field_178720_f.field_78806_j = index == EntityEquipmentSlot.HEAD;
		biped.field_78115_e.field_78806_j = index == EntityEquipmentSlot.CHEST || index == EntityEquipmentSlot.LEGS;
		biped.field_178723_h.field_78806_j = index == EntityEquipmentSlot.CHEST;
		biped.field_178724_i.field_78806_j = index == EntityEquipmentSlot.CHEST;
		biped.field_178721_j.field_78806_j = index == EntityEquipmentSlot.LEGS || index == EntityEquipmentSlot.FEET;
		biped.field_178722_k.field_78806_j = index == EntityEquipmentSlot.LEGS || index == EntityEquipmentSlot.FEET;

		return biped;
	}

	public static class GlowArmor extends ModelBiped
	{
		public GlowArmor(float size)
		{
			super(size);
		}

		@Override
		public void func_78088_a(Entity entity, float par2, float par3, float par4, float par5, float par6, float par7)
		{
			field_78117_n = entity.func_70093_af();
			field_78093_q = entity.func_184218_aH();

			if(entity instanceof EntityLivingBase)
			{
				field_78091_s = ((EntityLivingBase)entity).func_70631_g_();
			}

			func_78087_a(par2, par3, par4, par5, par6, par7, entity);

			MekanismRenderer.glowOn();
			super.func_78088_a(entity, par2, par3, par4, par5, par6, par7);
			MekanismRenderer.glowOff();
		}
	}
}
