package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelSecurityDesk extends ModelBase
{
	public static ResourceLocation OVERLAY = MekanismUtils.getResource(ResourceType.RENDER, "SecurityDesk_Overlay.png");
	
	ModelRenderer deskTop;
	ModelRenderer deskBase;
	ModelRenderer led;
	ModelRenderer monitorBack;
	ModelRenderer keyboard;
	ModelRenderer monitor;
	ModelRenderer standNeck;
	ModelRenderer standBase;
	ModelRenderer deskMiddle;
	ModelRenderer monitorScreen;

	public ModelSecurityDesk()
	{
		field_78090_t = 128;
		field_78089_u = 64;

		deskTop = new ModelRenderer(this, 0, 0);
		deskTop.func_78789_a(0F, 0F, 0F, 16, 7, 16);
		deskTop.func_78793_a(-8F, 11F, -8F);
		deskTop.func_78787_b(128, 64);
		deskTop.field_78809_i = true;
		setRotation(deskTop, 0F, 0F, 0F);
		deskBase = new ModelRenderer(this, 0, 38);
		deskBase.func_78789_a(0F, 0F, 0F, 16, 5, 16);
		deskBase.func_78793_a(-8F, 19F, -8F);
		deskBase.func_78787_b(128, 64);
		deskBase.field_78809_i = true;
		setRotation(deskBase, 0F, 0F, 0F);
		led = new ModelRenderer(this, 0, 0);
		led.func_78789_a(12F, 4.5F, -1.5F, 1, 1, 1);
		led.func_78793_a(-7F, 5F, 4F);
		led.func_78787_b(128, 64);
		led.field_78809_i = true;
		setRotation(led, -0.4712389F, 0F, 0F);
		monitorBack = new ModelRenderer(this, 82, 0);
		monitorBack.func_78789_a(1F, -3F, 0F, 12, 6, 1);
		monitorBack.func_78793_a(-7F, 5F, 4F);
		monitorBack.func_78787_b(128, 64);
		monitorBack.field_78809_i = true;
		setRotation(monitorBack, -0.4712389F, 0F, 0F);
		keyboard = new ModelRenderer(this, 64, 27);
		keyboard.func_78789_a(0F, 0F, 0F, 10, 1, 5);
		keyboard.func_78793_a(-5F, 10.5F, -6F);
		keyboard.func_78787_b(128, 64);
		keyboard.field_78809_i = true;
		setRotation(keyboard, 0.0872665F, 0F, 0F);
		monitor = new ModelRenderer(this, 64, 10);
		monitor.func_78789_a(0F, -5F, -2F, 14, 10, 2);
		monitor.func_78793_a(-7F, 5F, 4F);
		monitor.func_78787_b(128, 64);
		monitor.field_78809_i = true;
		setRotation(monitor, -0.4712389F, 0F, 0F);
		standNeck = new ModelRenderer(this, 96, 7);
		standNeck.func_78789_a(0F, -7F, -1F, 2, 7, 1);
		standNeck.func_78793_a(-1F, 10F, 6F);
		standNeck.func_78787_b(128, 64);
		standNeck.field_78809_i = true;
		setRotation(standNeck, 0.0698132F, 0F, 0F);
		standBase = new ModelRenderer(this, 64, 22);
		standBase.func_78789_a(0F, 0F, -4F, 8, 1, 4);
		standBase.func_78793_a(-4F, 10F, 6F);
		standBase.func_78787_b(128, 64);
		standBase.field_78809_i = true;
		setRotation(standBase, 0.1047198F, 0F, 0F);
		deskMiddle = new ModelRenderer(this, 0, 23);
		deskMiddle.func_78789_a(0F, 0F, 0F, 14, 1, 14);
		deskMiddle.func_78793_a(-7F, 18F, -7F);
		deskMiddle.func_78787_b(128, 64);
		deskMiddle.field_78809_i = true;
		setRotation(deskMiddle, 0F, 0F, 0F);
		monitorScreen = new ModelRenderer(this, 64, 33);
		monitorScreen.func_78789_a(0.5F, -4.5F, -2.01F, 13, 9, 2);
		monitorScreen.func_78793_a(-7F, 5F, 4F);
		monitorScreen.func_78787_b(128, 64);
		monitorScreen.field_78809_i = true;
		setRotation(monitorScreen, -0.4712389F, 0F, 0F);
	}

	public void render(float size, TextureManager manager)
	{
		GlStateManager.func_179094_E();
		MekanismRenderer.blendOn();
		
		doRender(size);
		
		manager.func_110577_a(OVERLAY);
		GlStateManager.func_179152_a(1.001F, 1.001F, 1.001F);
		GlStateManager.func_179109_b(0, -0.0011F, 0);
		MekanismRenderer.glowOn();
		
		doRender(size);
		
		MekanismRenderer.glowOff();
		MekanismRenderer.blendOff();
		GlStateManager.func_179121_F();
	}
	
	private void doRender(float size)
	{
		deskTop.func_78785_a(size);
		deskBase.func_78785_a(size);
		led.func_78785_a(size);
		monitorBack.func_78785_a(size);
		keyboard.func_78785_a(size);
		monitor.func_78785_a(size);
		standNeck.func_78785_a(size);
		standBase.func_78785_a(size);
		deskMiddle.func_78785_a(size);
		monitorScreen.func_78785_a(size);
	}

	private void setRotation(ModelRenderer model, float x, float y, float z) 
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
