package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelRobit extends ModelBase
{
	public ModelRenderer Body;
	public ModelRenderer Bottom;
	public ModelRenderer RightTrack;
	public ModelRenderer LeftTrack;
	public ModelRenderer Neck;
	public ModelRenderer Head;
	public ModelRenderer Backpack;
	public ModelRenderer headback;
	public ModelRenderer rightarn;
	public ModelRenderer leftarm;
	public ModelRenderer righthand;
	public ModelRenderer lefthand;
	public ModelRenderer backLight;
	public ModelRenderer eyeRight;
	public ModelRenderer eyeLeft;

	public ModelRobit()
	{
		field_78090_t = 64;
		field_78089_u = 64;

		Body = new ModelRenderer(this, 0, 0);
		Body.func_78789_a(0F, 0F, 1F, 6, 4, 5);
		Body.func_78793_a(-3F, 17F, -3F);
		Body.func_78787_b(64, 64);
		Body.field_78809_i = true;
		setRotation(Body, 0F, 0F, 0F);
		Bottom = new ModelRenderer(this, 22, 0);
		Bottom.func_78789_a(0F, 0F, 0F, 6, 2, 7);
		Bottom.func_78793_a(-3F, 21F, -2.5F);
		Bottom.func_78787_b(64, 64);
		Bottom.field_78809_i = true;
		setRotation(Bottom, 0F, 0F, 0F);
		RightTrack = new ModelRenderer(this, 26, 9);
		RightTrack.func_78789_a(0F, 0F, 0F, 2, 3, 9);
		RightTrack.func_78793_a(3F, 21F, -4F);
		RightTrack.func_78787_b(64, 64);
		RightTrack.field_78809_i = true;
		setRotation(RightTrack, 0F, 0F, 0F);
		LeftTrack = new ModelRenderer(this, 0, 9);
		LeftTrack.func_78789_a(0F, 0F, 0F, 2, 3, 9);
		LeftTrack.func_78793_a(-5F, 21F, -4F);
		LeftTrack.func_78787_b(64, 64);
		LeftTrack.field_78809_i = true;
		setRotation(LeftTrack, 0F, 0F, 0F);
		Neck = new ModelRenderer(this, 0, 26);
		Neck.func_78789_a(0F, 0F, 0F, 3, 1, 2);
		Neck.func_78793_a(-1.5F, 16F, -0.5F);
		Neck.func_78787_b(64, 64);
		Neck.field_78809_i = true;
		setRotation(Neck, 0F, 0F, 0F);
		Head = new ModelRenderer(this, 26, 21);
		Head.func_78789_a(0F, 0F, 0F, 7, 3, 4);
		Head.func_78793_a(-3.5F, 13.5F, -1.533333F);
		Head.func_78787_b(64, 64);
		Head.field_78809_i = true;
		setRotation(Head, 0F, 0F, 0F);
		Backpack = new ModelRenderer(this, 14, 9);
		Backpack.func_78789_a(0F, 0F, 0F, 4, 3, 6);
		Backpack.func_78793_a(-2F, 16.8F, -4F);
		Backpack.func_78787_b(64, 64);
		Backpack.field_78809_i = true;
		setRotation(Backpack, 0F, 0F, 0F);
		headback = new ModelRenderer(this, 17, 1);
		headback.func_78789_a(0F, 0F, 0F, 5, 2, 1);
		headback.func_78793_a(-2.5F, 14F, -2F);
		headback.func_78787_b(64, 64);
		headback.field_78809_i = true;
		setRotation(headback, 0F, 0F, 0F);
		rightarn = new ModelRenderer(this, 0, 21);
		rightarn.func_78789_a(0F, 0F, 0F, 1, 1, 4);
		rightarn.func_78793_a(3F, 17.5F, 0F);
		rightarn.func_78787_b(64, 64);
		rightarn.field_78809_i = true;
		setRotation(rightarn, 0F, 0F, 0F);
		leftarm = new ModelRenderer(this, 12, 21);
		leftarm.func_78789_a(0F, 0F, 0F, 1, 1, 4);
		leftarm.func_78793_a(-4F, 17.5F, 0F);
		leftarm.func_78787_b(64, 64);
		leftarm.field_78809_i = true;
		setRotation(leftarm, 0F, 0F, 0F);
		righthand = new ModelRenderer(this, 15, 28);
		righthand.func_78789_a(0F, 0F, 0F, 1, 1, 0);
		righthand.func_78793_a(2.5F, 17.5F, 4F);
		righthand.func_78787_b(64, 64);
		righthand.field_78809_i = true;
		setRotation(righthand, 0F, 0F, 0F);
		lefthand = new ModelRenderer(this, 15, 28);
		lefthand.func_78789_a(0F, 0F, 0F, 1, 1, 0);
		lefthand.func_78793_a(-3.5F, 17.5F, 4F);
		lefthand.func_78787_b(64, 64);
		lefthand.field_78809_i = true;
		setRotation(lefthand, 0F, 0F, 0F);
		backLight = new ModelRenderer(this, 20, 15);
		backLight.func_78789_a(0F, 0F, 0F, 2, 1, 1);
		backLight.func_78793_a(-1F, 17.8F, -4.001F);
		backLight.func_78787_b(64, 64);
		backLight.field_78809_i = true;
		setRotation(backLight, 0F, 0F, 0F);
		eyeRight = new ModelRenderer(this, 43, 25);
		eyeRight.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		eyeRight.func_78793_a(1.5F, 14.5F, 1.50001F);
		eyeRight.func_78787_b(64, 64);
		eyeRight.field_78809_i = true;
		setRotation(eyeRight, 0F, 0F, 0F);
		eyeLeft = new ModelRenderer(this, 43, 25);
		eyeLeft.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		eyeLeft.func_78793_a(-2.5F, 14.5F, 1.50001F);
		eyeLeft.func_78787_b(64, 64);
		eyeLeft.field_78809_i = true;
		setRotation(eyeLeft, 0F, 0F, 0F);
	}

	@Override
	public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
	{
		super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
		func_78087_a(f, f1, f2, f3, f4, f5, entity);

		GlStateManager.func_179094_E();
		GlStateManager.func_179114_b(180, 0.0F, 1.0F, 0.0F);

		Body.func_78785_a(f5);
		Bottom.func_78785_a(f5);
		RightTrack.func_78785_a(f5);
		LeftTrack.func_78785_a(f5);
		Neck.func_78785_a(f5);
		Head.func_78785_a(f5);
		Backpack.func_78785_a(f5);
		headback.func_78785_a(f5);
		rightarn.func_78785_a(f5);
		leftarm.func_78785_a(f5);
		righthand.func_78785_a(f5);
		lefthand.func_78785_a(f5);

		MekanismRenderer.glowOn();
		backLight.func_78785_a(f5);
		eyeRight.func_78785_a(f5);
		eyeLeft.func_78785_a(f5);
		MekanismRenderer.glowOff();

		GlStateManager.func_179121_F();
	}

	public void render(float size)
	{
		Body.func_78785_a(size);
		Bottom.func_78785_a(size);
		RightTrack.func_78785_a(size);
		LeftTrack.func_78785_a(size);
		Neck.func_78785_a(size);
		Head.func_78785_a(size);
		Backpack.func_78785_a(size);
		headback.func_78785_a(size);
		rightarn.func_78785_a(size);
		leftarm.func_78785_a(size);
		righthand.func_78785_a(size);
		lefthand.func_78785_a(size);
		backLight.func_78785_a(size);
		eyeRight.func_78785_a(size);
		eyeLeft.func_78785_a(size);
	}

	private void setRotation(ModelRenderer model, float x, float y, float z)
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
