package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelResistiveHeater extends ModelBase
{
	public static ResourceLocation OVERLAY_ON = MekanismUtils.getResource(ResourceType.RENDER, "ResistiveHeater_OverlayOn.png");
	public static ResourceLocation OVERLAY_OFF = MekanismUtils.getResource(ResourceType.RENDER, "ResistiveHeater_OverlayOff.png");
	
	ModelRenderer wallLeft;
	ModelRenderer base;
	ModelRenderer fin10;
	ModelRenderer portRight;
	ModelRenderer fin9;
	ModelRenderer fin2;
	ModelRenderer bar2;
	ModelRenderer fin4;
	ModelRenderer fin3;
	ModelRenderer fin6;
	ModelRenderer center;
	ModelRenderer fin8;
	ModelRenderer fin7;
	ModelRenderer fin5;
	ModelRenderer fin1;
	ModelRenderer bar1;
	ModelRenderer bar4;
	ModelRenderer bar3;
	ModelRenderer wallRight;
	ModelRenderer portLeft;

	public ModelResistiveHeater()
	{
		field_78090_t = 128;
		field_78089_u = 64;

		wallLeft = new ModelRenderer(this, 0, 23);
		wallLeft.field_78809_i = true;
		wallLeft.func_78789_a(0F, 0F, 0F, 3, 9, 16);
		wallLeft.func_78793_a(5F, 8F, -8F);
		wallLeft.func_78787_b(128, 64);
		setRotation(wallLeft, 0F, 0F, 0F);
		base = new ModelRenderer(this, 0, 0);
		base.func_78789_a(0F, 0F, 0F, 16, 7, 16);
		base.func_78793_a(-8F, 17F, -8F);
		base.func_78787_b(128, 64);
		base.field_78809_i = true;
		setRotation(base, 0F, 0F, 0F);
		fin10 = new ModelRenderer(this, 38, 38);
		fin10.field_78809_i = true;
		fin10.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin10.func_78793_a(-5F, 8.5F, 6.5F);
		fin10.func_78787_b(128, 64);
		setRotation(fin10, 0F, 0F, 0F);
		portRight = new ModelRenderer(this, 48, 0);
		portRight.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		portRight.func_78793_a(-8.01F, 12F, -4F);
		portRight.func_78787_b(128, 64);
		portRight.field_78809_i = true;
		setRotation(portRight, 0F, 0F, 0F);
		fin9 = new ModelRenderer(this, 0, 48);
		fin9.field_78809_i = true;
		fin9.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin9.func_78793_a(-5F, 8.5F, 5F);
		fin9.func_78787_b(128, 64);
		setRotation(fin9, 0F, 0F, 0F);
		fin2 = new ModelRenderer(this, 0, 48);
		fin2.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin2.func_78793_a(-5F, 8.5F, -6F);
		fin2.func_78787_b(128, 64);
		fin2.field_78809_i = true;
		setRotation(fin2, 0F, 0F, 0F);
		bar2 = new ModelRenderer(this, 36, 23);
		bar2.func_78789_a(0F, 0F, 0F, 1, 1, 13);
		bar2.func_78793_a(-2F, 9.5F, -6.5F);
		bar2.func_78787_b(128, 64);
		bar2.field_78809_i = true;
		setRotation(bar2, 0F, 0F, 0F);
		fin4 = new ModelRenderer(this, 0, 48);
		fin4.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin4.func_78793_a(-5F, 8.5F, -3F);
		fin4.func_78787_b(128, 64);
		fin4.field_78809_i = true;
		setRotation(fin4, 0F, 0F, 0F);
		fin3 = new ModelRenderer(this, 0, 48);
		fin3.field_78809_i = true;
		fin3.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin3.func_78793_a(-5F, 8.5F, -4.5F);
		fin3.func_78787_b(128, 64);
		setRotation(fin3, 0F, 0F, 0F);
		fin6 = new ModelRenderer(this, 0, 48);
		fin6.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin6.func_78793_a(-5F, 8.5F, 0.5F);
		fin6.func_78787_b(128, 64);
		fin6.field_78809_i = true;
		setRotation(fin6, 0F, 0F, 0F);
		center = new ModelRenderer(this, 0, 0);
		center.func_78789_a(0F, 0F, 0F, 6, 6, 1);
		center.func_78793_a(-3F, 11.5F, -0.5F);
		center.func_78787_b(128, 64);
		center.field_78809_i = true;
		setRotation(center, 0F, 0F, 0F);
		fin8 = new ModelRenderer(this, 0, 48);
		fin8.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin8.func_78793_a(-5F, 8.5F, 3.5F);
		fin8.func_78787_b(128, 64);
		fin8.field_78809_i = true;
		setRotation(fin8, 0F, 0F, 0F);
		fin7 = new ModelRenderer(this, 0, 48);
		fin7.field_78809_i = true;
		fin7.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin7.func_78793_a(-5F, 8.5F, 2F);
		fin7.func_78787_b(128, 64);
		setRotation(fin7, 0F, 0F, 0F);
		fin5 = new ModelRenderer(this, 0, 48);
		fin5.field_78809_i = true;
		fin5.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin5.func_78793_a(-5F, 8.5F, -1.5F);
		fin5.func_78787_b(128, 64);
		setRotation(fin5, 0F, 0F, 0F);
		fin1 = new ModelRenderer(this, 22, 48);
		fin1.func_78789_a(0F, 0F, 0F, 10, 9, 1);
		fin1.func_78793_a(-5F, 8.5F, -7.5F);
		fin1.func_78787_b(128, 64);
		fin1.field_78809_i = true;
		setRotation(fin1, 0F, 0F, 0F);
		bar1 = new ModelRenderer(this, 36, 23);
		bar1.func_78789_a(0F, 0F, 0F, 1, 1, 13);
		bar1.func_78793_a(-4F, 9.5F, -6.5F);
		bar1.func_78787_b(128, 64);
		bar1.field_78809_i = true;
		setRotation(bar1, 0F, 0F, 0F);
		bar4 = new ModelRenderer(this, 36, 23);
		bar4.func_78789_a(0F, 0F, 0F, 1, 1, 13);
		bar4.func_78793_a(3F, 9.5F, -6.5F);
		bar4.func_78787_b(128, 64);
		bar4.field_78809_i = true;
		setRotation(bar4, 0F, 0F, 0F);
		bar3 = new ModelRenderer(this, 36, 23);
		bar3.func_78789_a(0F, 0F, 0F, 1, 1, 13);
		bar3.func_78793_a(1F, 9.5F, -6.5F);
		bar3.func_78787_b(128, 64);
		bar3.field_78809_i = true;
		setRotation(bar3, 0F, 0F, 0F);
		wallRight = new ModelRenderer(this, 0, 23);
		wallRight.func_78789_a(0F, 0F, 0F, 3, 9, 16);
		wallRight.func_78793_a(-8F, 8F, -8F);
		wallRight.func_78787_b(128, 64);
		wallRight.field_78809_i = true;
		setRotation(wallRight, 0F, 0F, 0F);
		portLeft = new ModelRenderer(this, 48, 0);
		portLeft.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		portLeft.func_78793_a(7.01F, 12F, -4F);
		portLeft.func_78787_b(128, 64);
		portLeft.field_78809_i = true;
		setRotation(portLeft, 0F, 0F, 0F);
	}
	
	public void render(float size, boolean on, TextureManager manager, boolean renderMain)
	{
		GlStateManager.func_179094_E();
		MekanismRenderer.blendOn();
		
		if(renderMain)
		{
			doRender(size);
		}
		
		manager.func_110577_a(on ? OVERLAY_ON : OVERLAY_OFF);
		GlStateManager.func_179152_a(1.001F, 1.001F, 1.001F);
		GlStateManager.func_179109_b(0, -0.0011F, 0);
		MekanismRenderer.glowOn();
		
		doRender(size);
		
		MekanismRenderer.glowOff();
		MekanismRenderer.blendOff();
		GlStateManager.func_179121_F();
	}

	private void doRender(float size)
	{
		wallLeft.func_78785_a(size);
		base.func_78785_a(size);
		fin10.func_78785_a(size);
		portRight.func_78785_a(size);
		fin9.func_78785_a(size);
		fin2.func_78785_a(size);
		bar2.func_78785_a(size);
		fin4.func_78785_a(size);
		fin3.func_78785_a(size);
		fin6.func_78785_a(size);
		center.func_78785_a(size);
		fin8.func_78785_a(size);
		fin7.func_78785_a(size);
		fin5.func_78785_a(size);
		fin1.func_78785_a(size);
		bar1.func_78785_a(size);
		bar4.func_78785_a(size);
		bar3.func_78785_a(size);
		wallRight.func_78785_a(size);
		portLeft.func_78785_a(size);
	}

	private void setRotation(ModelRenderer model, float x, float y, float z) 
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
