package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelQuantumEntangloporter extends ModelBase 
{
	public static ResourceLocation OVERLAY = MekanismUtils.getResource(ResourceType.RENDER, "QuantumEntangloporter_Overlay.png");
	
	ModelRenderer portTop;
	ModelRenderer portBottom;
	ModelRenderer portLeft;
	ModelRenderer portRight;
	ModelRenderer portBack;
	ModelRenderer portFront;
	ModelRenderer energyCubeCore;
	ModelRenderer frameEdge1;
	ModelRenderer frameEdge2;
	ModelRenderer frameEdge3;
	ModelRenderer frameEdge4;
	ModelRenderer frameEdge5;
	ModelRenderer frameEdge6;
	ModelRenderer frameEdge7;
	ModelRenderer frameEdge8;
	ModelRenderer frameEdge9;
	ModelRenderer frameEdge10;
	ModelRenderer frameEdge11;
	ModelRenderer frameEdge12;
	ModelRenderer frame1;
	ModelRenderer frame2;
	ModelRenderer frame3;
	ModelRenderer frame4;
	ModelRenderer frame5;
	ModelRenderer frame6;
	ModelRenderer frame7;
	ModelRenderer frame8;
	ModelRenderer frame9;
	ModelRenderer frame10;
	ModelRenderer frame11;
	ModelRenderer frame12;
	ModelRenderer corner1;
	ModelRenderer corner2;
	ModelRenderer corner3;
	ModelRenderer corner4;
	ModelRenderer corner5;
	ModelRenderer corner6;
	ModelRenderer corner7;
	ModelRenderer corner8;
	ModelRenderer portRightLarge;
	ModelRenderer portLeftLarge;

	public ModelQuantumEntangloporter() 
	{
		field_78090_t = 128;
		field_78089_u = 64;

		portTop = new ModelRenderer(this, 36, 0);
		portTop.func_78789_a(0F, 0F, 0F, 8, 1, 8);
		portTop.func_78793_a(-4F, 8F, -4F);
		portTop.func_78787_b(128, 64);
		portTop.field_78809_i = true;
		setRotation(portTop, 0F, 0F, 0F);
		portBottom = new ModelRenderer(this, 36, 9);
		portBottom.func_78789_a(0F, 0F, 0F, 8, 1, 8);
		portBottom.func_78793_a(-4F, 23F, -4F);
		portBottom.func_78787_b(128, 64);
		portBottom.field_78809_i = true;
		setRotation(portBottom, 0F, 0F, 0F);
		portLeft = new ModelRenderer(this, 0, 0);
		portLeft.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		portLeft.func_78793_a(-8F, 12F, -4F);
		portLeft.func_78787_b(128, 64);
		portLeft.field_78809_i = true;
		setRotation(portLeft, 0F, 0F, 0F);
		portRight = new ModelRenderer(this, 0, 0);
		portRight.field_78809_i = true;
		portRight.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		portRight.func_78793_a(7F, 12F, -4F);
		portRight.func_78787_b(128, 64);
		setRotation(portRight, 0F, 0F, 0F);
		portBack = new ModelRenderer(this, 18, 9);
		portBack.func_78789_a(0F, 0F, 0F, 8, 8, 1);
		portBack.func_78793_a(-4F, 12F, 7F);
		portBack.func_78787_b(128, 64);
		portBack.field_78809_i = true;
		setRotation(portBack, 0F, 0F, 0F);
		portFront = new ModelRenderer(this, 18, 0);
		portFront.func_78789_a(0F, 0F, 0F, 8, 8, 1);
		portFront.func_78793_a(-4F, 12F, -8F);
		portFront.func_78787_b(128, 64);
		portFront.field_78809_i = true;
		setRotation(portFront, 0F, 0F, 0F);
		energyCubeCore = new ModelRenderer(this, 0, 41);
		energyCubeCore.func_78789_a(-2F, -2F, -2F, 4, 4, 4);
		energyCubeCore.func_78793_a(0F, 16F, 0F);
		energyCubeCore.func_78787_b(128, 64);
		energyCubeCore.field_78809_i = true;
		setRotation(energyCubeCore, 0.7132579F, 0.403365F, 0.645384F);
		frameEdge1 = new ModelRenderer(this, 0, 16);
		frameEdge1.func_78789_a(0F, 0F, 0F, 1, 10, 1);
		frameEdge1.func_78793_a(-7.5F, 11F, -7.5F);
		frameEdge1.func_78787_b(128, 64);
		frameEdge1.field_78809_i = true;
		setRotation(frameEdge1, 0F, 0F, 0F);
		frameEdge2 = new ModelRenderer(this, 0, 16);
		frameEdge2.func_78789_a(0F, 0F, 0F, 1, 10, 1);
		frameEdge2.func_78793_a(6.5F, 11F, -7.5F);
		frameEdge2.func_78787_b(128, 64);
		frameEdge2.field_78809_i = true;
		setRotation(frameEdge2, 0F, 0F, 0F);
		frameEdge3 = new ModelRenderer(this, 0, 16);
		frameEdge3.func_78789_a(0F, 0F, 0F, 1, 10, 1);
		frameEdge3.func_78793_a(-7.5F, 11F, 6.5F);
		frameEdge3.func_78787_b(128, 64);
		frameEdge3.field_78809_i = true;
		setRotation(frameEdge3, 0F, 0F, 0F);
		frameEdge4 = new ModelRenderer(this, 0, 16);
		frameEdge4.func_78789_a(0F, 0F, 0F, 1, 10, 1);
		frameEdge4.func_78793_a(6.5F, 11F, 6.5F);
		frameEdge4.func_78787_b(128, 64);
		frameEdge4.field_78809_i = true;
		setRotation(frameEdge4, 0F, 0F, 0F);
		frameEdge5 = new ModelRenderer(this, 4, 27);
		frameEdge5.func_78789_a(0F, 0F, 0F, 10, 1, 1);
		frameEdge5.func_78793_a(-5F, 22.5F, -7.5F);
		frameEdge5.func_78787_b(128, 64);
		frameEdge5.field_78809_i = true;
		setRotation(frameEdge5, 0F, 0F, 0F);
		frameEdge6 = new ModelRenderer(this, 4, 16);
		frameEdge6.func_78789_a(0F, 0F, 0F, 1, 1, 10);
		frameEdge6.func_78793_a(-7.5F, 22.5F, -5F);
		frameEdge6.func_78787_b(128, 64);
		frameEdge6.field_78809_i = true;
		setRotation(frameEdge6, 0F, 0F, 0F);
		frameEdge7 = new ModelRenderer(this, 4, 16);
		frameEdge7.func_78789_a(0F, 0F, 0F, 1, 1, 10);
		frameEdge7.func_78793_a(6.5F, 22.5F, -5F);
		frameEdge7.func_78787_b(128, 64);
		frameEdge7.field_78809_i = true;
		setRotation(frameEdge7, 0F, 0F, 0F);
		frameEdge8 = new ModelRenderer(this, 4, 27);
		frameEdge8.func_78789_a(0F, 0F, 0F, 10, 1, 1);
		frameEdge8.func_78793_a(-5F, 22.5F, 6.5F);
		frameEdge8.func_78787_b(128, 64);
		frameEdge8.field_78809_i = true;
		setRotation(frameEdge8, 0F, 0F, 0F);
		frameEdge9 = new ModelRenderer(this, 4, 27);
		frameEdge9.func_78789_a(0F, 0F, 0F, 10, 1, 1);
		frameEdge9.func_78793_a(-5F, 8.5F, -7.5F);
		frameEdge9.func_78787_b(128, 64);
		frameEdge9.field_78809_i = true;
		setRotation(frameEdge9, 0F, 0F, 0F);
		frameEdge10 = new ModelRenderer(this, 4, 16);
		frameEdge10.func_78789_a(0F, 0F, 0F, 1, 1, 10);
		frameEdge10.func_78793_a(-7.5F, 8.5F, -5F);
		frameEdge10.func_78787_b(128, 64);
		frameEdge10.field_78809_i = true;
		setRotation(frameEdge10, 0F, 0F, 0F);
		frameEdge11 = new ModelRenderer(this, 4, 16);
		frameEdge11.func_78789_a(0F, 0F, 0F, 1, 1, 10);
		frameEdge11.func_78793_a(6.5F, 8.5F, -5F);
		frameEdge11.func_78787_b(128, 64);
		frameEdge11.field_78809_i = true;
		setRotation(frameEdge11, 0F, 0F, 0F);
		frameEdge12 = new ModelRenderer(this, 4, 27);
		frameEdge12.func_78789_a(0F, 0F, 0F, 10, 1, 1);
		frameEdge12.func_78793_a(-5F, 8.5F, 6.5F);
		frameEdge12.func_78787_b(128, 64);
		frameEdge12.field_78809_i = true;
		setRotation(frameEdge12, 0F, 0F, 0F);
		frame1 = new ModelRenderer(this, 0, 29);
		frame1.func_78789_a(0F, 0F, 0F, 2, 10, 2);
		frame1.func_78793_a(-7F, 11F, -7F);
		frame1.func_78787_b(128, 64);
		frame1.field_78809_i = true;
		setRotation(frame1, 0F, 0F, 0F);
		frame2 = new ModelRenderer(this, 0, 29);
		frame2.field_78809_i = true;
		frame2.func_78789_a(0F, 0F, 0F, 2, 10, 2);
		frame2.func_78793_a(5F, 11F, -7F);
		frame2.func_78787_b(128, 64);
		setRotation(frame2, 0F, 0F, 0F);
		frame3 = new ModelRenderer(this, 8, 29);
		frame3.func_78789_a(0F, 0F, 0F, 2, 10, 2);
		frame3.func_78793_a(-7F, 11F, 5F);
		frame3.func_78787_b(128, 64);
		frame3.field_78809_i = true;
		setRotation(frame3, 0F, 0F, 0F);
		frame4 = new ModelRenderer(this, 8, 29);
		frame4.field_78809_i = true;
		frame4.func_78789_a(0F, 0F, 0F, 2, 10, 2);
		frame4.func_78793_a(5F, 11F, 5F);
		frame4.func_78787_b(128, 64);
		setRotation(frame4, 0F, 0F, 0F);
		frame5 = new ModelRenderer(this, 16, 45);
		frame5.func_78789_a(0F, 0F, 0F, 10, 2, 2);
		frame5.func_78793_a(-5F, 21F, -7F);
		frame5.func_78787_b(128, 64);
		frame5.field_78809_i = true;
		setRotation(frame5, 0F, 0F, 0F);
		frame6 = new ModelRenderer(this, 40, 29);
		frame6.func_78789_a(0F, 0F, 0F, 2, 2, 10);
		frame6.func_78793_a(-7F, 21F, -5F);
		frame6.func_78787_b(128, 64);
		frame6.field_78809_i = true;
		setRotation(frame6, 0F, 0F, 0F);
		frame7 = new ModelRenderer(this, 40, 29);
		frame7.field_78809_i = true;
		frame7.func_78789_a(0F, 0F, 0F, 2, 2, 10);
		frame7.func_78793_a(5F, 21F, -5F);
		frame7.func_78787_b(128, 64);
		setRotation(frame7, 0F, 0F, 0F);
		frame8 = new ModelRenderer(this, 16, 49);
		frame8.func_78789_a(0F, 0F, 0F, 10, 2, 2);
		frame8.func_78793_a(-5F, 21F, 5F);
		frame8.func_78787_b(128, 64);
		frame8.field_78809_i = true;
		setRotation(frame8, 0F, 0F, 0F);
		frame9 = new ModelRenderer(this, 16, 41);
		frame9.func_78789_a(0F, 0F, 0F, 10, 2, 2);
		frame9.func_78793_a(-5F, 9F, -7F);
		frame9.func_78787_b(128, 64);
		frame9.field_78809_i = true;
		setRotation(frame9, 0F, 0F, 0F);
		frame10 = new ModelRenderer(this, 16, 29);
		frame10.func_78789_a(0F, 0F, 0F, 2, 2, 10);
		frame10.func_78793_a(-7F, 9F, -5F);
		frame10.func_78787_b(128, 64);
		frame10.field_78809_i = true;
		setRotation(frame10, 0F, 0F, 0F);
		frame11 = new ModelRenderer(this, 16, 29);
		frame11.field_78809_i = true;
		frame11.func_78789_a(0F, 0F, 0F, 2, 2, 10);
		frame11.func_78793_a(5F, 9F, -5F);
		frame11.func_78787_b(128, 64);
		setRotation(frame11, 0F, 0F, 0F);
		frame12 = new ModelRenderer(this, 16, 53);
		frame12.func_78789_a(0F, 0F, 0F, 10, 2, 2);
		frame12.func_78793_a(-5F, 9F, 5F);
		frame12.func_78787_b(128, 64);
		frame12.field_78809_i = true;
		setRotation(frame12, 0F, 0F, 0F);
		corner1 = new ModelRenderer(this, 0, 49);
		corner1.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner1.func_78793_a(-8F, 8F, -8F);
		corner1.func_78787_b(128, 64);
		corner1.field_78809_i = true;
		setRotation(corner1, 0F, 0F, 0F);
		corner2 = new ModelRenderer(this, 0, 49);
		corner2.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner2.func_78793_a(5F, 8F, -8F);
		corner2.func_78787_b(128, 64);
		corner2.field_78809_i = true;
		setRotation(corner2, 0F, 0F, 0F);
		corner3 = new ModelRenderer(this, 0, 49);
		corner3.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner3.func_78793_a(-8F, 8F, 5F);
		corner3.func_78787_b(128, 64);
		corner3.field_78809_i = true;
		setRotation(corner3, 0F, 0F, 0F);
		corner4 = new ModelRenderer(this, 0, 49);
		corner4.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner4.func_78793_a(5F, 8F, 5F);
		corner4.func_78787_b(128, 64);
		corner4.field_78809_i = true;
		setRotation(corner4, 0F, 0F, 0F);
		corner5 = new ModelRenderer(this, 0, 49);
		corner5.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner5.func_78793_a(-8F, 21F, -8F);
		corner5.func_78787_b(128, 64);
		corner5.field_78809_i = true;
		setRotation(corner5, 0F, 0F, 0F);
		corner6 = new ModelRenderer(this, 0, 49);
		corner6.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner6.func_78793_a(5F, 21F, -8F);
		corner6.func_78787_b(128, 64);
		corner6.field_78809_i = true;
		setRotation(corner6, 0F, 0F, 0F);
		corner7 = new ModelRenderer(this, 0, 49);
		corner7.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner7.func_78793_a(-8F, 21F, 5F);
		corner7.func_78787_b(128, 64);
		corner7.field_78809_i = true;
		setRotation(corner7, 0F, 0F, 0F);
		corner8 = new ModelRenderer(this, 0, 49);
		corner8.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner8.func_78793_a(5F, 21F, 5F);
		corner8.func_78787_b(128, 64);
		corner8.field_78809_i = true;
		setRotation(corner8, 0F, 0F, 0F);
		portRightLarge = new ModelRenderer(this, 68, 0);
		portRightLarge.field_78809_i = true;
		portRightLarge.func_78789_a(0F, 0F, 0F, 1, 10, 10);
		portRightLarge.func_78793_a(7F, 11F, -5F);
		portRightLarge.func_78787_b(128, 64);
		setRotation(portRightLarge, 0F, 0F, 0F);
		portLeftLarge = new ModelRenderer(this, 68, 0);
		portLeftLarge.func_78789_a(0F, 0F, 0F, 1, 10, 10);
		portLeftLarge.func_78793_a(-8F, 11F, -5F);
		portLeftLarge.func_78787_b(128, 64);
		portLeftLarge.field_78809_i = true;
		setRotation(portLeftLarge, 0F, 0F, 0F);
	}
	
	public void render(float size, TextureManager manager, boolean renderMain)
	{
		GlStateManager.func_179094_E();
		MekanismRenderer.blendOn();
		
		if(renderMain)
		{
			doRender(size);
		}
		
		manager.func_110577_a(OVERLAY);
		GlStateManager.func_179152_a(1.001F, 1.001F, 1.001F);
		GlStateManager.func_179109_b(0, -0.0011F, 0);
		MekanismRenderer.glowOn();
		
		doRender(size);
		
		MekanismRenderer.glowOff();
		MekanismRenderer.blendOff();
		GlStateManager.func_179121_F();
	}

	public void doRender(float size)
	{
		portTop.func_78785_a(size);
		portBottom.func_78785_a(size);
		portLeft.func_78785_a(size);
		portRight.func_78785_a(size);
		portBack.func_78785_a(size);
		portFront.func_78785_a(size);
		energyCubeCore.func_78785_a(size);
		frameEdge1.func_78785_a(size);
		frameEdge2.func_78785_a(size);
		frameEdge3.func_78785_a(size);
		frameEdge4.func_78785_a(size);
		frameEdge5.func_78785_a(size);
		frameEdge6.func_78785_a(size);
		frameEdge7.func_78785_a(size);
		frameEdge8.func_78785_a(size);
		frameEdge9.func_78785_a(size);
		frameEdge10.func_78785_a(size);
		frameEdge11.func_78785_a(size);
		frameEdge12.func_78785_a(size);
		frame1.func_78785_a(size);
		frame2.func_78785_a(size);
		frame3.func_78785_a(size);
		frame4.func_78785_a(size);
		frame5.func_78785_a(size);
		frame6.func_78785_a(size);
		frame7.func_78785_a(size);
		frame8.func_78785_a(size);
		frame9.func_78785_a(size);
		frame10.func_78785_a(size);
		frame11.func_78785_a(size);
		frame12.func_78785_a(size);
		corner1.func_78785_a(size);
		corner2.func_78785_a(size);
		corner3.func_78785_a(size);
		corner4.func_78785_a(size);
		corner5.func_78785_a(size);
		corner6.func_78785_a(size);
		corner7.func_78785_a(size);
		corner8.func_78785_a(size);
		//portRightLarge.render(size);
		//portLeftLarge.render(size);
	}
	
	private void setRotation(ModelRenderer model, float x, float y, float z)
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
