package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class ModelGasMask extends ModelBase
{
	ModelRenderer helmetfeed;
	ModelRenderer tubeback;
	ModelRenderer tubeL;
	ModelRenderer tubeR;
	ModelRenderer tubefront;
	ModelRenderer mouthintake;
	ModelRenderer finupperR;
	ModelRenderer finupperL;
	ModelRenderer finmidR;
	ModelRenderer finmidL;
	ModelRenderer finback;
	ModelRenderer topplate;
	ModelRenderer filterL;
	ModelRenderer filterR;
	ModelRenderer filterpipelower;
	ModelRenderer filterpipeupper;
	ModelRenderer glasstop;
	ModelRenderer glassfront;
	ModelRenderer glassR;
	ModelRenderer glassL;
	ModelRenderer glassbackR;
	ModelRenderer glassbackL;
	ModelRenderer pipecornerFL;
	ModelRenderer pipecornerFR;
	ModelRenderer pipecornerBR;
	ModelRenderer pipecornerBL;
	ModelRenderer lightL;
	ModelRenderer lightR;

	public ModelGasMask()
	{
		field_78090_t = 128;
		field_78089_u = 64;

		helmetfeed = new ModelRenderer(this, 88, 43);
		helmetfeed.func_78789_a(-2F, -2F, 2F, 4, 3, 4);
		helmetfeed.func_78793_a(0F, 0F, 0F);
		helmetfeed.func_78787_b(128, 64);
		helmetfeed.field_78809_i = true;
		setRotation(helmetfeed, 0F, 0F, 0F);
		tubeback = new ModelRenderer(this, 106, 50);
		tubeback.func_78789_a(-4.5F, -1F, 4.5F, 9, 1, 1);
		tubeback.func_78793_a(0F, 0F, 0F);
		tubeback.func_78787_b(128, 64);
		tubeback.field_78809_i = true;
		setRotation(tubeback, 0F, 0F, 0F);
		tubeL = new ModelRenderer(this, 106, 54);
		tubeL.func_78789_a(4.5F, -1F, -4.5F, 1, 1, 9);
		tubeL.func_78793_a(0F, 0F, 0F);
		tubeL.func_78787_b(128, 64);
		tubeL.field_78809_i = true;
		setRotation(tubeL, 0F, 0F, 0F);
		tubeR = new ModelRenderer(this, 106, 54);
		tubeR.func_78789_a(-5.5F, -1F, -4.5F, 1, 1, 9);
		tubeR.func_78793_a(0F, 0F, 0F);
		tubeR.func_78787_b(128, 64);
		tubeR.field_78809_i = true;
		setRotation(tubeR, 0F, 0F, 0F);
		tubefront = new ModelRenderer(this, 106, 50);
		tubefront.func_78789_a(-4.5F, -1F, -5.5F, 9, 1, 1);
		tubefront.func_78793_a(0F, 0F, 0F);
		tubefront.func_78787_b(128, 64);
		tubefront.field_78809_i = true;
		setRotation(tubefront, 0F, 0F, 0F);
		mouthintake = new ModelRenderer(this, 118, 42);
		mouthintake.func_78789_a(-1.5F, -0.7F, -6F, 3, 2, 3);
		mouthintake.func_78793_a(0F, -2F, 0F);
		mouthintake.func_78787_b(128, 64);
		mouthintake.field_78809_i = true;
		setRotation(mouthintake, 0.2094395F, 0F, 0F);
		finupperR = new ModelRenderer(this, 78, 50);
		finupperR.func_78789_a(-6F, -7.5F, -3.3F, 1, 2, 12);
		finupperR.func_78793_a(0F, 0F, 0F);
		finupperR.func_78787_b(128, 64);
		finupperR.field_78809_i = true;
		setRotation(finupperR, 0.0698132F, 0F, 0F);
		finupperL = new ModelRenderer(this, 78, 50);
		finupperL.func_78789_a(5F, -7.5F, -3.3F, 1, 2, 12);
		finupperL.func_78793_a(0F, 0F, 0F);
		finupperL.func_78787_b(128, 64);
		finupperL.field_78809_i = true;
		setRotation(finupperL, 0.0698132F, 0F, 0F);
		finupperL.field_78809_i = false;
		finmidR = new ModelRenderer(this, 72, 34);
		finmidR.func_78789_a(-7.5F, -6F, -1F, 2, 2, 5);
		finmidR.func_78793_a(0F, 0F, 0F);
		finmidR.func_78787_b(128, 64);
		finmidR.field_78809_i = true;
		setRotation(finmidR, 0F, 0F, 0F);
		finmidL = new ModelRenderer(this, 72, 34);
		finmidL.func_78789_a(5.5F, -6F, -1F, 2, 2, 5);
		finmidL.func_78793_a(0F, 0F, 0F);
		finmidL.func_78787_b(128, 64);
		finmidL.field_78809_i = true;
		setRotation(finmidL, 0F, 0F, 0F);
		finmidL.field_78809_i = false;
		finback = new ModelRenderer(this, 80, 0);
		finback.func_78789_a(-1F, -9.6F, 2.5F, 2, 10, 3);
		finback.func_78793_a(0F, 0F, 0F);
		finback.func_78787_b(128, 64);
		finback.field_78809_i = true;
		setRotation(finback, 0F, 0F, 0F);
		topplate = new ModelRenderer(this, 104, 34);
		topplate.func_78789_a(-3F, -10F, -2F, 6, 2, 6);
		topplate.func_78793_a(0F, 0F, 0F);
		topplate.func_78787_b(128, 64);
		topplate.field_78809_i = true;
		setRotation(topplate, 0.1396263F, 0F, 0F);
		filterL = new ModelRenderer(this, 108, 42);
		filterL.func_78789_a(3.4F, -1.8F, -5F, 2, 3, 3);
		filterL.func_78793_a(0F, 0F, 0F);
		filterL.func_78787_b(128, 64);
		filterL.field_78809_i = true;
		setRotation(filterL, 0F, 0.3839724F, 0.5061455F);
		filterL.field_78809_i = false;
		filterR = new ModelRenderer(this, 108, 42);
		filterR.func_78789_a(-5.4F, -1.8F, -5F, 2, 3, 3);
		filterR.func_78793_a(0F, 0F, 0F);
		filterR.func_78787_b(128, 64);
		filterR.field_78809_i = true;
		setRotation(filterR, 0F, -0.3839724F, -0.5061455F);
		filterpipelower = new ModelRenderer(this, 92, 41);
		filterpipelower.func_78789_a(-3F, 1F, -5F, 5, 1, 1);
		filterpipelower.func_78793_a(0F, 0F, 0F);
		filterpipelower.func_78787_b(128, 64);
		filterpipelower.field_78809_i = true;
		setRotation(filterpipelower, 0F, 0F, 0F);
		filterpipeupper = new ModelRenderer(this, 104, 42);
		filterpipeupper.func_78789_a(-0.5F, 0F, -5F, 1, 1, 1);
		filterpipeupper.func_78793_a(0F, 0F, 0F);
		filterpipeupper.func_78787_b(128, 64);
		filterpipeupper.field_78809_i = true;
		setRotation(filterpipeupper, 0F, 0F, 0F);
		glasstop = new ModelRenderer(this, 0, 0);
		glasstop.func_78789_a(-4F, -9F, -4F, 8, 1, 8);
		glasstop.func_78793_a(0F, 0F, 0F);
		glasstop.func_78787_b(128, 64);
		glasstop.field_78809_i = true;
		setRotation(glasstop, 0F, 0F, 0F);
		glassfront = new ModelRenderer(this, 0, 0);
		glassfront.func_78789_a(-4F, -8F, -5F, 8, 7, 1);
		glassfront.func_78793_a(0F, 0F, 0F);
		glassfront.func_78787_b(128, 64);
		glassfront.field_78809_i = true;
		setRotation(glassfront, 0F, 0F, 0F);
		glassR = new ModelRenderer(this, 0, 0);
		glassR.func_78789_a(-5F, -8F, -4F, 1, 7, 8);
		glassR.func_78793_a(0F, 0F, 0F);
		glassR.func_78787_b(128, 64);
		glassR.field_78809_i = true;
		setRotation(glassR, 0F, 0F, 0F);
		glassL = new ModelRenderer(this, 0, 0);
		glassL.func_78789_a(4F, -8F, -4F, 1, 7, 8);
		glassL.func_78793_a(0F, 0F, 0F);
		glassL.func_78787_b(128, 64);
		glassL.field_78809_i = true;
		setRotation(glassL, 0F, 0F, 0F);
		glassbackR = new ModelRenderer(this, 0, 0);
		glassbackR.func_78789_a(-4F, -8F, 4F, 3, 7, 1);
		glassbackR.func_78793_a(0F, 0F, 0F);
		glassbackR.func_78787_b(128, 64);
		glassbackR.field_78809_i = true;
		setRotation(glassbackR, 0F, 0F, 0F);
		glassbackL = new ModelRenderer(this, 0, 0);
		glassbackL.func_78789_a(1F, -8F, 4F, 3, 7, 1);
		glassbackL.func_78793_a(0F, 0F, 0F);
		glassbackL.func_78787_b(128, 64);
		glassbackL.field_78809_i = true;
		setRotation(glassbackL, 0F, 0F, 0F);
		pipecornerFL = new ModelRenderer(this, 109, 50);
		pipecornerFL.func_78789_a(3.5F, -1F, -4.5F, 1, 1, 1);
		pipecornerFL.func_78793_a(0F, 0F, 0F);
		pipecornerFL.func_78787_b(128, 64);
		pipecornerFL.field_78809_i = true;
		setRotation(pipecornerFL, 0F, 0F, 0F);
		pipecornerFR = new ModelRenderer(this, 109, 50);
		pipecornerFR.func_78789_a(-4.5F, -1F, -4.5F, 1, 1, 1);
		pipecornerFR.func_78793_a(0F, 0F, 0F);
		pipecornerFR.func_78787_b(128, 64);
		pipecornerFR.field_78809_i = true;
		setRotation(pipecornerFR, 0F, 0F, 0F);
		pipecornerBR = new ModelRenderer(this, 109, 50);
		pipecornerBR.func_78789_a(-4.5F, -1F, 3.5F, 1, 1, 1);
		pipecornerBR.func_78793_a(0F, 0F, 0F);
		pipecornerBR.func_78787_b(128, 64);
		pipecornerBR.field_78809_i = true;
		setRotation(pipecornerBR, 0F, 0F, 0F);
		pipecornerBL = new ModelRenderer(this, 109, 50);
		pipecornerBL.func_78789_a(3.5F, -1F, 4.5F, 1, 1, 1);
		pipecornerBL.func_78793_a(0F, 0F, -1F);
		pipecornerBL.func_78787_b(128, 64);
		pipecornerBL.field_78809_i = true;
		setRotation(pipecornerBL, 0F, 0F, 0F);
		lightL = new ModelRenderer(this, 89, 37);
		lightL.func_78789_a(5.5F, -6F, -2F, 2, 2, 1);
		lightL.func_78793_a(0F, 0F, 0F);
		lightL.func_78787_b(128, 64);
		lightL.field_78809_i = true;
		setRotation(lightL, 0F, 0F, 0F);
		lightR = new ModelRenderer(this, 89, 37);
		lightR.func_78789_a(-7.5F, -6F, -2F, 2, 2, 1);
		lightR.func_78793_a(0F, 0F, 0F);
		lightR.func_78787_b(128, 64);
		lightR.field_78809_i = true;
		setRotation(lightR, 0F, 0F, 0F);
	}

	public void render(float size)
	{
		helmetfeed.func_78785_a(size);
		tubeback.func_78785_a(size);
		tubeL.func_78785_a(size);
		tubeR.func_78785_a(size);
		tubefront.func_78785_a(size);
		mouthintake.func_78785_a(size);
		finupperR.func_78785_a(size);
		finupperL.func_78785_a(size);
		finmidR.func_78785_a(size);
		finmidL.func_78785_a(size);
		finback.func_78785_a(size);
		topplate.func_78785_a(size);
		filterL.func_78785_a(size);
		filterR.func_78785_a(size);
		filterpipelower.func_78785_a(size);
		filterpipeupper.func_78785_a(size);

		MekanismRenderer.blendOn();
		MekanismRenderer.glowOn();
		GL11.glColor4f(1, 1, 1, 0.3F);
		GlStateManager.func_179089_o();

		glasstop.func_78785_a(size);
		glassfront.func_78785_a(size);
		glassR.func_78785_a(size);
		glassL.func_78785_a(size);
		glassbackR.func_78785_a(size);
		glassbackL.func_78785_a(size);

		GlStateManager.func_179129_p();
		MekanismRenderer.resetColor();
		MekanismRenderer.glowOff();
		MekanismRenderer.blendOff();

		pipecornerFL.func_78785_a(size);
		pipecornerFR.func_78785_a(size);
		pipecornerBR.func_78785_a(size);
		pipecornerBL.func_78785_a(size);

		MekanismRenderer.glowOn();
		lightL.func_78785_a(size);
		lightR.func_78785_a(size);
		MekanismRenderer.glowOff();
	}

	private void setRotation(ModelRenderer model, float x, float y, float z)
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
