package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.Tier.FluidTankTier;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelFluidTank extends ModelBase
{
	ModelRenderer Base;
	ModelRenderer PoleFL;
	ModelRenderer PoleLB;
	ModelRenderer PoleBR;
	ModelRenderer PoleRF;
	ModelRenderer Top;
	ModelRenderer FrontGlass;
	ModelRenderer BackGlass;
	ModelRenderer RightGlass;
	ModelRenderer LeftGlass;

	public ModelFluidTank() 
	{
		field_78090_t = 128;
		field_78089_u = 128;

		Base = new ModelRenderer(this, 0, 0);
		Base.func_78789_a(0F, 0F, 0F, 12, 1, 12);
		Base.func_78793_a(-6F, 23F, -6F);
		Base.func_78787_b(128, 128);
		Base.field_78809_i = true;
		setRotation(Base, 0F, 0F, 0F);
		PoleFL = new ModelRenderer(this, 48, 0);
		PoleFL.func_78789_a(0F, 0F, 0F, 1, 14, 1);
		PoleFL.func_78793_a(5F, 9F, -6F);
		PoleFL.func_78787_b(128, 128);
		PoleFL.field_78809_i = true;
		setRotation(PoleFL, 0F, 0F, 0F);
		PoleLB = new ModelRenderer(this, 48, 0);
		PoleLB.func_78789_a(0F, 0F, 0F, 1, 14, 1);
		PoleLB.func_78793_a(5F, 9F, 5F);
		PoleLB.func_78787_b(128, 128);
		PoleLB.field_78809_i = true;
		setRotation(PoleLB, 0F, 0F, 0F);
		PoleBR = new ModelRenderer(this, 48, 0);
		PoleBR.func_78789_a(0F, 0F, 0F, 1, 14, 1);
		PoleBR.func_78793_a(-6F, 9F, 5F);
		PoleBR.func_78787_b(128, 128);
		PoleBR.field_78809_i = true;
		setRotation(PoleBR, 0F, 0F, 0F);
		PoleRF = new ModelRenderer(this, 48, 0);
		PoleRF.func_78789_a(0F, 0F, 0F, 1, 14, 1);
		PoleRF.func_78793_a(-6F, 9F, -6F);
		PoleRF.func_78787_b(128, 128);
		PoleRF.field_78809_i = true;
		setRotation(PoleRF, 0F, 0F, 0F);
		Top = new ModelRenderer(this, 0, 0);
		Top.func_78789_a(0F, 0F, 0F, 12, 1, 12);
		Top.func_78793_a(-6F, 8F, -6F);
		Top.func_78787_b(128, 128);
		Top.field_78809_i = true;
		setRotation(Top, 0F, 0F, 0F);
		FrontGlass = new ModelRenderer(this, 0, 13);
		FrontGlass.func_78789_a(0F, 0F, 0F, 10, 14, 1);
		FrontGlass.func_78793_a(-5F, 9F, -6F);
		FrontGlass.func_78787_b(128, 128);
		FrontGlass.field_78809_i = true;
		setRotation(FrontGlass, 0F, 0F, 0F);
		BackGlass = new ModelRenderer(this, 0, 28);
		BackGlass.func_78789_a(0F, 0F, 3F, 10, 14, 1);
		BackGlass.func_78793_a(-5F, 9F, 2F);
		BackGlass.func_78787_b(128, 128);
		BackGlass.field_78809_i = true;
		setRotation(BackGlass, 0F, 0F, 0F);
		RightGlass = new ModelRenderer(this, 22, 13);
		RightGlass.func_78789_a(0F, 0F, 0F, 1, 14, 10);
		RightGlass.func_78793_a(-6F, 9F, -5F);
		RightGlass.func_78787_b(128, 128);
		RightGlass.field_78809_i = true;
		setRotation(RightGlass, 0F, 0F, 0F);
		LeftGlass = new ModelRenderer(this, 22, 37);
		LeftGlass.func_78789_a(0F, 0F, 0F, 1, 14, 10);
		LeftGlass.func_78793_a(5F, 9F, -5F);
		LeftGlass.func_78787_b(128, 128);
		LeftGlass.field_78809_i = true;
		setRotation(LeftGlass, 0F, 0F, 0F);
	}

	public void render(float size, FluidTankTier tier)
	{
		Base.func_78785_a(size);
		PoleFL.func_78785_a(size);
		PoleLB.func_78785_a(size);
		PoleBR.func_78785_a(size);
		PoleRF.func_78785_a(size);
		Top.func_78785_a(size);
		
		MekanismRenderer.blendOn();
		MekanismRenderer.color(tier.getBaseTier().getColor());
		FrontGlass.func_78785_a(size);
		BackGlass.func_78785_a(size);
		RightGlass.func_78785_a(size);
		LeftGlass.func_78785_a(size);
		MekanismRenderer.blendOff();
	}

	private void setRotation(ModelRenderer model, float x, float y, float z)
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
