package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.RenderEnergyCube;
import mekanism.common.SideData.IOState;
import mekanism.common.Tier.EnergyCubeTier;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelEnergyCube extends ModelBase
{
	public static ResourceLocation OVERLAY_ON = MekanismUtils.getResource(ResourceType.RENDER, "EnergyCube_OverlayOn.png");
	public static ResourceLocation OVERLAY_OFF = MekanismUtils.getResource(ResourceType.RENDER, "EnergyCube_OverlayOff.png");
	
	ModelRenderer frame12;
	ModelRenderer frame11;
	ModelRenderer frame10;
	ModelRenderer frame9;
	ModelRenderer frame8;
	ModelRenderer frame7;
	ModelRenderer frame6;
	ModelRenderer frame5;
	ModelRenderer frame4;
	ModelRenderer frame3;
	ModelRenderer frame2;
	ModelRenderer frame1;
	ModelRenderer corner8;
	ModelRenderer corner7;
	ModelRenderer corner6;
	ModelRenderer corner5;
	ModelRenderer corner4;
	ModelRenderer corner3;
	ModelRenderer corner2;
	ModelRenderer corner1;
	ModelRenderer connectorBackToggle;
	ModelRenderer connectorRightToggle;
	ModelRenderer connectorBottomToggle;
	ModelRenderer connectorLeftToggle;
	ModelRenderer connectorFrontToggle;
	ModelRenderer connectorTopToggle;
	ModelRenderer portBackToggle;
	ModelRenderer portBottomToggle;
	ModelRenderer portFrontToggle;
	ModelRenderer portLeftToggle;
	ModelRenderer portRightToggle;
	ModelRenderer portTopToggle;
	ModelRenderer ledTop1;
	ModelRenderer ledTop2;
	ModelRenderer ledBack1;
	ModelRenderer ledBack2;
	ModelRenderer ledBottom2;
	ModelRenderer ledBottom1;
	ModelRenderer ledFront1;
	ModelRenderer ledFront2;
	ModelRenderer ledRight2;
	ModelRenderer ledRight1;
	ModelRenderer ledLeft1;
	ModelRenderer ledLeft2;
	
	public ModelRenderer[] leds1;
	public ModelRenderer[] leds2;
	
	public ModelRenderer[] ports;
	public ModelRenderer[] connectors;

	public ModelEnergyCube() 
	{
		field_78090_t = 64;
		field_78089_u = 64;

		frame12 = new ModelRenderer(this, 0, 0);
		frame12.func_78789_a(0F, 0F, 0F, 3, 10, 3);
		frame12.func_78793_a(-8F, 11F, 5F);
		frame12.func_78787_b(64, 64);
		frame12.field_78809_i = true;
		setRotation(frame12, 0F, 0F, 0F);
		frame11 = new ModelRenderer(this, 0, 0);
		frame11.func_78789_a(0F, 0F, 0F, 3, 10, 3);
		frame11.func_78793_a(5F, 11F, -8F);
		frame11.func_78787_b(64, 64);
		frame11.field_78809_i = true;
		setRotation(frame11, 0F, 0F, 0F);
		frame10 = new ModelRenderer(this, 0, 13);
		frame10.func_78789_a(0F, 0F, 0F, 10, 3, 3);
		frame10.func_78793_a(-5F, 21F, 5F);
		frame10.func_78787_b(64, 64);
		frame10.field_78809_i = true;
		setRotation(frame10, 0F, 0F, 0F);
		frame9 = new ModelRenderer(this, 12, 0);
		frame9.func_78789_a(0F, 0F, 0F, 3, 3, 10);
		frame9.func_78793_a(5F, 21F, -5F);
		frame9.func_78787_b(64, 64);
		frame9.field_78809_i = true;
		setRotation(frame9, 0F, 0F, 0F);
		frame8 = new ModelRenderer(this, 0, 13);
		frame8.func_78789_a(0F, 0F, 0F, 10, 3, 3);
		frame8.func_78793_a(-5F, 8F, 5F);
		frame8.func_78787_b(64, 64);
		frame8.field_78809_i = true;
		setRotation(frame8, 0F, 0F, 0F);
		frame7 = new ModelRenderer(this, 0, 13);
		frame7.func_78789_a(0F, 0F, 0F, 10, 3, 3);
		frame7.func_78793_a(-5F, 21F, -8F);
		frame7.func_78787_b(64, 64);
		frame7.field_78809_i = true;
		setRotation(frame7, 0F, 0F, 0F);
		frame6 = new ModelRenderer(this, 0, 0);
		frame6.func_78789_a(0F, 0F, 0F, 3, 10, 3);
		frame6.func_78793_a(5F, 11F, 5F);
		frame6.func_78787_b(64, 64);
		frame6.field_78809_i = true;
		setRotation(frame6, 0F, 0F, 0F);
		frame5 = new ModelRenderer(this, 0, 0);
		frame5.func_78789_a(0F, 0F, 0F, 3, 10, 3);
		frame5.func_78793_a(-8F, 11F, -8F);
		frame5.func_78787_b(64, 64);
		frame5.field_78809_i = true;
		setRotation(frame5, 0F, 0F, 0F);
		frame4 = new ModelRenderer(this, 12, 0);
		frame4.func_78789_a(0F, 0F, 0F, 3, 3, 10);
		frame4.func_78793_a(5F, 8F, -5F);
		frame4.func_78787_b(64, 64);
		frame4.field_78809_i = true;
		setRotation(frame4, 0F, 0F, 0F);
		frame3 = new ModelRenderer(this, 12, 0);
		frame3.func_78789_a(0F, 0F, 0F, 3, 3, 10);
		frame3.func_78793_a(-8F, 21F, -5F);
		frame3.func_78787_b(64, 64);
		frame3.field_78809_i = true;
		setRotation(frame3, 0F, 0F, 0F);
		frame2 = new ModelRenderer(this, 12, 0);
		frame2.func_78789_a(0F, 0F, 0F, 3, 3, 10);
		frame2.func_78793_a(-8F, 8F, -5F);
		frame2.func_78787_b(64, 64);
		frame2.field_78809_i = true;
		setRotation(frame2, 0F, 0F, 0F);
		frame1 = new ModelRenderer(this, 0, 13);
		frame1.func_78789_a(0F, 0F, 0F, 10, 3, 3);
		frame1.func_78793_a(-5F, 8F, -8F);
		frame1.func_78787_b(64, 64);
		frame1.field_78809_i = true;
		setRotation(frame1, 0F, 0F, 0F);
		corner8 = new ModelRenderer(this, 26, 13);
		corner8.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner8.func_78793_a(5F, 21F, 5F);
		corner8.func_78787_b(64, 64);
		corner8.field_78809_i = true;
		setRotation(corner8, 0F, 0F, 0F);
		corner7 = new ModelRenderer(this, 26, 13);
		corner7.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner7.func_78793_a(5F, 21F, -8F);
		corner7.func_78787_b(64, 64);
		corner7.field_78809_i = true;
		setRotation(corner7, 0F, 0F, 0F);
		corner6 = new ModelRenderer(this, 26, 13);
		corner6.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner6.func_78793_a(-8F, 21F, 5F);
		corner6.func_78787_b(64, 64);
		corner6.field_78809_i = true;
		setRotation(corner6, 0F, 0F, 0F);
		corner5 = new ModelRenderer(this, 26, 13);
		corner5.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner5.func_78793_a(-8F, 21F, -8F);
		corner5.func_78787_b(64, 64);
		corner5.field_78809_i = true;
		setRotation(corner5, 0F, 0F, 0F);
		corner4 = new ModelRenderer(this, 26, 13);
		corner4.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner4.func_78793_a(5F, 8F, 5F);
		corner4.func_78787_b(64, 64);
		corner4.field_78809_i = true;
		setRotation(corner4, 0F, 0F, 0F);
		corner3 = new ModelRenderer(this, 26, 13);
		corner3.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner3.func_78793_a(5F, 8F, -8F);
		corner3.func_78787_b(64, 64);
		corner3.field_78809_i = true;
		setRotation(corner3, 0F, 0F, 0F);
		corner2 = new ModelRenderer(this, 26, 13);
		corner2.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner2.func_78793_a(-8F, 8F, 5F);
		corner2.func_78787_b(64, 64);
		corner2.field_78809_i = true;
		setRotation(corner2, 0F, 0F, 0F);
		corner1 = new ModelRenderer(this, 26, 13);
		corner1.func_78789_a(0F, 0F, 0F, 3, 3, 3);
		corner1.func_78793_a(-8F, 8F, -8F);
		corner1.func_78787_b(64, 64);
		corner1.field_78809_i = true;
		setRotation(corner1, 0F, 0F, 0F);
		connectorBackToggle = new ModelRenderer(this, 38, 16);
		connectorBackToggle.func_78789_a(0F, 0F, 0F, 10, 6, 1);
		connectorBackToggle.func_78793_a(-5F, 13F, 6F);
		connectorBackToggle.func_78787_b(64, 64);
		connectorBackToggle.field_78809_i = true;
		setRotation(connectorBackToggle, 0F, 0F, 0F);
		connectorRightToggle = new ModelRenderer(this, 38, 0);
		connectorRightToggle.func_78789_a(0F, 0F, 0F, 1, 6, 10);
		connectorRightToggle.func_78793_a(6F, 13F, -5F);
		connectorRightToggle.func_78787_b(64, 64);
		connectorRightToggle.field_78809_i = true;
		setRotation(connectorRightToggle, 0F, 0F, 0F);
		connectorBottomToggle = new ModelRenderer(this, 0, 19);
		connectorBottomToggle.func_78789_a(0F, 0F, 0F, 10, 1, 6);
		connectorBottomToggle.func_78793_a(-5F, 22F, -3F);
		connectorBottomToggle.func_78787_b(64, 64);
		connectorBottomToggle.field_78809_i = true;
		setRotation(connectorBottomToggle, 0F, 0F, 0F);
		connectorLeftToggle = new ModelRenderer(this, 38, 0);
		connectorLeftToggle.func_78789_a(0F, 0F, 0F, 1, 6, 10);
		connectorLeftToggle.func_78793_a(-7F, 13F, -5F);
		connectorLeftToggle.func_78787_b(64, 64);
		connectorLeftToggle.field_78809_i = true;
		setRotation(connectorLeftToggle, 0F, 0F, 0F);
		connectorFrontToggle = new ModelRenderer(this, 38, 16);
		connectorFrontToggle.func_78789_a(0F, 0F, 0F, 10, 6, 1);
		connectorFrontToggle.func_78793_a(-5F, 13F, -7F);
		connectorFrontToggle.func_78787_b(64, 64);
		connectorFrontToggle.field_78809_i = true;
		setRotation(connectorFrontToggle, 0F, 0F, 0F);
		connectorTopToggle = new ModelRenderer(this, 0, 19);
		connectorTopToggle.func_78789_a(0F, 0F, 0F, 10, 1, 6);
		connectorTopToggle.func_78793_a(-5F, 9F, -3F);
		connectorTopToggle.func_78787_b(64, 64);
		connectorTopToggle.field_78809_i = true;
		setRotation(connectorTopToggle, 0F, 0F, 0F);
		portBackToggle = new ModelRenderer(this, 18, 35);
		portBackToggle.func_78789_a(0F, 0F, 0F, 8, 8, 1);
		portBackToggle.func_78793_a(-4F, 12F, 7F);
		portBackToggle.func_78787_b(64, 64);
		portBackToggle.field_78809_i = true;
		setRotation(portBackToggle, 0F, 0F, 0F);
		portBottomToggle = new ModelRenderer(this, 0, 26);
		portBottomToggle.func_78789_a(0F, 0F, 0F, 8, 1, 8);
		portBottomToggle.func_78793_a(-4F, 23F, -4F);
		portBottomToggle.func_78787_b(64, 64);
		portBottomToggle.field_78809_i = true;
		setRotation(portBottomToggle, 0F, 0F, 0F);
		portFrontToggle = new ModelRenderer(this, 18, 35);
		portFrontToggle.func_78789_a(0F, 0F, 0F, 8, 8, 1);
		portFrontToggle.func_78793_a(-4F, 12F, -8F);
		portFrontToggle.func_78787_b(64, 64);
		portFrontToggle.field_78809_i = true;
		setRotation(portFrontToggle, 0F, 0F, 0F);
		portLeftToggle = new ModelRenderer(this, 0, 35);
		portLeftToggle.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		portLeftToggle.func_78793_a(-8F, 12F, -4F);
		portLeftToggle.func_78787_b(64, 64);
		portLeftToggle.field_78809_i = true;
		setRotation(portLeftToggle, 0F, 0F, 0F);
		portRightToggle = new ModelRenderer(this, 0, 35);
		portRightToggle.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		portRightToggle.func_78793_a(7F, 12F, -4F);
		portRightToggle.func_78787_b(64, 64);
		portRightToggle.field_78809_i = true;
		setRotation(portRightToggle, 0F, 0F, 0F);
		portTopToggle = new ModelRenderer(this, 0, 26);
		portTopToggle.func_78789_a(0F, 0F, 0F, 8, 1, 8);
		portTopToggle.func_78793_a(-4F, 8F, -4F);
		portTopToggle.func_78787_b(64, 64);
		portTopToggle.field_78809_i = true;
		setRotation(portTopToggle, 0F, 0F, 0F);
		ledTop1 = new ModelRenderer(this, 0, 51);
		ledTop1.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledTop1.func_78793_a(-5.5F, 8.1F, -0.5F);
		ledTop1.func_78787_b(64, 64);
		ledTop1.field_78809_i = true;
		setRotation(ledTop1, 0F, 0F, 0F);
		ledTop2 = new ModelRenderer(this, 0, 51);
		ledTop2.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledTop2.func_78793_a(4.5F, 8.1F, -0.5F);
		ledTop2.func_78787_b(64, 64);
		ledTop2.field_78809_i = true;
		setRotation(ledTop2, 0F, 0F, 0F);
		ledBack1 = new ModelRenderer(this, 0, 51);
		ledBack1.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledBack1.func_78793_a(-5.5F, 15.5F, 6.9F);
		ledBack1.func_78787_b(64, 64);
		ledBack1.field_78809_i = true;
		setRotation(ledBack1, 0F, 0F, 0F);
		ledBack2 = new ModelRenderer(this, 0, 51);
		ledBack2.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledBack2.func_78793_a(4.5F, 15.5F, 6.9F);
		ledBack2.func_78787_b(64, 64);
		ledBack2.field_78809_i = true;
		setRotation(ledBack2, 0F, 0F, 0F);
		ledBottom2 = new ModelRenderer(this, 0, 51);
		ledBottom2.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledBottom2.func_78793_a(4.5F, 22.9F, -0.5F);
		ledBottom2.func_78787_b(64, 64);
		ledBottom2.field_78809_i = true;
		setRotation(ledBottom2, 0F, 0F, 0F);
		ledBottom1 = new ModelRenderer(this, 0, 51);
		ledBottom1.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledBottom1.func_78793_a(-5.5F, 22.9F, -0.5F);
		ledBottom1.func_78787_b(64, 64);
		ledBottom1.field_78809_i = true;
		setRotation(ledBottom1, 0F, 0F, 0F);
		ledFront1 = new ModelRenderer(this, 0, 51);
		ledFront1.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledFront1.func_78793_a(-5.5F, 15.5F, -7.9F);
		ledFront1.func_78787_b(64, 64);
		ledFront1.field_78809_i = true;
		setRotation(ledFront1, 0F, 0F, 0F);
		ledFront2 = new ModelRenderer(this, 0, 51);
		ledFront2.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledFront2.func_78793_a(4.5F, 15.5F, -7.9F);
		ledFront2.func_78787_b(64, 64);
		ledFront2.field_78809_i = true;
		setRotation(ledFront2, 0F, 0F, 0F);
		ledRight2 = new ModelRenderer(this, 0, 51);
		ledRight2.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledRight2.func_78793_a(6.9F, 15.5F, 4.5F);
		ledRight2.func_78787_b(64, 64);
		ledRight2.field_78809_i = true;
		setRotation(ledRight2, 0F, 0F, 0F);
		ledRight1 = new ModelRenderer(this, 0, 51);
		ledRight1.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledRight1.func_78793_a(6.9F, 15.5F, -5.5F);
		ledRight1.func_78787_b(64, 64);
		ledRight1.field_78809_i = true;
		setRotation(ledRight1, 0F, 0F, 0F);
		ledLeft1 = new ModelRenderer(this, 0, 51);
		ledLeft1.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledLeft1.func_78793_a(-7.9F, 15.5F, 4.5F);
		ledLeft1.func_78787_b(64, 64);
		ledLeft1.field_78809_i = true;
		setRotation(ledLeft1, 0F, 0F, 0F);
		ledLeft2 = new ModelRenderer(this, 0, 51);
		ledLeft2.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		ledLeft2.func_78793_a(-7.9F, 15.5F, -5.5F);
		ledLeft2.func_78787_b(64, 64);
		ledLeft2.field_78809_i = true;
		setRotation(ledLeft2, 0F, 0F, 0F);
		
		leds1 = new ModelRenderer[] {ledBottom1, ledTop1, ledFront1, ledBack1, ledLeft1, ledRight1};
		leds2 = new ModelRenderer[] {ledBottom2, ledTop2, ledFront2, ledBack2, ledLeft2, ledRight2};
		
		ports = new ModelRenderer[] {portBottomToggle, portTopToggle, portFrontToggle, portBackToggle, portLeftToggle, portRightToggle};
		connectors = new ModelRenderer[] {connectorBottomToggle, connectorTopToggle, connectorFrontToggle, connectorBackToggle, connectorLeftToggle, connectorRightToggle};
	}

	public void render(float size, EnergyCubeTier tier, TextureManager manager, boolean renderMain)
	{
		if(renderMain)
		{
			frame12.func_78785_a(size);
			frame11.func_78785_a(size);
			frame10.func_78785_a(size);
			frame9.func_78785_a(size);
			frame8.func_78785_a(size);
			frame7.func_78785_a(size);
			frame6.func_78785_a(size);
			frame5.func_78785_a(size);
			frame4.func_78785_a(size);
			frame3.func_78785_a(size);
			frame2.func_78785_a(size);
			frame1.func_78785_a(size);
			
			corner8.func_78785_a(size);
			corner7.func_78785_a(size);
			corner6.func_78785_a(size);
			corner5.func_78785_a(size);
			corner4.func_78785_a(size);
			corner3.func_78785_a(size);
			corner2.func_78785_a(size);
			corner1.func_78785_a(size);
		}
		
		GlStateManager.func_179094_E();
		GlStateManager.func_179152_a(1.001F, 1.005F, 1.001F);
		GlStateManager.func_179109_b(0, -0.0061F, 0);
		manager.func_110577_a(RenderEnergyCube.resources.get(tier));
		MekanismRenderer.glowOn();
		
		corner8.func_78785_a(size);
		corner7.func_78785_a(size);
		corner6.func_78785_a(size);
		corner5.func_78785_a(size);
		corner4.func_78785_a(size);
		corner3.func_78785_a(size);
		corner2.func_78785_a(size);
		corner1.func_78785_a(size);
		
		MekanismRenderer.glowOff();
		GlStateManager.func_179121_F();
	}
	
	public void renderSide(float size, EnumFacing side, IOState state, EnergyCubeTier tier, TextureManager renderer)
	{
		if(state != IOState.OFF)
		{
			connectors[side.ordinal()].func_78785_a(size);
			ports[side.ordinal()].func_78785_a(size);
			
			if(state == IOState.OUTPUT)
			{
				MekanismRenderer.glowOn();
				renderer.func_110577_a(RenderEnergyCube.resources.get(tier));
				
				ports[side.ordinal()].func_78785_a(size);
				
				MekanismRenderer.glowOff();
			}
		}
		
		renderer.func_110577_a(state == IOState.OUTPUT ? OVERLAY_ON : OVERLAY_OFF);
		
		if(state == IOState.OUTPUT)
		{
			MekanismRenderer.glowOn();
		}
		
		leds1[side.ordinal()].func_78785_a(size);
		leds2[side.ordinal()].func_78785_a(size);
		
		if(state == IOState.OUTPUT)
		{
			MekanismRenderer.glowOff();
		}
	}

	private void setRotation(ModelRenderer model, float x, float y, float z)
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}

	public static class ModelEnergyCore extends ModelBase
	{
		private ModelRenderer cube;

		public ModelEnergyCore()
		{
			field_78090_t = 32;
			field_78089_u = 32;

			cube = new ModelRenderer(this, 0, 0);
			cube.func_78789_a(-8, -8, -8, 16, 16, 16);
			cube.func_78793_a(0, 0, 0);
			cube.func_78787_b(32, 32);
			cube.field_78809_i = true;
		}

		public void render(float size)
		{
			cube.func_78785_a(0.0625F);
		}
	}
}
