package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelDigitalMiner extends ModelBase 
{
	public static ResourceLocation OVERLAY_ON = MekanismUtils.getResource(ResourceType.RENDER, "DigitalMiner_OverlayOn.png");
	public static ResourceLocation OVERLAY_OFF = MekanismUtils.getResource(ResourceType.RENDER, "DigitalMiner_OverlayOff.png");
	
	ModelRenderer keyboard;
	ModelRenderer keyboardBottom;
	ModelRenderer keyboardSupportExt1;
	ModelRenderer keyboardSupportExt2;
	ModelRenderer keyboardSupport1;
	ModelRenderer keyboardSupport2;
	ModelRenderer monitor1back;
	ModelRenderer monitor2back;
	ModelRenderer monitor3back;
	ModelRenderer monitorBar1;
	ModelRenderer monitorBar2;
	ModelRenderer led1;
	ModelRenderer led2;
	ModelRenderer led3;
	ModelRenderer monitorMount1;
	ModelRenderer monitorMount2;
	ModelRenderer frame1;
	ModelRenderer frame3;
	ModelRenderer plate5;
	ModelRenderer bracket1;
	ModelRenderer bracket2;
	ModelRenderer bracket3;
	ModelRenderer bracket4;
	ModelRenderer bracket5;
	ModelRenderer bracket6;
	ModelRenderer bracket7;
	ModelRenderer bracket8;
	ModelRenderer bracketPlate1;
	ModelRenderer bracketPlate2;
	ModelRenderer bracketPlate3;
	ModelRenderer bracketPlate4;
	ModelRenderer supportBeam1;
	ModelRenderer supportBeam2;
	ModelRenderer supportBeam3;
	ModelRenderer supportBeam4;
	ModelRenderer foot1;
	ModelRenderer foot2;
	ModelRenderer foot3;
	ModelRenderer foot4;
	ModelRenderer core;
	ModelRenderer powerCable1a;
	ModelRenderer powerCable1b;
	ModelRenderer powerCable2;
	ModelRenderer powerCable3;
	ModelRenderer powerConnector1;
	ModelRenderer powerConnector2a;
	ModelRenderer powerConnector2b;
	ModelRenderer powerCpnnector3a;
	ModelRenderer powerConnector3b;
	ModelRenderer frame2a;
	ModelRenderer frame2b;
	ModelRenderer frame2c;
	ModelRenderer frame2d;
	ModelRenderer monitor1;
	ModelRenderer monitor2;
	ModelRenderer monitor3;

	public ModelDigitalMiner() 
	{
		field_78090_t = 256;
		field_78089_u = 128;

		keyboard = new ModelRenderer(this, 120, 20);
		keyboard.func_78789_a(0F, -3F, -1F, 10, 5, 1);
		keyboard.func_78793_a(-5F, 14F, -5F);
		keyboard.func_78787_b(256, 128);
		keyboard.field_78809_i = true;
		setRotation(keyboard, -1.082104F, 0.0174533F, 0F);
		keyboardBottom = new ModelRenderer(this, 120, 26);
		keyboardBottom.func_78789_a(0F, -2.5F, -0.5F, 8, 4, 1);
		keyboardBottom.func_78793_a(-4F, 14F, -5F);
		keyboardBottom.func_78787_b(256, 128);
		keyboardBottom.field_78809_i = true;
		setRotation(keyboardBottom, -0.9075712F, 0F, 0F);
		keyboardSupportExt1 = new ModelRenderer(this, 138, 26);
		keyboardSupportExt1.func_78789_a(0F, 0F, -1F, 1, 1, 1);
		keyboardSupportExt1.func_78793_a(2F, 14F, -5F);
		keyboardSupportExt1.func_78787_b(256, 128);
		keyboardSupportExt1.field_78809_i = true;
		setRotation(keyboardSupportExt1, 0F, 0F, 0F);
		keyboardSupportExt2 = new ModelRenderer(this, 138, 26);
		keyboardSupportExt2.func_78789_a(0F, 0F, -1F, 1, 1, 1);
		keyboardSupportExt2.func_78793_a(-3F, 14F, -5F);
		keyboardSupportExt2.func_78787_b(256, 128);
		keyboardSupportExt2.field_78809_i = true;
		setRotation(keyboardSupportExt2, 0F, 0F, 0F);
		keyboardSupport1 = new ModelRenderer(this, 142, 20);
		keyboardSupport1.func_78789_a(0F, -1F, 0F, 1, 2, 4);
		keyboardSupport1.func_78793_a(-3F, 14F, -5F);
		keyboardSupport1.func_78787_b(256, 128);
		keyboardSupport1.field_78809_i = true;
		setRotation(keyboardSupport1, 0F, 0F, 0F);
		keyboardSupport2 = new ModelRenderer(this, 142, 20);
		keyboardSupport2.func_78789_a(0F, -1F, 0F, 1, 2, 4);
		keyboardSupport2.func_78793_a(2F, 14F, -5F);
		keyboardSupport2.func_78787_b(256, 128);
		keyboardSupport2.field_78809_i = true;
		setRotation(keyboardSupport2, 0F, 0F, 0F);
		monitor1back = new ModelRenderer(this, 88, 32);
		monitor1back.func_78789_a(-13F, -3F, 0F, 12, 6, 1);
		monitor1back.func_78793_a(-8F, 3F, -3F);
		monitor1back.func_78787_b(256, 128);
		monitor1back.field_78809_i = true;
		setRotation(monitor1back, 0.0872665F, -0.2094395F, 0F);
		monitor2back = new ModelRenderer(this, 88, 32);
		monitor2back.func_78789_a(0F, -4F, 0F, 12, 6, 1);
		monitor2back.func_78793_a(-6F, 4F, -3F);
		monitor2back.func_78787_b(256, 128);
		monitor2back.field_78809_i = true;
		setRotation(monitor2back, 0.0872665F, 0F, 0F);
		monitor3back = new ModelRenderer(this, 88, 32);
		monitor3back.func_78789_a(1F, -3F, 0F, 12, 6, 1);
		monitor3back.func_78793_a(8F, 3F, -3F);
		monitor3back.func_78787_b(256, 128);
		monitor3back.field_78809_i = true;
		setRotation(monitor3back, 0.0872665F, 0.2094395F, 0F);
		monitorBar1 = new ModelRenderer(this, 114, 36);
		monitorBar1.func_78789_a(-3.5F, -2F, -0.2F, 4, 2, 1);
		monitorBar1.func_78793_a(-6F, 4F, -3F);
		monitorBar1.func_78787_b(256, 128);
		monitorBar1.field_78809_i = true;
		setRotation(monitorBar1, 0.0872665F, -0.0523599F, 0F);
		monitorBar2 = new ModelRenderer(this, 114, 36);
		monitorBar2.func_78789_a(0.5F, -2F, -0.2F, 4, 2, 1);
		monitorBar2.func_78793_a(5F, 4F, -3F);
		monitorBar2.func_78787_b(256, 128);
		monitorBar2.field_78809_i = true;
		setRotation(monitorBar2, 0.0872665F, 0.0523599F, 0F);
		led1 = new ModelRenderer(this, 0, 0);
		led1.func_78789_a(-2F, 4.5F, -1.9F, 1, 1, 1);
		led1.func_78793_a(-8F, 3F, -3F);
		led1.func_78787_b(256, 128);
		led1.field_78809_i = true;
		setRotation(led1, 0.0872665F, -0.2094395F, 0F);
		led2 = new ModelRenderer(this, 0, 0);
		led2.func_78789_a(12F, 4.466667F, -1.9F, 1, 1, 1);
		led2.func_78793_a(-7F, 3F, -3F);
		led2.func_78787_b(256, 128);
		led2.field_78809_i = true;
		setRotation(led2, 0.0872665F, 0F, 0F);
		led3 = new ModelRenderer(this, 0, 0);
		led3.func_78789_a(12F, 4.5F, -1.9F, 1, 1, 1);
		led3.func_78793_a(8F, 3F, -3F);
		led3.func_78787_b(256, 128);
		led3.field_78809_i = true;
		setRotation(led3, 0.0872665F, 0.2094395F, 0F);
		monitorMount1 = new ModelRenderer(this, 114, 32);
		monitorMount1.func_78789_a(0F, -1F, 0F, 2, 2, 2);
		monitorMount1.func_78793_a(-4F, 3F, -3F);
		monitorMount1.func_78787_b(256, 128);
		monitorMount1.field_78809_i = true;
		setRotation(monitorMount1, 0F, 0F, 0F);
		monitorMount2 = new ModelRenderer(this, 114, 32);
		monitorMount2.func_78789_a(0F, -1F, 0F, 2, 2, 2);
		monitorMount2.func_78793_a(2F, 3F, -3F);
		monitorMount2.func_78787_b(256, 128);
		monitorMount2.field_78809_i = true;
		setRotation(monitorMount2, 0F, 0F, 0F);
		frame1 = new ModelRenderer(this, 0, 0);
		frame1.func_78789_a(0F, 0F, 0F, 32, 29, 12);
		frame1.func_78793_a(-16F, -8F, -1F);
		frame1.func_78787_b(256, 128);
		frame1.field_78809_i = true;
		setRotation(frame1, 0F, 0F, 0F);
		frame3 = new ModelRenderer(this, 0, 0);
		frame3.func_78789_a(0F, 0F, 0F, 32, 29, 12);
		frame3.func_78793_a(-16F, -8F, 28F);
		frame3.func_78787_b(256, 128);
		frame3.field_78809_i = true;
		setRotation(frame3, 0F, 0F, 0F);
		plate5 = new ModelRenderer(this, 88, 90);
		plate5.func_78789_a(0F, 0F, 0F, 32, 5, 15);
		plate5.func_78793_a(-16F, 16F, 12F);
		plate5.func_78787_b(256, 128);
		plate5.field_78809_i = true;
		setRotation(plate5, 0F, 0F, 0F);
		bracket1 = new ModelRenderer(this, 16, 85);
		bracket1.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket1.func_78793_a(-21F, -5F, 0F);
		bracket1.func_78787_b(256, 128);
		bracket1.field_78809_i = true;
		setRotation(bracket1, 0F, 0F, 0F);
		bracket2 = new ModelRenderer(this, 16, 85);
		bracket2.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket2.func_78793_a(-21F, -5F, 8F);
		bracket2.func_78787_b(256, 128);
		bracket2.field_78809_i = true;
		setRotation(bracket2, 0F, 0F, 0F);
		bracket3 = new ModelRenderer(this, 16, 85);
		bracket3.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket3.func_78793_a(-21F, -5F, 29F);
		bracket3.func_78787_b(256, 128);
		bracket3.field_78809_i = true;
		setRotation(bracket3, 0F, 0F, 0F);
		bracket4 = new ModelRenderer(this, 16, 85);
		bracket4.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket4.func_78793_a(-21F, -5F, 37F);
		bracket4.func_78787_b(256, 128);
		bracket4.field_78809_i = true;
		setRotation(bracket4, 0F, 0F, 0F);
		bracket5 = new ModelRenderer(this, 16, 85);
		bracket5.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket5.func_78793_a(16F, -5F, 0F);
		bracket5.func_78787_b(256, 128);
		bracket5.field_78809_i = true;
		setRotation(bracket5, 0F, 0F, 0F);
		bracket5.field_78809_i = false;
		bracket6 = new ModelRenderer(this, 16, 85);
		bracket6.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket6.func_78793_a(16F, -5F, 8F);
		bracket6.func_78787_b(256, 128);
		bracket6.field_78809_i = true;
		setRotation(bracket6, 0F, 0F, 0F);
		bracket7 = new ModelRenderer(this, 16, 85);
		bracket7.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket7.func_78793_a(16F, -5F, 29F);
		bracket7.func_78787_b(256, 128);
		bracket7.field_78809_i = true;
		setRotation(bracket7, 0F, 0F, 0F);
		bracket8 = new ModelRenderer(this, 16, 85);
		bracket8.func_78789_a(0F, 0F, 0F, 5, 5, 2);
		bracket8.func_78793_a(16F, -5F, 37F);
		bracket8.func_78787_b(256, 128);
		bracket8.field_78809_i = true;
		setRotation(bracket8, 0F, 0F, 0F);
		bracket8.field_78809_i = false;
		bracketPlate1 = new ModelRenderer(this, 30, 85);
		bracketPlate1.func_78789_a(0F, 0F, 0F, 1, 5, 6);
		bracketPlate1.func_78793_a(-17F, -5F, 2F);
		bracketPlate1.func_78787_b(256, 128);
		bracketPlate1.field_78809_i = true;
		setRotation(bracketPlate1, 0F, 0F, 0F);
		bracketPlate2 = new ModelRenderer(this, 30, 85);
		bracketPlate2.func_78789_a(0F, 0F, 0F, 1, 5, 6);
		bracketPlate2.func_78793_a(-17F, -5F, 31F);
		bracketPlate2.func_78787_b(256, 128);
		bracketPlate2.field_78809_i = true;
		setRotation(bracketPlate2, 0F, 0F, 0F);
		bracketPlate3 = new ModelRenderer(this, 30, 85);
		bracketPlate3.func_78789_a(0F, 0F, 0F, 1, 5, 6);
		bracketPlate3.func_78793_a(16F, -5F, 2F);
		bracketPlate3.func_78787_b(256, 128);
		bracketPlate3.field_78809_i = true;
		setRotation(bracketPlate3, 0F, 0F, 0F);
		bracketPlate4 = new ModelRenderer(this, 30, 85);
		bracketPlate4.func_78789_a(0F, 0F, 0F, 1, 5, 6);
		bracketPlate4.func_78793_a(16F, -5F, 31F);
		bracketPlate4.func_78787_b(256, 128);
		bracketPlate4.field_78809_i = true;
		setRotation(bracketPlate4, 0F, 0F, 0F);
		supportBeam1 = new ModelRenderer(this, 0, 85);
		supportBeam1.func_78789_a(0F, 0F, 0F, 4, 28, 8);
		supportBeam1.func_78793_a(-22F, -6F, 1F);
		supportBeam1.func_78787_b(256, 128);
		supportBeam1.field_78809_i = true;
		setRotation(supportBeam1, 0F, 0F, 0F);
		supportBeam2 = new ModelRenderer(this, 0, 85);
		supportBeam2.func_78789_a(0F, 0F, 0F, 4, 28, 8);
		supportBeam2.func_78793_a(-22F, -6F, 30F);
		supportBeam2.func_78787_b(256, 128);
		supportBeam2.field_78809_i = true;
		setRotation(supportBeam2, 0F, 0F, 0F);
		supportBeam3 = new ModelRenderer(this, 0, 85);
		supportBeam3.func_78789_a(0F, 0F, 0F, 4, 28, 8);
		supportBeam3.func_78793_a(18F, -6F, 1F);
		supportBeam3.func_78787_b(256, 128);
		supportBeam3.field_78809_i = true;
		setRotation(supportBeam3, 0F, 0F, 0F);
		supportBeam4 = new ModelRenderer(this, 0, 85);
		supportBeam4.func_78789_a(0F, 0F, 0F, 4, 28, 8);
		supportBeam4.func_78793_a(18F, -6F, 30F);
		supportBeam4.func_78787_b(256, 128);
		supportBeam4.field_78809_i = true;
		setRotation(supportBeam4, 0F, 0F, 0F);
		supportBeam4.field_78809_i = false;
		foot1 = new ModelRenderer(this, 44, 85);
		foot1.func_78789_a(0F, 0F, 0F, 7, 2, 10);
		foot1.func_78793_a(-23F, 22F, 0F);
		foot1.func_78787_b(256, 128);
		foot1.field_78809_i = true;
		setRotation(foot1, 0F, 0F, 0F);
		foot2 = new ModelRenderer(this, 44, 85);
		foot2.func_78789_a(0F, 0F, 0F, 7, 2, 10);
		foot2.func_78793_a(-23F, 22F, 29F);
		foot2.func_78787_b(256, 128);
		foot2.field_78809_i = true;
		setRotation(foot2, 0F, 0F, 0F);
		foot3 = new ModelRenderer(this, 44, 85);
		foot3.func_78789_a(0F, 0F, 0F, 7, 2, 10);
		foot3.func_78793_a(16F, 22F, 29F);
		foot3.func_78787_b(256, 128);
		foot3.field_78809_i = true;
		setRotation(foot3, 0F, 0F, 0F);
		foot4 = new ModelRenderer(this, 44, 85);
		foot4.func_78789_a(0F, 0F, 0F, 7, 2, 10);
		foot4.func_78793_a(16F, 22F, 0F);
		foot4.func_78787_b(256, 128);
		foot4.field_78809_i = true;
		setRotation(foot4, 0F, 0F, 0F);
		core = new ModelRenderer(this, 0, 41);
		core.func_78789_a(0F, 0F, 0F, 30, 27, 17);
		core.func_78793_a(-15F, -7F, 11F);
		core.func_78787_b(256, 128);
		core.field_78809_i = true;
		setRotation(core, 0F, 0F, 0F);
		powerCable1a = new ModelRenderer(this, 88, 39);
		powerCable1a.func_78789_a(0F, 0F, 0F, 6, 2, 11);
		powerCable1a.func_78793_a(-3F, 20F, 2F);
		powerCable1a.func_78787_b(256, 128);
		powerCable1a.field_78809_i = true;
		setRotation(powerCable1a, 0F, 0F, 0F);
		powerCable1b = new ModelRenderer(this, 94, 52);
		powerCable1b.func_78789_a(0F, 0F, 0F, 6, 3, 6);
		powerCable1b.func_78793_a(-3F, 20F, 13F);
		powerCable1b.func_78787_b(256, 128);
		powerCable1b.field_78809_i = true;
		setRotation(powerCable1b, 0F, 0F, 0F);
		powerCable2 = new ModelRenderer(this, 42, 109);
		powerCable2.func_78789_a(0F, 0F, 0F, 9, 6, 6);
		powerCable2.func_78793_a(14F, 13F, 13F);
		powerCable2.func_78787_b(256, 128);
		powerCable2.field_78809_i = true;
		setRotation(powerCable2, 0F, 0F, 0F);
		powerCable3 = new ModelRenderer(this, 42, 109);
		powerCable3.func_78789_a(0F, 0F, 0F, 9, 6, 6);
		powerCable3.func_78793_a(-23F, 13F, 13F);
		powerCable3.func_78787_b(256, 128);
		powerCable3.field_78809_i = true;
		setRotation(powerCable3, 0F, 0F, 0F);
		powerConnector1 = new ModelRenderer(this, 94, 61);
		powerConnector1.func_78789_a(0F, 0F, 0F, 8, 1, 8);
		powerConnector1.func_78793_a(-4F, 23F, 12F);
		powerConnector1.func_78787_b(256, 128);
		powerConnector1.field_78809_i = true;
		setRotation(powerConnector1, 0F, 0F, 0F);
		powerConnector2a = new ModelRenderer(this, 24, 105);
		powerConnector2a.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		powerConnector2a.func_78793_a(23F, 12F, 12F);
		powerConnector2a.func_78787_b(256, 128);
		powerConnector2a.field_78809_i = true;
		setRotation(powerConnector2a, 0F, 0F, 0F);
		powerConnector2b = new ModelRenderer(this, 24, 105);
		powerConnector2b.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		powerConnector2b.func_78793_a(16F, 12F, 12F);
		powerConnector2b.func_78787_b(256, 128);
		powerConnector2b.field_78809_i = true;
		setRotation(powerConnector2b, 0F, 0F, 0F);
		powerCpnnector3a = new ModelRenderer(this, 24, 105);
		powerCpnnector3a.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		powerCpnnector3a.func_78793_a(-24F, 12F, 12F);
		powerCpnnector3a.func_78787_b(256, 128);
		powerCpnnector3a.field_78809_i = true;
		setRotation(powerCpnnector3a, 0F, 0F, 0F);
		powerConnector3b = new ModelRenderer(this, 24, 105);
		powerConnector3b.func_78789_a(0F, 0F, 0F, 1, 8, 8);
		powerConnector3b.func_78793_a(-17F, 12F, 12F);
		powerConnector3b.func_78787_b(256, 128);
		powerConnector3b.field_78809_i = true;
		setRotation(powerConnector3b, 0F, 0F, 0F);
		frame2a = new ModelRenderer(this, 88, 0);
		frame2a.func_78789_a(0F, 0F, 0F, 32, 5, 15);
		frame2a.func_78793_a(-16F, -8F, 12F);
		frame2a.func_78787_b(256, 128);
		frame2a.field_78809_i = true;
		setRotation(frame2a, 0F, 0F, 0F);
		frame2b = new ModelRenderer(this, 126, 50);
		frame2b.func_78789_a(0F, 0F, 0F, 32, 5, 15);
		frame2b.func_78793_a(-16F, -2F, 12F);
		frame2b.func_78787_b(256, 128);
		frame2b.field_78809_i = true;
		setRotation(frame2b, 0F, 0F, 0F);
		frame2c = new ModelRenderer(this, 126, 50);
		frame2c.func_78789_a(0F, 0F, 0F, 32, 5, 15);
		frame2c.func_78793_a(-16F, 4F, 12F);
		frame2c.func_78787_b(256, 128);
		frame2c.field_78809_i = true;
		setRotation(frame2c, 0F, 0F, 0F);
		frame2d = new ModelRenderer(this, 88, 70);
		frame2d.func_78789_a(0F, 0F, 0F, 32, 5, 15);
		frame2d.func_78793_a(-16F, 10F, 12F);
		frame2d.func_78787_b(256, 128);
		frame2d.field_78809_i = true;
		setRotation(frame2d, 0F, 0F, 0F);
		monitor1 = new ModelRenderer(this, 88, 20);
		monitor1.func_78789_a(-14F, -5F, -2F, 14, 10, 2);
		monitor1.func_78793_a(-8F, 3F, -3F);
		monitor1.func_78787_b(256, 128);
		monitor1.field_78809_i = true;
		setRotation(monitor1, 0.0872665F, -0.2094395F, 0F);
		monitor2 = new ModelRenderer(this, 88, 20);
		monitor2.func_78789_a(0F, -5F, -2F, 14, 10, 2);
		monitor2.func_78793_a(-7F, 3F, -3F);
		monitor2.func_78787_b(256, 128);
		monitor2.field_78809_i = true;
		setRotation(monitor2, 0.0872665F, 0F, 0F);
		monitor3 = new ModelRenderer(this, 88, 20);
		monitor3.func_78789_a(0F, -5F, -2F, 14, 10, 2);
		monitor3.func_78793_a(8F, 3F, -3F);
		monitor3.func_78787_b(256, 128);
		monitor3.field_78809_i = true;
		setRotation(monitor3, 0.0872665F, 0.2094395F, 0F);
	}
	
	public void render(float size, boolean on, TextureManager manager, boolean renderMain)
	{
		GlStateManager.func_179094_E();
		MekanismRenderer.blendOn();
		
		if(renderMain)
		{
			doRender(size);
		}
		
		manager.func_110577_a(on ? OVERLAY_ON : OVERLAY_OFF);
		GlStateManager.func_179152_a(1.001F, 1.001F, 1.001F);
		GlStateManager.func_179109_b(0, -0.0011F, 0);
		MekanismRenderer.glowOn();
		
		doRender(size);
		
		MekanismRenderer.glowOff();
		MekanismRenderer.blendOff();
		GlStateManager.func_179121_F();
	}

	private void doRender(float size) 
	{
		keyboard.func_78785_a(size);
		keyboardBottom.func_78785_a(size);
		keyboardSupportExt1.func_78785_a(size);
		keyboardSupportExt2.func_78785_a(size);
		keyboardSupport1.func_78785_a(size);
		keyboardSupport2.func_78785_a(size);
		monitor1back.func_78785_a(size);
		monitor2back.func_78785_a(size);
		monitor3back.func_78785_a(size);
		monitorBar1.func_78785_a(size);
		monitorBar2.func_78785_a(size);
		led1.func_78785_a(size);
		led2.func_78785_a(size);
		led3.func_78785_a(size);
		monitor1.func_78785_a(size);
		monitor2.func_78785_a(size);
		monitor3.func_78785_a(size);
		monitorMount1.func_78785_a(size);
		monitorMount2.func_78785_a(size);
		frame1.func_78785_a(size);
		frame3.func_78785_a(size);
		plate5.func_78785_a(size);
		bracket1.func_78785_a(size);
		bracket2.func_78785_a(size);
		bracket3.func_78785_a(size);
		bracket4.func_78785_a(size);
		bracket5.func_78785_a(size);
		bracket6.func_78785_a(size);
		bracket7.func_78785_a(size);
		bracket8.func_78785_a(size);
		bracketPlate1.func_78785_a(size);
		bracketPlate2.func_78785_a(size);
		bracketPlate3.func_78785_a(size);
		bracketPlate4.func_78785_a(size);
		supportBeam1.func_78785_a(size);
		supportBeam2.func_78785_a(size);
		supportBeam3.func_78785_a(size);
		supportBeam4.func_78785_a(size);
		foot1.func_78785_a(size);
		foot2.func_78785_a(size);
		foot3.func_78785_a(size);
		foot4.func_78785_a(size);
		core.func_78785_a(size);
		powerCable1a.func_78785_a(size);
		powerCable1b.func_78785_a(size);
		powerCable2.func_78785_a(size);
		powerCable3.func_78785_a(size);
		powerConnector1.func_78785_a(size);
		powerConnector2a.func_78785_a(size);
		powerConnector2b.func_78785_a(size);
		powerCpnnector3a.func_78785_a(size);
		powerConnector3b.func_78785_a(size);
		frame2a.func_78785_a(size);
		frame2b.func_78785_a(size);
		frame2c.func_78785_a(size);
		frame2d.func_78785_a(size);
	}

	private void setRotation(ModelRenderer model, float x, float y, float z) 
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
