package mekanism.client.model;

import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelChargepad extends ModelBase
{
	public static ResourceLocation OVERLAY = MekanismUtils.getResource(ResourceType.RENDER, "Chargepad_Overlay.png");
	
    ModelRenderer base;
    ModelRenderer port;
    ModelRenderer plug;
    ModelRenderer connector;
    ModelRenderer stand;
    ModelRenderer pillar2;
    ModelRenderer pillar1;

	public ModelChargepad() 
	{
		field_78090_t = 64;
		field_78089_u = 64;

		base = new ModelRenderer(this, 0, 0);
		base.func_78789_a(0F, 0F, 0F, 16, 1, 16);
		base.func_78793_a(-8F, 23F, -8F);
		base.func_78787_b(64, 64);
		base.field_78809_i = true;
		setRotation(base, 0F, 0F, 0F);
		port = new ModelRenderer(this, 0, 17);
		port.func_78789_a(0F, 0F, 0F, 8, 8, 1);
		port.func_78793_a(-4F, 12F, 7F);
		port.func_78787_b(64, 64);
		port.field_78809_i = true;
		setRotation(port, 0F, 0F, 0F);
		plug = new ModelRenderer(this, 0, 11);
		plug.func_78789_a(0F, 0F, 0F, 2, 1, 2);
		plug.func_78793_a(-1F, 19F, 3F);
		plug.func_78787_b(64, 64);
		plug.field_78809_i = true;
		setRotation(plug, 0F, 0F, 0F);
		connector = new ModelRenderer(this, 18, 17);
		connector.func_78789_a(0F, 0F, 0F, 6, 6, 1);
		connector.func_78793_a(-3F, 13F, 6F);
		connector.func_78787_b(64, 64);
		connector.field_78809_i = true;
		setRotation(connector, 0F, 0F, 0F);
		stand = new ModelRenderer(this, 0, 0);
		stand.func_78789_a(0F, 0F, 0F, 6, 10, 1);
		stand.func_78793_a(-3F, 13F, 5F);
		stand.func_78787_b(64, 64);
		stand.field_78809_i = true;
		setRotation(stand, 0F, 0F, 0F);
		pillar2 = new ModelRenderer(this, 48, 0);
		pillar2.field_78809_i = true;
		pillar2.func_78789_a(0F, 0F, 0F, 2, 7, 2);
		pillar2.func_78793_a(2F, 16F, 3.99F);
		pillar2.func_78787_b(64, 64);
		setRotation(pillar2, 0F, 0F, 0F);
		pillar1 = new ModelRenderer(this, 48, 0);
		pillar1.func_78789_a(0F, 0F, 0F, 2, 7, 2);
		pillar1.func_78793_a(-4F, 16F, 3.99F);
		pillar1.func_78787_b(64, 64);
		pillar1.field_78809_i = true;
		setRotation(pillar1, 0F, 0F, 0F);
	}
	
	public void render(float size, TextureManager manager)
	{
		GlStateManager.func_179094_E();
		MekanismRenderer.blendOn();
		
		manager.func_110577_a(OVERLAY);
		GlStateManager.func_179152_a(1.001F, 1.001F, 1.001F);
		GlStateManager.func_179109_b(0, -0.0011F, 0);
		MekanismRenderer.glowOn();
		
		doRender(size);
		
		MekanismRenderer.glowOff();
		MekanismRenderer.blendOff();
		GlStateManager.func_179121_F();
	}

	private void doRender(float size) 
	{
		base.func_78785_a(size);
		port.func_78785_a(size);
		plug.func_78785_a(size);
		connector.func_78785_a(size);
		stand.func_78785_a(size);
		pillar2.func_78785_a(size);
		pillar1.func_78785_a(size);
	}

	private void setRotation(ModelRenderer model, float x, float y, float z)
	{
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}
}
