package mekanism.client.gui.element;

import java.util.UUID;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.network.PacketSecurityMode.SecurityModeMessage;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.ISecurityTile.SecurityMode;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.common.util.SecurityUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import mekanism.client.gui.element.GuiElement.Rectangle4i;

@SideOnly(Side.CLIENT)
public class GuiSecurityTab extends GuiElement
{
	public boolean isItem;
	public EnumHand currentHand;
	
	public TileEntity tileEntity;

	public GuiSecurityTab(IGuiWrapper gui, TileEntity tile, ResourceLocation def)
	{
		super(MekanismUtils.getResource(ResourceType.GUI_ELEMENT, "GuiSecurityTab.png"), gui, def);

		tileEntity = tile;
	}
	
	public GuiSecurityTab(IGuiWrapper gui, ResourceLocation def, EnumHand hand)
	{
		super(MekanismUtils.getResource(ResourceType.GUI_ELEMENT, "GuiSecurityTab.png"), gui, def);
		
		isItem = true;
		currentHand = hand;
	}
	
	@Override
	public Rectangle4i getBounds(int guiWidth, int guiHeight)
	{
		return new Rectangle4i(guiWidth + 176, guiHeight + 32, 26, 26);
	}

	@Override
	public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight)
	{
		mc.field_71446_o.func_110577_a(RESOURCE);

		guiObj.drawTexturedRect(guiWidth + 176, guiHeight + 32, 0, 0, 26, 26);

		SecurityMode mode = getSecurity();
		SecurityData data = MekanismClient.clientSecurityMap.get(getOwner());
		
		if(data != null && data.override)
		{
			mode = data.mode;
		}
		
		int renderX = 26 + (18*mode.ordinal());

		if(getOwner() != null && getOwner().equals(mc.field_71439_g.func_110124_au()) && (data == null || !data.override))
		{
			if(xAxis >= 179 && xAxis <= 197 && yAxis >= 36 && yAxis <= 54)
			{
				guiObj.drawTexturedRect(guiWidth + 179, guiHeight + 36, renderX, 0, 18, 18);
			}
			else {
				guiObj.drawTexturedRect(guiWidth + 179, guiHeight + 36, renderX, 18, 18, 18);
			}
		}
		else {
			guiObj.drawTexturedRect(guiWidth + 179, guiHeight + 36, renderX, 36, 18, 18);
		}

		mc.field_71446_o.func_110577_a(defaultLocation);
	}

	@Override
	public void renderForeground(int xAxis, int yAxis)
	{
		mc.field_71446_o.func_110577_a(RESOURCE);

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 36 && yAxis <= 54)
		{
			String securityDisplay = isItem ? SecurityUtils.getSecurityDisplay(getItem(), Side.CLIENT) : SecurityUtils.getSecurityDisplay(tileEntity, Side.CLIENT);
			String securityText = EnumColor.GREY + LangUtils.localize("gui.security") + ": " + securityDisplay;
			String ownerText = SecurityUtils.getOwnerDisplay(mc.field_71439_g, getOwnerUsername());
			String overrideText = EnumColor.RED + "(" + LangUtils.localize("gui.overridden") + ")";
			
			if(isItem ? SecurityUtils.isOverridden(getItem(), Side.CLIENT) : SecurityUtils.isOverridden(tileEntity, Side.CLIENT))
			{
				displayTooltips(ListUtils.asList(securityText, ownerText, overrideText), xAxis, yAxis); 
			}
			else {
				displayTooltips(ListUtils.asList(securityText, ownerText), xAxis, yAxis); 
			}
		}

		mc.field_71446_o.func_110577_a(defaultLocation);
	}
	
	private SecurityFrequency getFrequency()
	{
		if(isItem)
		{
			if(getItem().func_190926_b() || !(getItem().func_77973_b() instanceof ISecurityItem))
			{
				mc.field_71439_g.func_71053_j();
				return null;
			}
			
			return SecurityUtils.getFrequency(getOwner());
		}
		else {
			return ((ISecurityTile)tileEntity).getSecurity().getFrequency();
		}
	}
	
	private SecurityMode getSecurity()
	{
		if(!general.allowProtection) 
		{
			return SecurityMode.PUBLIC;
		}
		
		if(isItem)
		{
			if(getItem().func_190926_b() || !(getItem().func_77973_b() instanceof ISecurityItem))
			{
				mc.field_71439_g.func_71053_j();
				return SecurityMode.PUBLIC;
			}
			
			return ((ISecurityItem)getItem().func_77973_b()).getSecurity(getItem());
		}
		else {
			return ((ISecurityTile)tileEntity).getSecurity().getMode();
		}
	}
	
	private UUID getOwner()
	{
		if(isItem)
		{
			if(getItem().func_190926_b() || !(getItem().func_77973_b() instanceof ISecurityItem))
			{
				mc.field_71439_g.func_71053_j();
				return null;
			}
			
			return ((ISecurityItem)getItem().func_77973_b()).getOwnerUUID(getItem());
		}
		else {
			return ((ISecurityTile)tileEntity).getSecurity().getOwnerUUID();
		}
	}
	
	private String getOwnerUsername()
	{
		if(isItem)
		{
			if(getItem().func_190926_b() || !(getItem().func_77973_b() instanceof ISecurityItem))
			{
				mc.field_71439_g.func_71053_j();
				return null;
			}
			
			return MekanismClient.clientUUIDMap.get(((ISecurityItem)getItem().func_77973_b()).getOwnerUUID(getItem()));
		}
		else {
			return ((ISecurityTile)tileEntity).getSecurity().getClientOwner();
		}
	}
	
	private ItemStack getItem()
	{
		return mc.field_71439_g.func_184586_b(currentHand);
	}

	@Override
	public void preMouseClicked(int xAxis, int yAxis, int button) {}

	@Override
	public void mouseClicked(int xAxis, int yAxis, int button)
	{
		if(button == 0 && general.allowProtection)
		{
			if(getOwner() != null && mc.field_71439_g.func_110124_au().equals(getOwner()))
			{
				if(xAxis >= 179 && xAxis <= 197 && yAxis >= 36 && yAxis <= 54)
				{
					SecurityMode current = getSecurity();
					int ordinalToSet = current.ordinal() < (SecurityMode.values().length-1) ? current.ordinal()+1 : 0;
	
					SoundHandler.playSound(SoundEvents.field_187909_gi);
					
					if(isItem)
					{
						Mekanism.packetHandler.sendToServer(new SecurityModeMessage(currentHand, SecurityMode.values()[ordinalToSet]));
					}
					else {
						Mekanism.packetHandler.sendToServer(new SecurityModeMessage(Coord4D.get(tileEntity), SecurityMode.values()[ordinalToSet]));
					}
				}
			}
		}
	}
}
