package mekanism.client.gui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiSideConfiguration.GuiPos;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketConfigurationUpdate.ConfigurationPacket;
import mekanism.common.network.PacketConfigurationUpdate.ConfigurationUpdateMessage;
import mekanism.common.network.PacketSimpleGui.SimpleGuiMessage;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

@SideOnly(Side.CLIENT)
public class GuiTransporterConfig extends GuiMekanism
{
	public Map<Integer, GuiPos> slotPosMap = new HashMap<Integer, GuiPos>();
	
	public ISideConfiguration configurable;

	public GuiTransporterConfig(EntityPlayer player, ISideConfiguration tile)
	{
		super((TileEntityContainerBlock)tile, new ContainerNull(player, (TileEntityContainerBlock)tile));

		field_147000_g = 95;

		configurable = tile;
		
		slotPosMap.put(0, new GuiPos(54, 64));
		slotPosMap.put(1, new GuiPos(54, 34));
		slotPosMap.put(2, new GuiPos(54, 49));
		slotPosMap.put(3, new GuiPos(39, 64));
		slotPosMap.put(4, new GuiPos(39, 49));
		slotPosMap.put(5, new GuiPos(69, 49));
	}
	
	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		super.func_146976_a(partialTick, mouseX, mouseY);

		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiTransporterConfig.png"));

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		if(xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20)
		{
			func_73729_b(guiWidth + 6, guiHeight + 6, 176 + 14, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 6, guiHeight + 6, 176 + 14, 14, 14, 14);
		}
		
		if(xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20)
		{
			func_73729_b(guiWidth + 156, guiHeight + 6, 176 + 28, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 156, guiHeight + 6, 176 + 28, 14, 14, 14);
		}
		
		for(int i = 0; i < slotPosMap.size(); i++)
		{
			MekanismRenderer.resetColor();

			int x = slotPosMap.get(i).xPos;
			int y = slotPosMap.get(i).yPos;

			EnumColor color = configurable.getEjector().getInputColor(EnumFacing.func_82600_a(i));

			if(configurable.getConfig().getOutput(TransmissionType.ITEM, EnumFacing.func_82600_a(i)) != TileComponentConfig.EMPTY)
			{
				if(color != null)
				{
					MekanismRenderer.color(color);
				}
	
				if(xAxis >= x && xAxis <= x+14 && yAxis >= y && yAxis <= y+14)
				{
					func_73729_b(guiWidth + x, guiHeight + y, 176, 0, 14, 14);
				}
				else {
					func_73729_b(guiWidth + x, guiHeight + y, 176, 14, 14, 14);
				}
			}
			else {
				func_73729_b(guiWidth + x, guiHeight + y, 176, 28, 14, 14);
			}
		}

		MekanismRenderer.resetColor();
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		String text = LangUtils.localize("gui.configuration.transporter");
		field_146289_q.func_78276_b(text, (field_146999_f/2)-(field_146289_q.func_78256_a(text)/2), 5, 0x404040);
		text = LangUtils.localize("gui.strictInput") + " (" + LangUtils.transOnOff(configurable.getEjector().hasStrictInput()) + ")";
		renderScaledText(text, 53, 17, 0x00CD00, 70);
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.input"), 48, 81, 0x787878);
		field_146289_q.func_78276_b(LangUtils.localize("gui.output"), 114, 68, 0x787878);
		
		if(configurable.getEjector().getOutputColor() != null)
		{
			GlStateManager.func_179094_E();
			GL11.glColor4f(1, 1, 1, 1);
			GL11.glEnable(GL11.GL_LIGHTING);
			GL11.glEnable(GL12.GL_RESCALE_NORMAL);

			field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
			drawTexturedRectFromIcon(122, 49, MekanismRenderer.getColorIcon(configurable.getEjector().getOutputColor()), 16, 16);

			GL11.glDisable(GL11.GL_LIGHTING);
			GlStateManager.func_179121_F();
		}
		
		for(int i = 0; i < slotPosMap.size(); i++)
		{
			int x = slotPosMap.get(i).xPos;
			int y = slotPosMap.get(i).yPos;

			EnumColor color = configurable.getEjector().getInputColor(EnumFacing.func_82600_a(i));

			if(configurable.getConfig().getOutput(TransmissionType.ITEM, EnumFacing.func_82600_a(i)) != TileComponentConfig.EMPTY)
			{
				if(xAxis >= x && xAxis <= x+14 && yAxis >= y && yAxis <= y+14)
				{
					func_146279_a(color != null ? color.getColoredName() : LangUtils.localize("gui.none"), xAxis, yAxis);
				}
			}
		}
		
		if(xAxis >= 122 && xAxis <= 138 && yAxis >= 49 && yAxis <= 65)
		{
			if(configurable.getEjector().getOutputColor() != null)
			{
				func_146279_a(configurable.getEjector().getOutputColor().getColoredName(), xAxis, yAxis);
			}
			else {
				func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
			}
		}
		
		if(xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20)
		{
			func_146279_a(LangUtils.localize("gui.configuration.strictInput"), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}
	
	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		TileEntity tile = (TileEntity)configurable;

		if(button == 0)
		{
			if(xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20)
			{
				int guiId = Mekanism.proxy.getGuiId(tile.func_145838_q(), tile.func_145832_p());
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
			}
			
			if(xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new ConfigurationUpdateMessage(ConfigurationPacket.STRICT_INPUT, Coord4D.get(tile), 0, 0, null));
			}
		}
		
		if(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && button == 0)
		{
			button = 2;
		}
		
		if(xAxis >= 122 && xAxis <= 138 && yAxis >= 49 && yAxis <= 65)
		{
			SoundHandler.playSound(SoundEvents.field_187909_gi);
			Mekanism.packetHandler.sendToServer(new ConfigurationUpdateMessage(ConfigurationPacket.EJECT_COLOR, Coord4D.get(tile), button, 0, null));
		}
		
		for(int i = 0; i < slotPosMap.size(); i++)
		{
			int x = slotPosMap.get(i).xPos;
			int y = slotPosMap.get(i).yPos;

			if(xAxis >= x && xAxis <= x+14 && yAxis >= y && yAxis <= y+14)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new ConfigurationUpdateMessage(ConfigurationPacket.INPUT_COLOR, Coord4D.get(tile), button, i, null));
			}
		}
	}
}
