package mekanism.client.gui;

import java.util.List;

import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiFluidGauge.IFluidInfoHandler;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.inventory.container.ContainerThermalEvaporationController;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.common.util.UnitDisplayUtils.TemperatureUnit;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiThermalEvaporationController extends GuiMekanism
{
	public TileEntityThermalEvaporationController tileEntity;

	public GuiThermalEvaporationController(InventoryPlayer inventory, TileEntityThermalEvaporationController tentity)
	{
		super(tentity, new ContainerThermalEvaporationController(inventory, tentity));
		tileEntity = tentity;
		
		guiElements.add(new GuiFluidGauge(new IFluidInfoHandler() {
			@Override
			public FluidTank getTank()
			{
				return tileEntity.inputTank;
			}
		}, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(ResourceType.GUI, "GuiThermalEvaporationController.png"), 6, 13));
		guiElements.add(new GuiFluidGauge(new IFluidInfoHandler() {
			@Override
			public FluidTank getTank()
			{
				return tileEntity.outputTank;
			}
		}, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(ResourceType.GUI, "GuiThermalEvaporationController.png"), 152, 13));
		guiElements.add(new GuiHeatInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				TemperatureUnit unit = TemperatureUnit.values()[general.tempUnit.ordinal()];
				String environment = UnitDisplayUtils.getDisplayShort(tileEntity.totalLoss*unit.intervalSize, false, unit);
				return ListUtils.asList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiThermalEvaporationController.png")));
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 96) + 4, 0x404040);
		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f/2)-(field_146289_q.func_78256_a(tileEntity.func_70005_c_())/2), 4, 0x404040);

		field_146289_q.func_78276_b(getStruct(), 50, 21, 0x00CD00);
		field_146289_q.func_78276_b(LangUtils.localize("gui.height") + ": " + tileEntity.height, 50, 30, 0x00CD00);
		field_146289_q.func_78276_b(LangUtils.localize("gui.temp") + ": " + getTemp(), 50, 39, 0x00CD00);
		renderScaledText(LangUtils.localize("gui.production") + ": " + Math.round(tileEntity.lastGain*100D)/100D + " mB/t", 50, 48, 0x00CD00, 76);

		if(xAxis >= 7 && xAxis <= 23 && yAxis >= 14 && yAxis <= 72)
		{
			func_146279_a(tileEntity.inputTank.getFluid() != null ? LangUtils.localizeFluidStack(tileEntity.inputTank.getFluid()) + ": " + tileEntity.inputTank.getFluidAmount() : LangUtils.localize("gui.empty"), xAxis, yAxis);
		}

		if(xAxis >= 153 && xAxis <= 169 && yAxis >= 14 && yAxis <= 72)
		{
			func_146279_a(tileEntity.outputTank.getFluid() != null ? LangUtils.localizeFluidStack(tileEntity.outputTank.getFluid()) + ": " + tileEntity.outputTank.getFluidAmount() : LangUtils.localize("gui.empty"), xAxis, yAxis);
		}

		if(xAxis >= 49 && xAxis <= 127 && yAxis >= 64 && yAxis <= 72)
		{
			func_146279_a(getTemp(), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}

	private String getStruct()
	{
		if(tileEntity.structured)
		{
			return LangUtils.localize("gui.formed");
		}
		else {
			if(tileEntity.controllerConflict)
			{
				return LangUtils.localize("gui.conflict");
			}
			else {
				return LangUtils.localize("gui.incomplete");
			}
		}
	}

	private String getTemp()
	{
		float temp = tileEntity.getTemperature();

		return MekanismUtils.getTemperatureDisplay(temp, TemperatureUnit.AMBIENT);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiThermalEvaporationController.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int displayInt = tileEntity.getScaledTempLevel(78);
		func_73729_b(guiWidth + 49, guiHeight + 64, 176, 59, displayInt, 8);
		
		super.func_146976_a(partialTick, mouseX, mouseY);
	}
}
