package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.ClientTickHandler;
import mekanism.client.MekanismClient;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiPowerBar.IPowerInfoHandler;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotOverlay;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.inventory.container.ContainerTeleporter;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.PacketPortableTeleporter.PortableTeleporterMessage;
import mekanism.common.network.PacketPortableTeleporter.PortableTeleporterPacketType;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.security.IOwnerItem;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiTeleporter extends GuiMekanism
{
	public EnumHand currentHand;
	
	public ResourceLocation resource;
	
	public TileEntityTeleporter tileEntity;
	public ItemStack itemStack = ItemStack.field_190927_a;
	
	public EntityPlayer entityPlayer;
	
	public GuiButton publicButton;
	public GuiButton privateButton;
	
	public GuiButton setButton;
	public GuiButton deleteButton;
	
	public GuiButton teleportButton;
	
	public GuiScrollList scrollList;
	
	public GuiTextField frequencyField;
	
	public boolean privateMode;
	
	public Frequency clientFreq;
	public byte clientStatus;
	
	public List<Frequency> clientPublicCache = new ArrayList<Frequency>();
	public List<Frequency> clientPrivateCache = new ArrayList<Frequency>();
	
	public boolean isInit = true;

	public GuiTeleporter(InventoryPlayer inventory, TileEntityTeleporter tentity)
	{
		super(tentity, new ContainerTeleporter(inventory, tentity));
		tileEntity = tentity;
		resource = MekanismUtils.getResource(ResourceType.GUI, "GuiTeleporter.png");

		guiElements.add(new GuiRedstoneControl(this, tileEntity, resource));
		guiElements.add(new GuiUpgradeTab(this, tileEntity, resource));
		guiElements.add(new GuiPowerBar(this, new IPowerInfoHandler() {
			@Override
			public String getTooltip()
			{
				return MekanismUtils.getEnergyDisplay(getEnergy(), getMaxEnergy());
			}
			
			@Override
			public double getLevel()
			{
				return getEnergy()/getMaxEnergy();
			}
		}, resource, 158, 26));
		guiElements.add(new GuiSlot(SlotType.NORMAL, this, resource, 152, 6).with(SlotOverlay.POWER));
		guiElements.add(scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4));
		
		if(tileEntity.frequency != null)
		{
			privateMode = !tileEntity.frequency.publicFreq;
		}
		
		field_147000_g+=64;
	}
	
	public GuiTeleporter(EntityPlayer player, EnumHand hand, ItemStack stack)
	{
		super(new ContainerNull());
		currentHand = hand;
		itemStack = stack;
		entityPlayer = player;
		resource = MekanismUtils.getResource(ResourceType.GUI, "GuiPortableTeleporter.png");
		
		guiElements.add(new GuiPowerBar(this, new IPowerInfoHandler() {
			@Override
			public String getTooltip()
			{
				return MekanismUtils.getEnergyDisplay(getEnergy(), getMaxEnergy());
			}
			
			@Override
			public double getLevel()
			{
				return getEnergy()/getMaxEnergy();
			}
		}, resource, 158, 26));
		guiElements.add(scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4));
		
		ItemPortableTeleporter item = (ItemPortableTeleporter)itemStack.func_77973_b();
		
		if(item.getFrequency(stack) != null)
		{
			privateMode = item.isPrivateMode(itemStack);
			setFrequency(item.getFrequency(stack));
		}
		else {
			Mekanism.packetHandler.sendToServer(new PortableTeleporterMessage(PortableTeleporterPacketType.DATA_REQUEST, currentHand, clientFreq));
		}
		
		field_147000_g = 175;
	}
	
	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		
		publicButton = new GuiButton(0, guiWidth + 27, guiHeight + 14, 60, 20, LangUtils.localize("gui.public"));
		privateButton = new GuiButton(1, guiWidth + 89, guiHeight + 14, 60, 20, LangUtils.localize("gui.private"));
		
		setButton = new GuiButton(2, guiWidth + 27, guiHeight + 116, 60, 20, LangUtils.localize("gui.set"));
		deleteButton = new GuiButton(3, guiWidth + 89, guiHeight + 116, 60, 20, LangUtils.localize("gui.delete"));
		
		if(!itemStack.func_190926_b())
		{
			teleportButton = new GuiButton(4, guiWidth + 42, guiHeight + 140, 92, 20, LangUtils.localize("gui.teleport"));
		}

		frequencyField = new GuiTextField(5, field_146289_q, guiWidth + 50, guiHeight + 104, 86, 11);
		frequencyField.func_146203_f(FrequencyManager.MAX_FREQ_LENGTH);
		
		frequencyField.func_146185_a(false);
		
		updateButtons();

		field_146292_n.add(publicButton);
		field_146292_n.add(privateButton);
		field_146292_n.add(setButton);
		field_146292_n.add(deleteButton);
		
		if(!itemStack.func_190926_b())
		{
			field_146292_n.add(teleportButton);
			
			if(!isInit)
			{
				Mekanism.packetHandler.sendToServer(new PortableTeleporterMessage(PortableTeleporterPacketType.DATA_REQUEST, currentHand, clientFreq));
			}
			else {
				isInit = false;
			}
		}
	}
	
	public void setFrequency(String freq)
	{
		if(freq.isEmpty())
		{
			return;
		}
		
		if(tileEntity != null)
		{
			ArrayList data = new ArrayList();
			data.add(0);
			data.add(freq);
			data.add(!privateMode);
			
			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
		}
		else {
			Frequency newFreq = new Frequency(freq, null).setPublic(!privateMode);
			
			Mekanism.packetHandler.sendToServer(new PortableTeleporterMessage(PortableTeleporterPacketType.SET_FREQ, currentHand, newFreq));
		}
	}
	
	public String getSecurity(Frequency freq)
	{
		return !freq.publicFreq ? EnumColor.DARK_RED + LangUtils.localize("gui.private") : LangUtils.localize("gui.public");
	}
	
	public void updateButtons()
	{
		if(getOwner() == null)
		{
			return;
		}
		
		List<String> text = new ArrayList<String>();
		
		if(privateMode)
		{
			for(Frequency freq : getPrivateCache())
			{
				text.add(freq.name);
			}
		}
		else {
			for(Frequency freq : getPublicCache())
			{
				text.add(freq.name + " (" + freq.clientOwner + ")");
			}
		}
		
		scrollList.setText(text);
		
		if(privateMode)
		{
			publicButton.field_146124_l = true;
			privateButton.field_146124_l = false;
		}
		else {
			publicButton.field_146124_l = false;
			privateButton.field_146124_l = true;
		}
		
		if(scrollList.hasSelection())
		{
			Frequency freq = privateMode ? getPrivateCache().get(scrollList.selected) : getPublicCache().get(scrollList.selected);
			
			if(getFrequency() == null || !getFrequency().equals(freq))
			{
				setButton.field_146124_l = true;
			}
			else {
				setButton.field_146124_l = false;
			}
			
			if(getOwner().equals(freq.ownerUUID))
			{
				deleteButton.field_146124_l = true;
			}
			else {
				deleteButton.field_146124_l = false;
			}
		}
		else {
			setButton.field_146124_l = false;
			deleteButton.field_146124_l = false;
		}
		
		if(!itemStack.func_190926_b())
		{
			if(clientFreq != null && clientStatus == 1)
			{
				teleportButton.field_146124_l = true;
			}
			else {
				teleportButton.field_146124_l = false;
			}
		}
	}
	
	@Override
	public void func_73876_c()
	{
		super.func_73876_c();
		
		updateButtons();
		
		frequencyField.func_146178_a();
	}
	
	@Override
	public void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);
		
		updateButtons();

		frequencyField.func_146192_a(mouseX, mouseY, button);
		
		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
			
			if(xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114)
			{
				setFrequency(frequencyField.func_146179_b());
				frequencyField.func_146180_a("");
	            SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
		}
	}
	
	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!frequencyField.func_146206_l() || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}
		
		if(i == Keyboard.KEY_RETURN)
		{
			if(frequencyField.func_146206_l())
			{
				setFrequency(frequencyField.func_146179_b());
				frequencyField.func_146180_a("");
			}
		}

		if(Character.isDigit(c) || Character.isLetter(c) || isTextboxKey(c, i) || FrequencyManager.SPECIAL_CHARS.contains(c))
		{
			frequencyField.func_146201_a(c, i);
		}
		
		updateButtons();
	}
	
	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			privateMode = false;
		}
		else if(guibutton.field_146127_k == 1)
		{
			privateMode = true;
		}
		else if(guibutton.field_146127_k == 2)
		{
			int selection = scrollList.getSelection();
			
			if(selection != -1)
			{
				Frequency freq = privateMode ? getPrivateCache().get(selection) : getPublicCache().get(selection);
				setFrequency(freq.name);
			}
		}
		else if(guibutton.field_146127_k == 3)
		{
			int selection = scrollList.getSelection();
			
			if(selection != -1)
			{
				Frequency freq = privateMode ? getPrivateCache().get(selection) : getPublicCache().get(selection);
				
				if(tileEntity != null)
				{
					ArrayList data = new ArrayList();
					data.add(1);
					data.add(freq.name);
					data.add(freq.publicFreq);
					
					Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				}
				else {
					Mekanism.packetHandler.sendToServer(new PortableTeleporterMessage(PortableTeleporterPacketType.DEL_FREQ, currentHand, freq));
					Mekanism.packetHandler.sendToServer(new PortableTeleporterMessage(PortableTeleporterPacketType.DATA_REQUEST, currentHand, null));
				}
				
				scrollList.selected = -1;
			}
		}
		else if(guibutton.field_146127_k == 4)
		{
			if(clientFreq != null && clientStatus == 1)
			{
				field_146297_k.func_71381_h();
				ClientTickHandler.portableTeleport(entityPlayer, currentHand, clientFreq);
			}
		}
		
		updateButtons();
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX-(field_146294_l-field_146999_f)/2);
		int yAxis = (mouseY-(field_146295_m-field_147000_g)/2);

		field_146289_q.func_78276_b(getName(), (field_146999_f/2)-(field_146289_q.func_78256_a(getName())/2), 4, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.owner") + ": " + (getOwnerUsername() != null ? getOwnerUsername() : LangUtils.localize("gui.none")), 8, !itemStack.func_190926_b() ? field_147000_g-12 : (field_147000_g-96)+4, 0x404040);
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.freq") + ":", 32, 81, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.security") + ":", 32, 91, 0x404040);
		
		field_146289_q.func_78276_b(" " + (getFrequency() != null ? getFrequency().name : EnumColor.DARK_RED + LangUtils.localize("gui.none")), 32 + field_146289_q.func_78256_a(LangUtils.localize("gui.freq") + ":"), 81, 0x797979);
		field_146289_q.func_78276_b(" " + (getFrequency() != null ? getSecurity(getFrequency()) : EnumColor.DARK_RED + LangUtils.localize("gui.none")), 32 + field_146289_q.func_78256_a(LangUtils.localize("gui.security") + ":"), 91, 0x797979);
		
		String str = LangUtils.localize("gui.set") + ":";
		renderScaledText(str, 27, 104, 0x404040, 20);
		
		if(xAxis >= 6 && xAxis <= 24 && yAxis >= 6 && yAxis <= 24)
		{
			if(getFrequency() == null)
			{
				func_146279_a(EnumColor.DARK_RED + LangUtils.localize("gui.teleporter.noFreq"), xAxis, yAxis);
			}
			else {
				func_146279_a(getStatusDisplay(), xAxis, yAxis);
			}
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(resource);
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l-field_146999_f)/2;
		int guiHeight = (field_146295_m-field_147000_g)/2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		if(xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114)
		{
			func_73729_b(guiWidth + 137, guiHeight + 103, field_146999_f, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 137, guiHeight + 103, field_146999_f, 11, 11, 11);
		}
		
		int y = getFrequency() == null ? 94 : (getStatus() == 2 ? 22 : (getStatus() == 3 ? 40 : 
			(getStatus() == 4 ? 58 : 76)));
		
		func_73729_b(guiWidth + 6, guiHeight + 6, 176, y, 18, 18);

		super.func_146976_a(partialTick, mouseX, mouseY);
		
		frequencyField.func_146194_f();
	}
	
	public String getStatusDisplay()
	{
		switch(getStatus())
		{
			case 1:
				return EnumColor.DARK_GREEN + LangUtils.localize("gui.teleporter.ready");
			case 2:
				return EnumColor.DARK_RED + LangUtils.localize("gui.teleporter.noFrame");
			case 3:
				return EnumColor.DARK_RED + LangUtils.localize("gui.teleporter.noLink");
			case 4:
				return EnumColor.DARK_RED + LangUtils.localize("gui.teleporter.needsEnergy");
		}
		
		return EnumColor.DARK_RED + LangUtils.localize("gui.teleporter.noLink");
	}
	
	private UUID getOwner()
	{
		if(tileEntity != null)
		{
			return tileEntity.getSecurity().getOwnerUUID();
		}
		else {
			return ((IOwnerItem)itemStack.func_77973_b()).getOwnerUUID(itemStack);
		}
	}
	
	private String getOwnerUsername()
	{
		if(tileEntity != null)
		{
			return tileEntity.getSecurity().getClientOwner();
		}
		else {
			return MekanismClient.clientUUIDMap.get(((IOwnerItem)itemStack.func_77973_b()).getOwnerUUID(itemStack));
		}
	}
	
	private byte getStatus()
	{
		return tileEntity != null ? tileEntity.status : clientStatus;
	}
	
	private List<Frequency> getPublicCache()
	{
		return tileEntity != null ? tileEntity.publicCache : clientPublicCache;
	}
	
	private List<Frequency> getPrivateCache()
	{
		return tileEntity != null ? tileEntity.privateCache : clientPrivateCache;
	}
	
	private Frequency getFrequency()
	{
		return tileEntity != null ? tileEntity.frequency : clientFreq;
	}
	
	private String getName()
	{
		return tileEntity != null ? tileEntity.func_70005_c_() : itemStack.func_82833_r();
	}
	
	private double getEnergy()
	{
		if(!itemStack.func_190926_b())
		{
			return ((ItemPortableTeleporter)itemStack.func_77973_b()).getEnergy(itemStack);
		}
		
		return tileEntity.getEnergy();
	}
	
	private double getMaxEnergy()
	{
		if(!itemStack.func_190926_b())
		{
			return ((ItemPortableTeleporter)itemStack.func_77973_b()).getMaxEnergy(itemStack);
		}
		
		return tileEntity.getMaxEnergy();
	}
}
