package mekanism.client.gui;

import java.io.IOException;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.OreDictCache;
import mekanism.common.content.transporter.TOreDictFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter.EditFilterMessage;
import mekanism.common.network.PacketLogisticalSorterGui.LogisticalSorterGuiMessage;
import mekanism.common.network.PacketLogisticalSorterGui.SorterGuiPacket;
import mekanism.common.network.PacketNewFilter.NewFilterMessage;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

@SideOnly(Side.CLIENT)
public class GuiTOreDictFilter extends GuiMekanism
{
	public TileEntityLogisticalSorter tileEntity;

	public boolean isNew = false;

	public TOreDictFilter origFilter;

	public TOreDictFilter filter = new TOreDictFilter();

	private GuiTextField oreDictText;

	public ItemStack renderStack = ItemStack.field_190927_a;

	public int ticker = 0;

	public int stackSwitch = 0;

	public int stackIndex = 0;

	public List<ItemStack> iterStacks;

	public String status = EnumColor.DARK_GREEN + LangUtils.localize("gui.allOK");

	public GuiTOreDictFilter(EntityPlayer player, TileEntityLogisticalSorter tentity, int index)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;

		origFilter = (TOreDictFilter)tileEntity.filters.get(index);
		filter = ((TOreDictFilter)tentity.filters.get(index)).clone();

		updateStackList(filter.oreDictName);
	}

	public GuiTOreDictFilter(EntityPlayer player, TileEntityLogisticalSorter tentity)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;

		isNew = true;
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		field_146292_n.add(new GuiButton(0, guiWidth + 47, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
		field_146292_n.add(new GuiButton(1, guiWidth + 109, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));

		if(isNew)
		{
			field_146292_n.get(1).field_146124_l = false;
		}

		oreDictText = new GuiTextField(2, field_146289_q, guiWidth + 35, guiHeight + 47, 95, 12);
		oreDictText.func_146203_f(TransporterFilter.MAX_LENGTH);
		oreDictText.func_146195_b(true);
	}

	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!oreDictText.func_146206_l() || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(oreDictText.func_146206_l() && i == Keyboard.KEY_RETURN)
		{
			setOreDictKey();
			return;
		}

		if(Character.isLetter(c) || Character.isDigit(c) || TransporterFilter.SPECIAL_CHARS.contains(c) || isTextboxKey(c, i))
		{
			oreDictText.func_146201_a(c, i);
		}
	}

	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			if(!oreDictText.func_146179_b().isEmpty())
			{
				setOreDictKey();
			}

			if(filter.oreDictName != null && !filter.oreDictName.isEmpty())
			{
				if(isNew)
				{
					Mekanism.packetHandler.sendToServer(new NewFilterMessage(Coord4D.get(tileEntity), filter));
				}
				else {
					Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), false, origFilter, filter));
				}

				Mekanism.packetHandler.sendToServer(new LogisticalSorterGuiMessage(SorterGuiPacket.SERVER, Coord4D.get(tileEntity), 0, 0, 0));
			}
			else {
				status = EnumColor.DARK_RED + LangUtils.localize("gui.oredictFilter.noKey");
				ticker = 20;
			}
		}
		else if(guibutton.field_146127_k == 1)
		{
			Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), true, origFilter, null));
			Mekanism.packetHandler.sendToServer(new LogisticalSorterGuiMessage(SorterGuiPacket.SERVER, Coord4D.get(tileEntity), 0, 0, 0));
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b((isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.oredictFilter"), 43, 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + status, 35, 20, 0x00CD00);
		renderScaledText(LangUtils.localize("gui.key") + ": " + filter.oreDictName, 35, 32, 0x00CD00, 107);
		field_146289_q.func_78276_b(LangUtils.localize("gui." + (filter.allowDefault ? "on" : "off")), 24, 66, 0x404040);

		if(!renderStack.func_190926_b())
		{
			try {
				GlStateManager.func_179094_E();
				RenderHelper.func_74520_c();
				field_146296_j.func_180450_b(renderStack, 12, 19);
				RenderHelper.func_74518_a();
				GlStateManager.func_179121_F();
			} catch(Exception e) {}
		}

		if(filter.color != null)
		{
			GlStateManager.func_179094_E();
			GL11.glColor4f(1, 1, 1, 1);
			GL11.glEnable(GL11.GL_LIGHTING);
			GL11.glEnable(GL12.GL_RESCALE_NORMAL);

			field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
			drawTexturedRectFromIcon(12, 44, MekanismRenderer.getColorIcon(filter.color), 16, 16);

			GL11.glDisable(GL11.GL_LIGHTING);
			GlStateManager.func_179121_F();
		}
		
		if(xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75)
		{
			func_146279_a(LangUtils.localize("gui.allowDefault"), xAxis, yAxis);
		}

		if(xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60)
		{
			if(filter.color != null)
			{
				func_146279_a(filter.color.getColoredName(), xAxis, yAxis);
			}
			else {
				func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
			}
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiTOreDictFilter.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
		{
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
		}

		if(xAxis >= 131 && xAxis <= 143 && yAxis >= 47 && yAxis <= 59)
		{
			func_73729_b(guiWidth + 131, guiHeight + 47, 176 + 11, 0, 12, 12);
		}
		else {
			func_73729_b(guiWidth + 131, guiHeight + 47, 176 + 11, 12, 12, 12);
		}
		
		if(xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75)
		{
			func_73729_b(guiWidth + 11, guiHeight + 64, 199, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 11, guiHeight + 64, 199, 11, 11, 11);
		}

		oreDictText.func_146194_f();
		
		super.func_146976_a(partialTick, mouseX, mouseY);
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		oreDictText.func_146178_a();

		if(ticker > 0)
		{
			ticker--;
		}
		else {
			status = EnumColor.DARK_GREEN + LangUtils.localize("gui.allOK");
		}

		if(stackSwitch > 0)
		{
			stackSwitch--;
		}

		if(stackSwitch == 0 && iterStacks != null && iterStacks.size() > 0)
		{
			stackSwitch = 20;

			if(stackIndex == -1 || stackIndex == iterStacks.size()-1)
			{
				stackIndex = 0;
			}
			else if(stackIndex < iterStacks.size()-1)
			{
				stackIndex++;
			}

			renderStack = iterStacks.get(stackIndex);
		}
		else if(iterStacks != null && iterStacks.size() == 0)
		{
			renderStack = ItemStack.field_190927_a;
		}
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		oreDictText.func_146192_a(mouseX, mouseY, button);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(button == 0)
		{
			if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new LogisticalSorterGuiMessage(SorterGuiPacket.SERVER, Coord4D.get(tileEntity), isNew ? 4 : 0, 0, 0));
			}

			if(xAxis >= 131 && xAxis <= 143 && yAxis >= 47 && yAxis <= 59)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				setOreDictKey();
			}
			
			if(xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				filter.allowDefault = !filter.allowDefault;
			}
		}

		if(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && button == 0)
		{
			button = 2;
		}

		if(xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60)
		{
			SoundHandler.playSound(MekanismSounds.DING);

			if(button == 0)
			{
				filter.color = TransporterUtils.increment(filter.color);
			}
			else if(button == 1)
			{
				filter.color = TransporterUtils.decrement(filter.color);
			}
			else if(button == 2)
			{
				filter.color = null;
			}
		}
	}

	private void updateStackList(String oreName)
	{
		iterStacks = OreDictCache.getOreDictStacks(oreName, false);

		stackSwitch = 0;
		stackIndex = -1;
	}

	private void setOreDictKey()
	{
		String oreName = oreDictText.func_146179_b();

		if(oreName == null || oreName.isEmpty())
		{
			status = EnumColor.DARK_RED + LangUtils.localize("gui.oredictFilter.noKey");
			return;
		}
		else if(oreName.equals(filter.oreDictName))
		{
			status = EnumColor.DARK_RED + LangUtils.localize("gui.oredictFilter.sameKey");
			return;
		}

		updateStackList(oreName);

		filter.oreDictName = oreName;
		oreDictText.func_146180_a("");
	}
}
