package mekanism.client.gui;

import java.io.IOException;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter.EditFilterMessage;
import mekanism.common.network.PacketLogisticalSorterGui.LogisticalSorterGuiMessage;
import mekanism.common.network.PacketLogisticalSorterGui.SorterGuiPacket;
import mekanism.common.network.PacketNewFilter.NewFilterMessage;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

@SideOnly(Side.CLIENT)
public class GuiTItemStackFilter extends GuiMekanism
{
	public TileEntityLogisticalSorter tileEntity;

	public boolean isNew = false;

	public TItemStackFilter origFilter;

	public TItemStackFilter filter = new TItemStackFilter();

	public String status = EnumColor.DARK_GREEN + LangUtils.localize("gui.allOK");

	public int ticker;

	private GuiTextField minField;
	private GuiTextField maxField;

	public GuiTItemStackFilter(EntityPlayer player, TileEntityLogisticalSorter tentity, int index)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;

		origFilter = (TItemStackFilter)tileEntity.filters.get(index);
		filter = ((TItemStackFilter)tileEntity.filters.get(index)).clone();
	}

	public GuiTItemStackFilter(EntityPlayer player, TileEntityLogisticalSorter tentity)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;

		isNew = true;
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		field_146292_n.add(new GuiButton(0, guiWidth + 47, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
		field_146292_n.add(new GuiButton(1, guiWidth + 109, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));

		if(isNew)
		{
			((GuiButton)field_146292_n.get(1)).field_146124_l = false;
		}

		minField = new GuiTextField(2, field_146289_q, guiWidth + 149, guiHeight + 19, 20, 11);
		minField.func_146203_f(2);
		minField.func_146180_a("" + filter.min);

		maxField = new GuiTextField(3, field_146289_q, guiWidth + 149, guiHeight + 31, 20, 11);
		maxField.func_146203_f(2);
		maxField.func_146180_a("" + filter.max);
	}

	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			if(!filter.itemType.func_190926_b() && !minField.func_146179_b().isEmpty() && !maxField.func_146179_b().isEmpty())
			{
				int min = Integer.parseInt(minField.func_146179_b());
				int max = Integer.parseInt(maxField.func_146179_b());

				if(max >= min && max <= 64 && min <= 64)
				{
					filter.min = Integer.parseInt(minField.func_146179_b());
					filter.max = Integer.parseInt(maxField.func_146179_b());

					if(isNew)
					{
						Mekanism.packetHandler.sendToServer(new NewFilterMessage(Coord4D.get(tileEntity), filter));
					}
					else {
						Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), false, origFilter, filter));
					}

					Mekanism.packetHandler.sendToServer(new LogisticalSorterGuiMessage(SorterGuiPacket.SERVER, Coord4D.get(tileEntity), 0, 0, 0));
				}
				else if(min > max)
				{
					status = EnumColor.DARK_RED + "Max<min";
					ticker = 20;
				}
				else if(max > 64 || min > 64)
				{
					status = EnumColor.DARK_RED + "Max>64";
					ticker = 20;
				}
			}
			else if(filter.itemType.func_190926_b())
			{
				status = EnumColor.DARK_RED + "No item";
				ticker = 20;
			}
			else if(minField.func_146179_b().isEmpty() || maxField.func_146179_b().isEmpty())
			{
				status = EnumColor.DARK_RED + "Max/min";
				ticker = 20;
			}
		}
		else if(guibutton.field_146127_k == 1)
		{
			Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), true, origFilter, null));
			Mekanism.packetHandler.sendToServer(new LogisticalSorterGuiMessage(SorterGuiPacket.SERVER, Coord4D.get(tileEntity), 0, 0, 0));
		}
	}

	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if((!minField.func_146206_l() && !maxField.func_146206_l()) || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(Character.isDigit(c) || isTextboxKey(c, i))
		{
			minField.func_146201_a(c, i);
			maxField.func_146201_a(c, i);
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b((isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.itemFilter"), 43, 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + status, 35, 20, 0x00CD00);
		field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.details") + ":", 35, 32, 0x00CD00);

		field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.min") + ":", 128, 20, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.max") + ":", 128, 32, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui." + (filter.sizeMode ? "on" : "off")), 141, 46, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui." + (filter.allowDefault ? "on" : "off")), 24, 66, 0x404040);

		if(!filter.itemType.func_190926_b())
		{
			renderScaledText(filter.itemType.func_82833_r(), 35, 41, 0x00CD00, 89);
			GlStateManager.func_179094_E();
			RenderHelper.func_74520_c();
			field_146296_j.func_180450_b(filter.itemType, 12, 19);
			RenderHelper.func_74518_a();
			GlStateManager.func_179121_F();
		}

		if(filter.color != null)
		{
			GlStateManager.func_179094_E();
			GL11.glColor4f(1, 1, 1, 1);
			GL11.glEnable(GL11.GL_LIGHTING);
			GL11.glEnable(GL12.GL_RESCALE_NORMAL);

			field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
			drawTexturedRectFromIcon(12, 44, MekanismRenderer.getColorIcon(filter.color), 16, 16);

			GL11.glDisable(GL11.GL_LIGHTING);
			GlStateManager.func_179121_F();
		}
		
		if(xAxis >= 128 && xAxis <= 139 && yAxis >= 44 && yAxis <= 55)
		{
			func_146279_a(LangUtils.localize("gui.sizeMode"), xAxis, yAxis);
		}
		
		if(xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75)
		{
			func_146279_a(LangUtils.localize("gui.allowDefault"), xAxis, yAxis);
		}

		if(xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60)
		{
			if(filter.color != null)
			{
				func_146279_a(filter.color.getColoredName(), xAxis, yAxis);
			}
			else {
				func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
			}
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		minField.func_146178_a();
		maxField.func_146178_a();

		if(ticker > 0)
		{
			ticker--;
		}
		else {
			status = EnumColor.DARK_GREEN + LangUtils.localize("gui.allOK");
		}
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiTItemStackFilter.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
		{
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
		}

		if(xAxis >= 128 && xAxis <= 139 && yAxis >= 44 && yAxis <= 55)
		{
			func_73729_b(guiWidth + 128, guiHeight + 44, 187, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 128, guiHeight + 44, 187, 11, 11, 11);
		}
		
		if(xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75)
		{
			func_73729_b(guiWidth + 11, guiHeight + 64, 198, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 11, guiHeight + 64, 198, 11, 11, 11);
		}

		minField.func_146194_f();
		maxField.func_146194_f();

		if(xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179140_f();
			GlStateManager.func_179097_i();
			GlStateManager.func_179135_a(true, true, true, false);

			int x = guiWidth + 12;
			int y = guiHeight + 19;
			func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);

			GlStateManager.func_179135_a(true, true, true, true);
			GlStateManager.func_179145_e();
			GlStateManager.func_179126_j();
			GlStateManager.func_179121_F();
		}
		
		super.func_146976_a(partialTick, mouseX, mouseY);
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		minField.func_146192_a(mouseX, mouseY, button);
		maxField.func_146192_a(mouseX, mouseY, button);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(button == 0)
		{
			if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new LogisticalSorterGuiMessage(SorterGuiPacket.SERVER, Coord4D.get(tileEntity), isNew ? 4 : 0, 0, 0));
			}

			if(xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35)
			{
				ItemStack stack = field_146297_k.field_71439_g.field_71071_by.func_70445_o();

				if(!stack.func_190926_b() && !Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					filter.itemType = stack.func_77946_l();
					filter.itemType.func_190920_e(1);
				}
				else if(stack.func_190926_b() && Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					filter.itemType = ItemStack.field_190927_a;
				}

                SoundHandler.playSound(SoundEvents.field_187909_gi);
			}

			if(xAxis >= 128 && xAxis <= 139 && yAxis >= 44 && yAxis <= 55)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				filter.sizeMode = !filter.sizeMode;
			}
			
			if(xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				filter.allowDefault = !filter.allowDefault;
			}
		}

		if(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && button == 0)
		{
			button = 2;
		}

		if(xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60)
		{
			SoundHandler.playSound(MekanismSounds.DING);

			if(button == 0)
			{
				filter.color = TransporterUtils.increment(filter.color);
			}
			else if(button == 1)
			{
				filter.color = TransporterUtils.decrement(filter.color);
			}
			else if(button == 2)
			{
				filter.color = null;
			}
		}
	}
}
