package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.element.GuiConfigTypeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketConfigurationUpdate.ConfigurationPacket;
import mekanism.common.network.PacketConfigurationUpdate.ConfigurationUpdateMessage;
import mekanism.common.network.PacketSimpleGui.SimpleGuiMessage;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiSideConfiguration extends GuiMekanism
{
	public Map<Integer, GuiPos> slotPosMap = new HashMap<Integer, GuiPos>();

	public ISideConfiguration configurable;
	
	public TransmissionType currentType;
	
	public List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();

	public GuiSideConfiguration(EntityPlayer player, ISideConfiguration tile)
	{
		super((TileEntityContainerBlock)tile, new ContainerNull(player, (TileEntityContainerBlock)tile));

		field_147000_g = 95;

		configurable = tile;
		
		for(TransmissionType type : configurable.getConfig().transmissions)
		{
			GuiConfigTypeTab tab = new GuiConfigTypeTab(this, (TileEntity)configurable, type, MekanismUtils.getResource(ResourceType.GUI, "GuiConfiguration.png"));
			
			guiElements.add(tab);
			configTabs.add(tab);
		}
		
		currentType = getTopTransmission();
		
		updateTabs();

		slotPosMap.put(0, new GuiPos(81, 64));
		slotPosMap.put(1, new GuiPos(81, 34));
		slotPosMap.put(2, new GuiPos(81, 49));
		slotPosMap.put(3, new GuiPos(66, 64));
		slotPosMap.put(4, new GuiPos(66, 49));
		slotPosMap.put(5, new GuiPos(96, 49));
	}
	
	public TransmissionType getTopTransmission()
	{
		return configurable.getConfig().transmissions.get(0);
	}
	
	public void updateTabs()
	{
		int rendered = 0;
		
		for(GuiConfigTypeTab tab : configTabs)
		{
			tab.visible = currentType != tab.transmission;
			
			if(tab.visible)
			{
				tab.left = rendered >= 0 && rendered <= 2;
				tab.setY(2+((rendered%3)*(26+2)));
			}
			
			rendered++;
		}
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		super.func_146976_a(partialTick, mouseX, mouseY);

		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiConfiguration.png"));

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		if(xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20)
		{
			func_73729_b(guiWidth + 6, guiHeight + 6, 176 + 28, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 6, guiHeight + 6, 176 + 28, 14, 14, 14);
		}

		if(xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20)
		{
			func_73729_b(guiWidth + 156, guiHeight + 6, 176 + 14, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 156, guiHeight + 6, 176 + 14, 14, 14, 14);
		}

		for(int i = 0; i < slotPosMap.size(); i++)
		{
			MekanismRenderer.resetColor();

			int x = slotPosMap.get(i).xPos;
			int y = slotPosMap.get(i).yPos;

			SideData data = configurable.getConfig().getOutput(currentType, EnumFacing.func_82600_a(i));

			if(data != TileComponentConfig.EMPTY)
			{
				if(data.color != EnumColor.GREY)
				{
					MekanismRenderer.color(data.color);
				}
				
				if(xAxis >= x && xAxis <= x+14 && yAxis >= y && yAxis <= y+14)
				{
					func_73729_b(guiWidth + x, guiHeight + y, 176, 0, 14, 14);
				}
				else {
					func_73729_b(guiWidth + x, guiHeight + y, 176, 14, 14, 14);
				}
			}
			else {
				func_73729_b(guiWidth + x, guiHeight + y, 176, 28, 14, 14);
			}
		}

		MekanismRenderer.resetColor();
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		String title = currentType.localize() + " " + LangUtils.localize("gui.config");
		field_146289_q.func_78276_b(title, (field_146999_f/2)-(field_146289_q.func_78256_a(title)/2), 5, 0x404040);
		
		if(configurable.getConfig().canEject(currentType))
		{
			field_146289_q.func_78276_b(LangUtils.localize("gui.eject") + ": " + (configurable.getConfig().isEjecting(currentType) ? "On" : "Off"), 53, 17, 0x00CD00);
		}
		else {
			field_146289_q.func_78276_b(LangUtils.localize("gui.noEject"), 53, 17, 0x00CD00);
		}
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.slots"), 77, 81, 0x787878);

		for(int i = 0; i < slotPosMap.size(); i++)
		{
			int x = slotPosMap.get(i).xPos;
			int y = slotPosMap.get(i).yPos;

			SideData data = configurable.getConfig().getOutput(currentType, EnumFacing.func_82600_a(i));

			if(data != TileComponentConfig.EMPTY)
			{
				if(xAxis >= x && xAxis <= x+14 && yAxis >= y && yAxis <= y+14)
				{
					func_146279_a(data.color + data.localize() + " (" + data.color.getColoredName() + ")", xAxis, yAxis);
				}
			}
		}

		if(xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20)
		{
			func_146279_a(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		TileEntity tile = (TileEntity)configurable;

		if(tile == null || field_146297_k.field_71441_e.func_175625_s(tile.func_174877_v()) == null)
		{
			field_146297_k.func_147108_a(null);
		}
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		TileEntity tile = (TileEntity)configurable;

		if(button == 0)
		{
			if(xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20)
			{
				int guiId = Mekanism.proxy.getGuiId(tile.func_145838_q(), tile.func_145832_p());
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
			}

			if(xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new ConfigurationUpdateMessage(ConfigurationPacket.EJECT, Coord4D.get(tile), 0, 0, currentType));
			}
		}

		if(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && button == 0)
		{
			button = 2;
		}

		for(int i = 0; i < slotPosMap.size(); i++)
		{
			int x = slotPosMap.get(i).xPos;
			int y = slotPosMap.get(i).yPos;

			if(xAxis >= x && xAxis <= x+14 && yAxis >= y && yAxis <= y+14)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new ConfigurationUpdateMessage(ConfigurationPacket.SIDE_DATA, Coord4D.get(tile), button, i, currentType));
			}
		}
	}

	public static class GuiPos
	{
		public int xPos;
		public int yPos;

		public GuiPos(int x, int y)
		{
			xPos = x;
			yPos = y;
		}
	}
}
