package mekanism.client.gui;

import java.util.List;

import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotOverlay;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.common.config.MekanismConfig.usage;
import mekanism.common.inventory.container.ContainerSeismicVibrator;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiSeismicVibrator extends GuiMekanism
{
	public TileEntitySeismicVibrator tileEntity;

	public GuiSeismicVibrator(InventoryPlayer inventory, TileEntitySeismicVibrator tentity)
	{
		super(tentity, new ContainerSeismicVibrator(inventory, tentity));
		tileEntity = tentity;

		guiElements.add(new GuiSecurityTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiSeismicVibrator.png")));
		guiElements.add(new GuiRedstoneControl(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiSeismicVibrator.png")));
		guiElements.add(new GuiPowerBar(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiSeismicVibrator.png"), 164, 15));
		guiElements.add(new GuiEnergyInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				String multiplier = MekanismUtils.getEnergyDisplay(usage.seismicVibratorUsage);
				return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.getMaxEnergy()-tileEntity.getEnergy()));
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiSeismicVibrator.png")));

		guiElements.add(new GuiSlot(SlotType.NORMAL, this, MekanismUtils.getResource(ResourceType.GUI, "GuiSeismicVibrator.png"), 142, 34).with(SlotOverlay.POWER));
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), 45, 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);
		
		field_146289_q.func_78276_b(tileEntity.isActive ? LangUtils.localize("gui.vibrating") : LangUtils.localize("gui.idle"), 19, 26, 0x00CD00);
		field_146289_q.func_78276_b(LangUtils.localize("gui.chunk") + ": " + (tileEntity.func_174877_v().func_177958_n() >> 4) + ", " + (tileEntity.func_174877_v().func_177952_p() >> 4), 19, 35, 0x00CD00);

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiSeismicVibrator.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = mouseX - guiWidth;
		int yAxis = mouseY - guiHeight;

		super.func_146976_a(partialTick, mouseX, mouseY);
	}
}
