package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;

import mekanism.api.Coord4D;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

@SideOnly(Side.CLIENT)
public class GuiSeismicReader extends GuiScreen
{
	private World worldObj;

	public ItemStack itemStack;

	private ArrayList<Pair<Integer, Block>> blockList = new ArrayList<Pair<Integer, Block>>();

	public Coord4D pos;

	protected int xSize = 137;

	protected int ySize = 182;

	private Rectangle upButton, downButton, tooltip;

	private int currentLayer = 0;

	public GuiSeismicReader(World world, Coord4D coord, ItemStack stack)
	{
		pos = new Coord4D(coord.xCoord, Math.min(255, coord.yCoord), coord.zCoord, world.field_73011_w.getDimension());
		worldObj = world;

		itemStack = stack;
		calculate();
		currentLayer = Math.max(0, blockList.size() - 1);
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		upButton = new Rectangle((field_146294_l - xSize) / 2 + 70, (field_146295_m - ySize) / 2 + 75, 13, 13);
		downButton = new Rectangle((field_146294_l - xSize) / 2 + 70, (field_146295_m - ySize) / 2 + 92, 13, 13);
		tooltip = new Rectangle((field_146294_l - xSize) / 2 + 30, (field_146295_m - ySize) / 2 + 82, 16, 16);
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTick)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - xSize) / 2;
		int guiHeight = (field_146295_m - ySize) / 2;

		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiSeismicReader.png"));

		func_73729_b(guiWidth, guiHeight, 0, 0, xSize, ySize);
		// Draws the up button
		
		if(upButton.intersects(new Rectangle(mouseX, mouseY, 1, 1)))
		{
			GL11.glColor3f(0.5f, 0.5f, 1f);
		}
		
		func_73729_b(upButton.getX(), upButton.getY(), 137, 0, upButton.getWidth(), upButton.getHeight());
		GL11.glColor3f(1, 1, 1);
		
		// Draws the down button
		if(downButton.intersects(new Rectangle(mouseX, mouseY, 1, 1)))
		{
			GL11.glColor3f(0.5f, 0.5f, 1f);
		}
		
		func_73729_b(downButton.getX(), downButton.getY(), 150, 0, downButton.getWidth(), downButton.getHeight());
		GL11.glColor3f(1, 1, 1);

		// Fix the overlapping if > 100
		GlStateManager.func_179094_E();
		GlStateManager.func_179109_b(guiWidth + 48, guiHeight + 87, 0);
		
		if(currentLayer >= 100)
		{
			GlStateManager.func_179109_b(0, 1, 0);
			GlStateManager.func_179152_a(0.7f, 0.7f, 0.7f);
		}
		
		field_146289_q.func_78276_b(String.format("%s", currentLayer), 0, 0, 0xAFAFAF);
		GlStateManager.func_179121_F();

		// Render the item stacks
		for(int i = 0; i < 9; i++)
		{
			int centralX = guiWidth + 32, centralY = guiHeight + 103;
			int layer = currentLayer + (i - 5);
			
			if(0 <= layer && layer < blockList.size())
			{
				ItemStack stack = new ItemStack(blockList.get(layer).getRight(), 1, blockList.get(layer).getLeft());
				
				if(stack.func_77973_b() == null)
				{
					continue;
				}
				
				GlStateManager.func_179094_E();
				GlStateManager.func_179109_b(centralX - 2, centralY - i * 16 + (22 * 2), 0);
				
				if(i < 4)
				{
					GlStateManager.func_179109_b(0.2f, 2.5f, 0);
				}
				
				if(i != 4)
				{
					GlStateManager.func_179109_b(1.5f, 0, 0);
					GlStateManager.func_179152_a(0.8f, 0.8f, 0.8f);
				}
				
				RenderHelper.func_74520_c();
				field_146296_j.func_180450_b(stack, 0, 0);
				RenderHelper.func_74518_a();
				GlStateManager.func_179121_F();
			}
		}

		// Get the name from the stack and render it
		if(currentLayer - 1 >= 0)
		{
			ItemStack nameStack = new ItemStack(blockList.get(currentLayer - 1).getRight(), 1, blockList.get(currentLayer - 1).getLeft());
			String renderString = "unknown";
			
			if(nameStack.func_77973_b() != null)
			{
				renderString = nameStack.func_82833_r();
			}
			else if(blockList.get(currentLayer - 1).getRight() == Blocks.field_150350_a)
			{
				renderString = "Air";
			}
			
			String capitalised = renderString.substring(0, 1).toUpperCase() + renderString.substring(1);
			float renderScale = 1.0f;
			int lengthX = field_146289_q.func_78256_a(capitalised);

			renderScale = lengthX > 53 ? 53f / lengthX : 1.0f;

			GlStateManager.func_179094_E();
			GlStateManager.func_179109_b(guiWidth + 72, guiHeight + 16, 0);
			GlStateManager.func_179152_a(renderScale, renderScale, renderScale);
			field_146289_q.func_78276_b(capitalised, 0, 0, 0x919191);
			GlStateManager.func_179121_F();
			
			if(tooltip.intersects(new Rectangle(mouseX, mouseY, 1, 1)))
			{
				field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI_ELEMENT, "GuiTooltips.png"));
				int fontLengthX = field_146289_q.func_78256_a(capitalised) + 5;
				int renderX = mouseX + 10, renderY = mouseY - 5;
				GlStateManager.func_179094_E();
				GL11.glColor3f(1, 1, 1);
				func_73729_b(renderX, renderY, 0, 0, fontLengthX, 16);
				func_73729_b(renderX + fontLengthX, renderY, 0, 16, 2, 16);
				field_146289_q.func_78276_b(capitalised, renderX + 4, renderY + 4, 0x919191);
				GlStateManager.func_179121_F();
			}
		}

		int frequency = 0;

		for(Pair<Integer, Block> pair : blockList)
		{
			if(blockList.get(currentLayer - 1) != null)
			{
				Block block = blockList.get(currentLayer - 1).getRight();

				if(pair.getRight() == block && pair.getLeft() == blockList.get(currentLayer - 1).getLeft())
				{
					frequency++;
				}
			}
		}

		GlStateManager.func_179094_E();
		GlStateManager.func_179109_b(guiWidth + 72, guiHeight + 26, 0);
		GlStateManager.func_179152_a(0.70f, 0.70f, 0.70f);
		field_146289_q.func_78276_b(LangUtils.localize("gui.abundancy") + ": " + frequency, 0, 0, 0x919191);
		GlStateManager.func_179121_F();
		super.func_73863_a(mouseX, mouseY, partialTick);
	}

	public String wrapString(String str, int index)
	{
		String string = str;

		for(int i = 0; i < string.length(); i++)
		{
			if(i == index)
			{
				string = string.substring(0, i) + "\n" + string.substring(i);
			}
		}

		return string;
	}

	@Override
	public void func_146281_b()
	{
		super.func_146281_b();

		blockList.clear();
	}

	public void calculate()
	{
		for(BlockPos p = new BlockPos(pos.xCoord, 0, pos.zCoord); p.func_177956_o() < pos.yCoord; p = p.func_177984_a())
		{
			IBlockState state = worldObj.func_180495_p(p);
			Block block = state.func_177230_c();
			int metadata = block.func_176201_c(state);
			
			blockList.add(Pair.of(metadata, block));
		}
	}

	@Override
	protected void func_73864_a(int xPos, int yPos, int buttonClicked) throws IOException
	{
		super.func_73864_a(xPos, yPos, buttonClicked);

		if(upButton.intersects(new Rectangle(xPos, yPos, 1, 1)))
		{
			if(currentLayer + 1 <= blockList.size() - 1)
			{
				currentLayer++;
			}
		}

		if(downButton.intersects(new Rectangle(xPos, yPos, 1, 1)))
		{
			if(currentLayer - 1 >= 1)
			{
				currentLayer--;
			}
		}
	}

	@Override
	public boolean func_73868_f()
	{
		return false;
	}
}
