package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerSecurityDesk;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.security.ISecurityTile.SecurityMode;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiSecurityDesk extends GuiMekanism
{
	public static int MAX_LENGTH = 24;
	
	public ResourceLocation resource;
	
	public TileEntitySecurityDesk tileEntity;
	
	public EntityPlayer entityPlayer;
	
	public GuiButton removeButton;
	
	public GuiScrollList scrollList;
	
	public GuiTextField trustedField;
	
	public static final List<Character> SPECIAL_CHARS = Arrays.asList('-', '|', '_');

	public GuiSecurityDesk(InventoryPlayer inventory, TileEntitySecurityDesk tentity)
	{
		super(tentity, new ContainerSecurityDesk(inventory, tentity));
		tileEntity = tentity;
		resource = MekanismUtils.getResource(ResourceType.GUI, "GuiSecurityDesk.png");

		guiElements.add(scrollList = new GuiScrollList(this, resource, 14, 14, 120, 4));
		
		field_147000_g+=64;
	}
	
	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();

		removeButton = new GuiButton(0, guiWidth + 13, guiHeight + 81, 122, 20, LangUtils.localize("gui.remove"));
		
		trustedField = new GuiTextField(1, field_146289_q, guiWidth + 35, guiHeight + 69, 86, 11);
		trustedField.func_146203_f(MAX_LENGTH);
		trustedField.func_146185_a(false);
		
		updateButtons();

		field_146292_n.add(removeButton);
	}
	
	public void addTrusted(String trusted)
	{
		if(trusted.isEmpty())
		{
			return;
		}
		
		ArrayList<Object> data = new ArrayList<Object>();
		data.add(0);
		data.add(trusted);
		
		Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
	}
	
	public void updateButtons()
	{
		if(tileEntity.clientOwner == null)
		{
			return;
		}
		
		List<String> text = new ArrayList<String>();
		
		if(tileEntity.frequency != null)
		{
			for(String s : tileEntity.frequency.trusted)
			{
				text.add(s);
			}
		}
		
		scrollList.setText(text);
		
		if(scrollList.hasSelection())
		{
			removeButton.field_146124_l = true;
		}
		else {
			removeButton.field_146124_l = false;
		}
	}
	
	@Override
	public void func_73876_c()
	{
		super.func_73876_c();
		
		updateButtons();
		
		trustedField.func_146178_a();
	}
	
	@Override
	public void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);
		
		updateButtons();

		trustedField.func_146192_a(mouseX, mouseY, button);
		
		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
			
			if(tileEntity.frequency != null && tileEntity.ownerUUID != null && tileEntity.clientOwner.equals(field_146297_k.field_71439_g.func_70005_c_()))
			{
				if(xAxis >= 123 && xAxis <= 134 && yAxis >= 68 && yAxis <= 79)
				{
					addTrusted(trustedField.func_146179_b());
					trustedField.func_146180_a("");
		            SoundHandler.playSound(SoundEvents.field_187909_gi);
				}
				
				ArrayList<Object> data = new ArrayList<Object>();
				
				if(xAxis >= 146 && xAxis <= 162 && yAxis >= 59 && yAxis <= 75)
				{
					data.add(2);
				}
				
				if(tileEntity.frequency.securityMode != SecurityMode.PUBLIC)
				{
					if(xAxis >= 13 && xAxis <= 53 && yAxis >= 113 && yAxis <= 129)
					{
						data.add(3);
						data.add(0);
					}
				}
				
				if(tileEntity.frequency.securityMode != SecurityMode.PRIVATE)
				{
					if(xAxis >= 54 && xAxis <= 94 && yAxis >= 113 && yAxis <= 129)
					{
						data.add(3);
						data.add(1);
					}
				}
				
				if(tileEntity.frequency.securityMode != SecurityMode.TRUSTED)
				{
					if(xAxis >= 95 && xAxis <= 135 && yAxis >= 113 && yAxis <= 129)
					{
						data.add(3);
						data.add(2);
					}
				}
				
				if(!data.isEmpty())
				{
					Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				}
			}
		}
	}
	
	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!trustedField.func_146206_l() || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(i == Keyboard.KEY_RETURN)
		{
			if(trustedField.func_146206_l())
			{
				addTrusted(trustedField.func_146179_b());
				trustedField.func_146180_a("");
			}
		}

		if(SPECIAL_CHARS.contains(c) || Character.isDigit(c) || Character.isLetter(c) || isTextboxKey(c, i))
		{
			trustedField.func_146201_a(c, i);
		}
		
		updateButtons();
	}
	
	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			int selection = scrollList.getSelection();
			
			if(tileEntity.frequency != null && selection != -1)
			{
				if(tileEntity != null)
				{
					ArrayList<Object> data = new ArrayList<Object>();
					data.add(1);
					data.add(tileEntity.frequency.trusted.get(selection));
					
					Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				}
				
				scrollList.selected = -1;
			}
		}
		
		updateButtons();
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX-(field_146294_l-field_146999_f)/2);
		int yAxis = (mouseY-(field_146295_m-field_147000_g)/2);

		String ownerText = EnumColor.RED + tileEntity.clientOwner != null ? (LangUtils.localize("gui.owner") + ": " + tileEntity.clientOwner) : LangUtils.localize("gui.noOwner");
		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f/2)-(field_146289_q.func_78256_a(tileEntity.func_70005_c_())/2), 4, 0x404040);
		field_146289_q.func_78276_b(ownerText, (field_146999_f - 7) - field_146289_q.func_78256_a(ownerText), (field_147000_g - 96) + 2, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);
		
		String trusted = LangUtils.localize("gui.trustedPlayers");
		field_146289_q.func_78276_b(trusted, 74-(field_146289_q.func_78256_a(trusted)/2), 57, 0x787878);
		
		String security = EnumColor.RED + LangUtils.localize("gui.securityOffline");
		
		if(tileEntity.frequency != null)
		{
			security = LangUtils.localize("gui.security") + ": " + tileEntity.frequency.securityMode.getDisplay();
		}
		
		field_146289_q.func_78276_b(security, 13, 103, 0x404040);
		
		renderScaledText(LangUtils.localize("gui.add") + ":", 13, 70, 0x404040, 20);
		
		if(tileEntity.frequency != null && xAxis >= 146 && xAxis <= 162 && yAxis >= 59 && yAxis <= 75)
		{
			displayTooltip(LangUtils.localize("gui.securityOverride") + ": " + LangUtils.transOnOff(tileEntity.frequency.override), xAxis, yAxis);
		}
		
		if(xAxis >= 13 && xAxis <= 53 && yAxis >= 113 && yAxis <= 129)
		{
			displayTooltip(LangUtils.localize("gui.publicMode"), xAxis, yAxis);
		}
		
		if(xAxis >= 54 && xAxis <= 94 && yAxis >= 113 && yAxis <= 129)
		{
			displayTooltip(LangUtils.localize("gui.privateMode"), xAxis, yAxis);
		}
		
		if(xAxis >= 95 && xAxis <= 135 && yAxis >= 113 && yAxis <= 129)
		{
			displayTooltip(LangUtils.localize("gui.trustedMode"), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(resource);
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l-field_146999_f)/2;
		int guiHeight = (field_146295_m-field_147000_g)/2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		if(tileEntity.frequency != null && tileEntity.clientOwner != null && field_146297_k.field_71439_g.func_70005_c_().equals(tileEntity.clientOwner))
		{
			func_73729_b(guiWidth + 145, guiHeight + 78, field_146999_f + (tileEntity.frequency.override ? 0 : 6), 22, 6, 6);
			
			if(xAxis >= 146 && xAxis <= 162 && yAxis >= 59 && yAxis <= 75)
			{
				func_73729_b(guiWidth + 146, guiHeight + 59, field_146999_f + 12, 0, 16, 16);
			}
			else {
				func_73729_b(guiWidth + 146, guiHeight + 59, field_146999_f + 12, 16, 16, 16);
			}
			
			if(tileEntity.frequency.securityMode != SecurityMode.PUBLIC)
			{
				if(xAxis >= 13 && xAxis <= 53 && yAxis >= 113 && yAxis <= 129)
				{
					func_73729_b(guiWidth + 13, guiHeight + 113, field_146999_f, 48, 40, 16);
				}
				else {
					func_73729_b(guiWidth + 13, guiHeight + 113, field_146999_f, 64, 40, 16);
				}
			}
			else {
				func_73729_b(guiWidth + 13, guiHeight + 113, field_146999_f, 80, 40, 16);
			}
			
			if(tileEntity.frequency.securityMode != SecurityMode.PRIVATE)
			{
				if(xAxis >= 54 && xAxis <= 94 && yAxis >= 113 && yAxis <= 129)
				{
					func_73729_b(guiWidth + 54, guiHeight + 113, field_146999_f + 40, 48, 40, 16);
				}
				else {
					func_73729_b(guiWidth + 54, guiHeight + 113, field_146999_f + 40, 64, 40, 16);
				}
			}
			else {
				func_73729_b(guiWidth + 54, guiHeight + 113, field_146999_f + 40, 80, 40, 16);
			}
			
			if(tileEntity.frequency.securityMode != SecurityMode.TRUSTED)
			{
				if(xAxis >= 95 && xAxis <= 135 && yAxis >= 113 && yAxis <= 129)
				{
					func_73729_b(guiWidth + 95, guiHeight + 113, field_146999_f, 96, 40, 16);
				}
				else {
					func_73729_b(guiWidth + 95, guiHeight + 113, field_146999_f, 112, 40, 16);
				}
			}
			else {
				func_73729_b(guiWidth + 95, guiHeight + 113, field_146999_f, 128, 40, 16);
			}
		}
		else {
			func_73729_b(guiWidth + 145, guiHeight + 78, field_146999_f, 28, 6, 6);
			func_73729_b(guiWidth + 146, guiHeight + 59, field_146999_f + 12, 32, 16, 16);
			func_73729_b(guiWidth + 13, guiHeight + 113, field_146999_f, 80, 40, 16);
			func_73729_b(guiWidth + 54, guiHeight + 113, field_146999_f + 40, 80, 40, 16);
			func_73729_b(guiWidth + 95, guiHeight + 113, field_146999_f, 128, 40, 16);
		}
		
		if(xAxis >= 123 && xAxis <= 134 && yAxis >= 68 && yAxis <= 79)
		{
			func_73729_b(guiWidth + 123, guiHeight + 68, field_146999_f, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 123, guiHeight + 68, field_146999_f, 11, 11, 11);
		}

		super.func_146976_a(partialTick, mouseX, mouseY);
		
		trustedField.func_146194_f();
	}
}
