package mekanism.client.gui;

import java.io.IOException;

import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.ContainerRobitSmelting;
import mekanism.common.network.PacketRobit.RobitMessage;
import mekanism.common.network.PacketRobit.RobitPacketType;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;

import org.lwjgl.opengl.GL11;

public class GuiRobitSmelting extends GuiMekanism
{
	public EntityRobit robit;

	public GuiRobitSmelting(InventoryPlayer inventory, EntityRobit entity)
	{
		super(new ContainerRobitSmelting(inventory, entity));
		robit = entity;
		field_146999_f += 25;
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		field_146289_q.func_78276_b(LangUtils.localize("gui.robit.smelting"), 8, 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, field_147000_g - 96 + 3, 0x404040);

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		super.func_146976_a(partialTick, mouseX, mouseY);

		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiRobitSmelting.png"));
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 10 && yAxis <= 28)
		{
			func_73729_b(guiWidth + 179, guiHeight + 10, 176 + 25, 0, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 10, 176 + 25, 18, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 30 && yAxis <= 48)
		{
			func_73729_b(guiWidth + 179, guiHeight + 30, 176 + 25, 36, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 30, 176 + 25, 54, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 50 && yAxis <= 68)
		{
			func_73729_b(guiWidth + 179, guiHeight + 50, 176 + 25, 72, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 50, 176 + 25, 90, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 70 && yAxis <= 88)
		{
			func_73729_b(guiWidth + 179, guiHeight + 70, 176 + 25, 108, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 70, 176 + 25, 126, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 90 && yAxis <= 108)
		{
			func_73729_b(guiWidth + 179, guiHeight + 90, 176 + 25, 144, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 90, 176 + 25, 162, 18, 18);
		}

		int displayInt;

		if(robit.furnaceBurnTime > 0)
		{
			displayInt = getBurnTimeRemainingScaled(12);
			func_73729_b(guiWidth + 56, guiHeight + 36 + 12 - displayInt, 176 + 25 + 18, 36 + 12 - displayInt, 14, displayInt + 2);
		}

		displayInt = getCookProgressScaled(24);
		func_73729_b(guiWidth + 79, guiHeight + 34, 176 + 25 + 18, 36 + 14, displayInt + 1, 16);
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 179 && xAxis <= 197 && yAxis >= 10 && yAxis <= 28)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 0, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 21, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 30 && yAxis <= 48)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 1, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 22, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 50 && yAxis <= 68)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 2, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 23, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 70 && yAxis <= 88)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 90 && yAxis <= 108)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 4, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 25, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
		}
	}

	private int getCookProgressScaled(int i)
	{
		return robit.furnaceCookTime * i / 200;
	}

	private int getBurnTimeRemainingScaled(int i)
	{
		if(robit.currentItemBurnTime == 0)
		{
			robit.currentItemBurnTime = 200;
		}

		return robit.furnaceBurnTime * i / robit.currentItemBurnTime;
	}
}
