package mekanism.client.gui;

import io.netty.buffer.Unpooled;

import java.io.IOException;

import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.ContainerRobitRepair;
import mekanism.common.network.PacketRobit.RobitMessage;
import mekanism.common.network.PacketRobit.RobitPacketType;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiRobitRepair extends GuiMekanism implements IContainerListener
{
	private EntityRobit robit;
	private ContainerRepair repairContainer;
	private GuiTextField itemNameField;
	private InventoryPlayer playerInventory;

	public GuiRobitRepair(InventoryPlayer inventory, EntityRobit entity)
	{
		super(new ContainerRobitRepair(inventory, entity));
		robit = entity;
		field_146999_f += 25;
		playerInventory = inventory;
		repairContainer = (ContainerRobitRepair)field_147002_h;
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();
		Keyboard.enableRepeatEvents(true);

		int i = (field_146294_l - field_146999_f) / 2;
		int j = (field_146295_m - field_147000_g) / 2;

		itemNameField = new GuiTextField(0, field_146289_q, i + 62, j + 24, 103, 12);
		itemNameField.func_146193_g(-1);
		itemNameField.func_146204_h(-1);
		itemNameField.func_146185_a(false);
		itemNameField.func_146203_f(30);
		field_147002_h.func_82847_b(this);
		field_147002_h.func_75132_a(this);
	}

	@Override
	public void func_146281_b()
	{
		super.func_146281_b();
		Keyboard.enableRepeatEvents(false);
		field_147002_h.func_82847_b(this);
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		GL11.glDisable(GL11.GL_LIGHTING);
		field_146289_q.func_78276_b(LangUtils.localize("container.repair"), 60, 6, 4210752);

		if(repairContainer.field_82854_e > 0)
		{
			int k = 8453920;
			boolean flag = true;
			String s = I18n.func_74837_a("container.repair.cost", repairContainer.field_82854_e);

			if(repairContainer.field_82854_e >= 40 && !field_146297_k.field_71439_g.field_71075_bZ.field_75098_d)
			{
				s = LangUtils.localize("container.repair.expensive");
				k = 16736352;
			}
			else if(!repairContainer.func_75139_a(2).func_75216_d())
			{
				flag = false;
			}
			else if(!repairContainer.func_75139_a(2).func_82869_a(playerInventory.field_70458_d))
			{
				k = 16736352;
			}

			if(flag)
			{
				int l = -16777216 | (k & 16579836) >> 2 | k & -16777216;
				int i1 = (field_146999_f - 25) - 8 - field_146289_q.func_78256_a(s);
				byte b0 = 67;

				if(field_146289_q.func_82883_a())
				{
					func_73734_a(i1 - 3, b0 - 2, (field_146999_f - 25) - 7, b0 + 10, -16777216);
					func_73734_a(i1 - 2, b0 - 1, (field_146999_f - 25) - 8, b0 + 9, -12895429);
				}
				else {
					field_146289_q.func_78276_b(s, i1, b0 + 1, l);
					field_146289_q.func_78276_b(s, i1 + 1, b0, l);
					field_146289_q.func_78276_b(s, i1 + 1, b0 + 1, l);
				}

				field_146289_q.func_78276_b(s, i1, b0, k);
			}
		}

		GL11.glEnable(GL11.GL_LIGHTING);

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_73869_a(char c, int i) throws IOException
	{
		if(itemNameField.func_146201_a(c, i))
		{
			repairContainer.func_82850_a(itemNameField.func_146179_b());
			field_146297_k.field_71439_g.field_71174_a.func_147297_a(new CPacketCustomPayload("MC|ItemName", (new PacketBuffer(Unpooled.buffer())).func_180714_a(itemNameField.func_146179_b())));
		}
		else {
			super.func_73869_a(c, i);
		}
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		itemNameField.func_146192_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 179 && xAxis <= 197 && yAxis >= 10 && yAxis <= 28)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 0, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 21, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 30 && yAxis <= 48)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 1, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 22, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 50 && yAxis <= 68)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 2, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 23, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 70 && yAxis <= 88)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 3, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 24, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 90 && yAxis <= 108)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
		}
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTick)
	{
		super.func_73863_a(mouseX, mouseY, partialTick);

		GL11.glDisable(GL11.GL_LIGHTING);
		itemNameField.func_146194_f();
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		super.func_146976_a(partialTick, mouseX, mouseY);

		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiRobitRepair.png"));
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 10 && yAxis <= 28)
		{
			func_73729_b(guiWidth + 179, guiHeight + 10, 176 + 25, 0, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 10, 176 + 25, 18, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 30 && yAxis <= 48)
		{
			func_73729_b(guiWidth + 179, guiHeight + 30, 176 + 25, 36, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 30, 176 + 25, 54, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 50 && yAxis <= 68)
		{
			func_73729_b(guiWidth + 179, guiHeight + 50, 176 + 25, 72, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 50, 176 + 25, 90, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 70 && yAxis <= 88)
		{
			func_73729_b(guiWidth + 179, guiHeight + 70, 176 + 25, 108, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 70, 176 + 25, 126, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 90 && yAxis <= 108)
		{
			func_73729_b(guiWidth + 179, guiHeight + 90, 176 + 25, 144, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 90, 176 + 25, 162, 18, 18);
		}

		func_73729_b(guiWidth + 59, guiHeight + 20, 0, field_147000_g + (repairContainer.func_75139_a(0).func_75216_d() ? 0 : 16), 110, 16);

		if((repairContainer.func_75139_a(0).func_75216_d() || repairContainer.func_75139_a(1).func_75216_d()) && !repairContainer.func_75139_a(2).func_75216_d())
		{
			func_73729_b(guiWidth + 99, guiHeight + 45, field_146999_f + 18, 36, 28, 21);
		}
	}

	@Override
	public void func_71110_a(Container container, NonNullList<ItemStack> list)
	{
		func_71111_a(container, 0, container.func_75139_a(0).func_75211_c());
	}

	@Override
	public void func_71111_a(Container container, int slotID, ItemStack itemstack)
	{
		if(slotID == 0)
		{
			itemNameField.func_146180_a(itemstack.func_190926_b() ? "" : itemstack.func_82833_r());
			itemNameField.func_146184_c(!itemstack.func_190926_b());

			if(!itemstack.func_190926_b())
			{
				repairContainer.func_82850_a(itemNameField.func_146179_b());
				field_146297_k.field_71439_g.field_71174_a.func_147297_a(new CPacketCustomPayload("MC|ItemName", (new PacketBuffer(Unpooled.buffer())).func_180714_a(itemNameField.func_146179_b())));
			}
		}
	}

	@Override
	public void func_71112_a(Container par1Container, int par2, int par3) {}

	@Override
	public void func_175173_a(Container p_175173_1_, IInventory p_175173_2_) {}
}
