package mekanism.client.gui;

import java.io.IOException;

import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.ContainerRobitMain;
import mekanism.common.network.PacketRobit.RobitMessage;
import mekanism.common.network.PacketRobit.RobitPacketType;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiRobitMain extends GuiMekanism
{
	public EntityRobit robit;

	public boolean displayNameChange;

	private GuiTextField nameChangeField;
	private GuiButton confirmName;

	public GuiRobitMain(InventoryPlayer inventory, EntityRobit entity)
	{
		super(new ContainerRobitMain(inventory, entity));
		field_146999_f += 25;
		robit = entity;
	}

	private void toggleNameChange()
	{
		displayNameChange = !displayNameChange;
		confirmName.field_146125_m = displayNameChange;
		nameChangeField.func_146195_b(displayNameChange);
	}

	private void changeName()
	{
		if(nameChangeField.func_146179_b() != null && !nameChangeField.func_146179_b().isEmpty())
		{
			Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.NAME, robit.func_145782_y(), 0, nameChangeField.func_146179_b()));
			toggleNameChange();
			nameChangeField.func_146180_a("");
		}
	}

	@Override
	protected void func_146284_a(GuiButton guibutton)
	{
		if(guibutton.field_146127_k == 0)
		{
			changeName();
		}
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		field_146292_n.add(confirmName = new GuiButton(0, guiWidth + 58, guiHeight + 47, 60, 20, LangUtils.localize("gui.confirm")));
		confirmName.field_146125_m = displayNameChange;

		nameChangeField = new GuiTextField(1, field_146289_q, guiWidth + 48, guiHeight + 21, 80, 12);
		nameChangeField.func_146203_f(12);
		nameChangeField.func_146195_b(true);
	}

	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!displayNameChange)
		{
			super.func_73869_a(c, i);
		}
		else {
			if(i == Keyboard.KEY_RETURN)
			{
				changeName();
			}
			else if(i == Keyboard.KEY_ESCAPE)
			{
				field_146297_k.field_71439_g.func_71053_j();
			}

			nameChangeField.func_146201_a(c, i);
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		field_146289_q.func_78276_b(LangUtils.localize("gui.robit"), 76, 6, 0x404040);

		if(!displayNameChange)
		{
			CharSequence owner = robit.getOwnerName().length() > 14 ? robit.getOwnerName().subSequence(0, 14) : robit.getOwnerName();
			field_146289_q.func_78276_b(LangUtils.localize("gui.robit.greeting") + " " + robit.func_70005_c_() + "!", 29, 18, 0x00CD00);
			field_146289_q.func_78276_b(LangUtils.localize("gui.energy") + ": " + MekanismUtils.getEnergyDisplay(robit.getEnergy(), robit.MAX_ELECTRICITY), 29, 36-4, 0x00CD00);
			field_146289_q.func_78276_b(LangUtils.localize("gui.robit.following") + ": " + robit.getFollowing(), 29, 45-4, 0x00CD00);
			field_146289_q.func_78276_b(LangUtils.localize("gui.robit.dropPickup") + ": " + robit.getDropPickup(), 29, 54-4, 0x00CD00);
			field_146289_q.func_78276_b(LangUtils.localize("gui.robit.owner") + ": " + owner, 29, 63-4, 0x00CD00);
		}

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 28 && xAxis <= 148 && yAxis >= 75 && yAxis <= 79)
		{
			func_146279_a(MekanismUtils.getEnergyDisplay(robit.getEnergy(), robit.MAX_ELECTRICITY), xAxis, yAxis);
		}
		else if(xAxis >= 152 && xAxis <= 170 && yAxis >= 54 && yAxis <= 72)
		{
			func_146279_a(LangUtils.localize("gui.robit.toggleFollow"), xAxis, yAxis);
		}
		else if(xAxis >= 6 && xAxis <= 24 && yAxis >= 54 && yAxis <= 72)
		{
			func_146279_a(LangUtils.localize("gui.robit.rename"), xAxis, yAxis);
		}
		else if(xAxis >= 6 && xAxis <= 24 && yAxis >= 16 && yAxis <= 34)
		{
			func_146279_a(LangUtils.localize("gui.robit.teleport"), xAxis, yAxis);
		}
		else if(xAxis >= 6 && xAxis <= 24 && yAxis >= 35 && yAxis <= 53)
		{
			func_146279_a(LangUtils.localize("gui.robit.togglePickup"), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		super.func_146976_a(partialTick, mouseX, mouseY);

		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiRobitMain.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 10 && yAxis <= 28)
		{
			func_73729_b(guiWidth + 179, guiHeight + 10, 176 + 25, 0, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 10, 176 + 25, 18, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 30 && yAxis <= 48)
		{
			func_73729_b(guiWidth + 179, guiHeight + 30, 176 + 25, 36, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 30, 176 + 25, 54, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 50 && yAxis <= 68)
		{
			func_73729_b(guiWidth + 179, guiHeight + 50, 176 + 25, 72, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 50, 176 + 25, 90, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 70 && yAxis <= 88)
		{
			func_73729_b(guiWidth + 179, guiHeight + 70, 176 + 25, 108, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 70, 176 + 25, 126, 18, 18);
		}

		if(xAxis >= 179 && xAxis <= 197 && yAxis >= 90 && yAxis <= 108)
		{
			func_73729_b(guiWidth + 179, guiHeight + 90, 176 + 25, 144, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 179, guiHeight + 90, 176 + 25, 162, 18, 18);
		}

		if(xAxis >= 152 && xAxis <= 170 && yAxis >= 54 && yAxis <= 72)
		{
			func_73729_b(guiWidth + 152, guiHeight + 54, 176 + 25, 180, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 152, guiHeight + 54, 176 + 25, 198, 18, 18);
		}

		if(xAxis >= 6 && xAxis <= 24 && yAxis >= 54 && yAxis <= 72)
		{
			func_73729_b(guiWidth + 6, guiHeight + 54, 176 + 25, 216, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 6, guiHeight + 54, 176 + 25, 234, 18, 18);
		}

		if(xAxis >= 6 && xAxis <= 24 && yAxis >= 16 && yAxis <= 34)
		{
			func_73729_b(guiWidth + 6, guiHeight + 16, 176 + 25 + 18, 36, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 6, guiHeight + 16, 176 + 25 + 18, 54, 18, 18);
		}

		if(xAxis >= 6 && xAxis <= 24 && yAxis >= 35 && yAxis <= 53)
		{
			func_73729_b(guiWidth + 6, guiHeight + 35, 176 + 25 + 18, 72, 18, 18);
		}
		else {
			func_73729_b(guiWidth + 6, guiHeight + 35, 176 + 25 + 18, 90, 18, 18);
		}

		int displayInt;

		displayInt = getScaledEnergyLevel(120);
		func_73729_b(guiWidth + 28, guiHeight + 75, 0, 166, displayInt, 4);

		if(displayNameChange)
		{
			func_73729_b(guiWidth + 28, guiHeight + 17, 0, 166 + 4, 120, 54);
			nameChangeField.func_146194_f();
		}
	}

	private int getScaledEnergyLevel(int i)
	{
		return (int)(robit.getEnergy()*i / robit.MAX_ELECTRICITY);
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		nameChangeField.func_146178_a();
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		nameChangeField.func_146192_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 179 && xAxis <= 197 && yAxis >= 10 && yAxis <= 28)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 30 && yAxis <= 48)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 1, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 22, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 50 && yAxis <= 68)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 2, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 23, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 70 && yAxis <= 88)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 3, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 24, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 179 && xAxis <= 197 && yAxis >= 90 && yAxis <= 108)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GUI, 4, robit.func_145782_y(), null));
				field_146297_k.field_71439_g.openGui(Mekanism.instance, 25, field_146297_k.field_71441_e, robit.func_145782_y(), 0, 0);
			}
			else if(xAxis >= 152 && xAxis <= 170 && yAxis >= 54 && yAxis <= 72)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.FOLLOW, robit.func_145782_y(), 0, null));
			}
			else if(xAxis >= 6 && xAxis <= 24 && yAxis >= 54 && yAxis <= 72)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				toggleNameChange();
			}
			else if(xAxis >= 6 && xAxis <= 24 && yAxis >= 16 && yAxis <= 34)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.GO_HOME, robit.func_145782_y(), 0, null));
				field_146297_k.func_147108_a(null);
			}
			else if(xAxis >= 6 && xAxis <= 24 && yAxis >= 35 && yAxis <= 53)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new RobitMessage(RobitPacketType.DROP_PICKUP, robit.func_145782_y(), 0, null));
			}
		}
	}
}
