package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotOverlay;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.inventory.container.ContainerResistiveHeater;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.common.util.UnitDisplayUtils.TemperatureUnit;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiResistiveHeater extends GuiMekanism
{
	public TileEntityResistiveHeater tileEntity;
	
	private GuiTextField energyUsageField;
	
	public GuiResistiveHeater(InventoryPlayer inventory, TileEntityResistiveHeater tentity)
	{
		super(tentity, new ContainerResistiveHeater(inventory, tentity));
		tileEntity = tentity;
		
		guiElements.add(new GuiPowerBar(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiResistiveHeater.png"), 164, 15));
		guiElements.add(new GuiSlot(SlotType.POWER, this, MekanismUtils.getResource(ResourceType.GUI, "GuiResistiveHeater.png"), 14, 34).with(SlotOverlay.POWER));
		guiElements.add(new GuiSecurityTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiResistiveHeater.png")));
		guiElements.add(new GuiRedstoneControl(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiResistiveHeater.png")));
		guiElements.add(new GuiEnergyInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				String multiplier = MekanismUtils.getEnergyDisplay(tileEntity.energyUsage);
				return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.getMaxEnergy()-tileEntity.getEnergy()));
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiResistiveHeater.png")));
		guiElements.add(new GuiHeatInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				TemperatureUnit unit = TemperatureUnit.values()[general.tempUnit.ordinal()];
				String environment = UnitDisplayUtils.getDisplayShort(tileEntity.lastEnvironmentLoss*unit.intervalSize, false, unit);
				return ListUtils.asList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiResistiveHeater.png")));
	}
	
	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		
		String prevEnergyUsage = energyUsageField != null ? energyUsageField.func_146179_b() : "";
		
		energyUsageField = new GuiTextField(0, field_146289_q, guiWidth + 49, guiHeight + 52, 66, 11);
		energyUsageField.func_146203_f(7);
		energyUsageField.func_146185_a(false);
		energyUsageField.func_146180_a(prevEnergyUsage);
	}
	
	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f / 2) - (field_146289_q.func_78256_a(tileEntity.func_70005_c_()) / 2), 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 94) + 2, 0x404040);
		
		renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(tileEntity.temperature, TemperatureUnit.AMBIENT), 50, 25, 0x00CD00, 76);
		renderScaledText(LangUtils.localize("gui.usage") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.energyUsage) + "/t", 50, 41, 0x00CD00, 76);

		super.func_146979_b(mouseX, mouseY);
	}
	
	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiResistiveHeater.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		if(xAxis >= 116 && xAxis <= 126 && yAxis >= 51 && yAxis <= 61)
		{
			func_73729_b(guiWidth + 116, guiHeight + 51, field_146999_f, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 116, guiHeight + 51, field_146999_f, 11, 11, 11);
		}

		super.func_146976_a(partialTick, mouseX, mouseY);
		
		energyUsageField.func_146194_f();
	}
	
	private void setEnergyUsage()
	{
		if(!energyUsageField.func_146179_b().isEmpty())
		{
			int toUse = Integer.parseInt(energyUsageField.func_146179_b());

			ArrayList data = new ArrayList();
			data.add(toUse);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));

			energyUsageField.func_146180_a("");
		}
	}
	
	@Override
	public void func_73876_c()
	{
		super.func_73876_c();
		
		energyUsageField.func_146178_a();
	}
	
	@Override
	public void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		energyUsageField.func_146192_a(mouseX, mouseY, button);
		
		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
			
			if(xAxis >= 116 && xAxis <= 126 && yAxis >= 51 && yAxis <= 61)
			{
				setEnergyUsage();
	            SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
		}
	}
	
	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!energyUsageField.func_146206_l() || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(energyUsageField.func_146206_l() && i == Keyboard.KEY_RETURN)
		{
			setEnergyUsage();
			return;
		}

		if(Character.isDigit(c) || isTextboxKey(c, i))
		{
			energyUsageField.func_146201_a(c, i);
		}
	}
}
