package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.ContainerQuantumEntangloporter;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiQuantumEntangloporter extends GuiMekanism
{
	public ResourceLocation resource;
	
	public TileEntityQuantumEntangloporter tileEntity;
	
	public EntityPlayer entityPlayer;
	
	public GuiButton publicButton;
	public GuiButton privateButton;
	
	public GuiButton setButton;
	public GuiButton deleteButton;
	
	public GuiScrollList scrollList;
	
	public GuiTextField frequencyField;
	
	public boolean privateMode;

	public GuiQuantumEntangloporter(InventoryPlayer inventory, TileEntityQuantumEntangloporter tentity)
	{
		super(tentity, new ContainerQuantumEntangloporter(inventory, tentity));
		tileEntity = tentity;
		resource = MekanismUtils.getResource(ResourceType.GUI, "GuiTeleporter.png");

		guiElements.add(scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4));
		guiElements.add(new GuiSideConfigurationTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiTeleporter.png")));
		guiElements.add(new GuiTransporterConfigTab(this, 34, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiTeleporter.png")));
		guiElements.add(new GuiUpgradeTab(this, tileEntity, resource));
		
		if(tileEntity.frequency != null)
		{
			privateMode = !tileEntity.frequency.publicFreq;
		}
		
		field_147000_g+=64;
	}
	
	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		
		publicButton = new GuiButton(0, guiWidth + 27, guiHeight + 14, 60, 20, LangUtils.localize("gui.public"));
		privateButton = new GuiButton(1, guiWidth + 89, guiHeight + 14, 60, 20, LangUtils.localize("gui.private"));
		
		setButton = new GuiButton(2, guiWidth + 27, guiHeight + 116, 60, 20, LangUtils.localize("gui.set"));
		deleteButton = new GuiButton(3, guiWidth + 89, guiHeight + 116, 60, 20, LangUtils.localize("gui.delete"));
		
		frequencyField = new GuiTextField(4, field_146289_q, guiWidth + 50, guiHeight + 104, 86, 11);
		frequencyField.func_146203_f(FrequencyManager.MAX_FREQ_LENGTH);
		
		frequencyField.func_146185_a(false);
		
		updateButtons();

		field_146292_n.add(publicButton);
		field_146292_n.add(privateButton);
		field_146292_n.add(setButton);
		field_146292_n.add(deleteButton);
	}
	
	public void setFrequency(String freq)
	{
		if(freq.isEmpty())
		{
			return;
		}
		
		ArrayList data = new ArrayList();
		data.add(0);
		data.add(freq);
		data.add(!privateMode);
		
		Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
	}
	
	public String getSecurity(Frequency freq)
	{
		return !freq.publicFreq ? EnumColor.DARK_RED + LangUtils.localize("gui.private") : LangUtils.localize("gui.public");
	}
	
	public void updateButtons()
	{
		if(tileEntity.getSecurity().getClientOwner() == null)
		{
			return;
		}
		
		List<String> text = new ArrayList<String>();
		
		if(privateMode)
		{
			for(Frequency freq : tileEntity.privateCache)
			{
				text.add(freq.name);
			}
		}
		else {
			for(Frequency freq : tileEntity.publicCache)
			{
				text.add(freq.name + " (" + freq.clientOwner + ")");
			}
		}
		
		scrollList.setText(text);
		
		if(privateMode)
		{
			publicButton.field_146124_l = true;
			privateButton.field_146124_l = false;
		}
		else {
			publicButton.field_146124_l = false;
			privateButton.field_146124_l = true;
		}
		
		if(scrollList.hasSelection())
		{
			Frequency freq = privateMode ? tileEntity.privateCache.get(scrollList.selected) : tileEntity.publicCache.get(scrollList.selected);
			
			if(tileEntity.getFrequency(null) == null || !tileEntity.getFrequency(null).equals(freq))
			{
				setButton.field_146124_l = true;
			}
			else {
				setButton.field_146124_l = false;
			}
			
			if(tileEntity.getSecurity().getOwnerUUID().equals(freq.ownerUUID))
			{
				deleteButton.field_146124_l = true;
			}
			else {
				deleteButton.field_146124_l = false;
			}
		}
		else {
			setButton.field_146124_l = false;
			deleteButton.field_146124_l = false;
		}
	}
	
	@Override
	public void func_73876_c()
	{
		super.func_73876_c();
		
		updateButtons();
		
		frequencyField.func_146178_a();
	}
	
	@Override
	public void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);
		
		updateButtons();

		frequencyField.func_146192_a(mouseX, mouseY, button);
		
		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
			
			if(xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114)
			{
				setFrequency(frequencyField.func_146179_b());
				frequencyField.func_146180_a("");
	            SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
		}
	}
	
	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!frequencyField.func_146206_l() || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(i == Keyboard.KEY_RETURN)
		{
			if(frequencyField.func_146206_l())
			{
				setFrequency(frequencyField.func_146179_b());
				frequencyField.func_146180_a("");
			}
		}

		if(Character.isDigit(c) || Character.isLetter(c) || isTextboxKey(c, i) || FrequencyManager.SPECIAL_CHARS.contains(c))
		{
			frequencyField.func_146201_a(c, i);
		}
		
		updateButtons();
	}
	
	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			privateMode = false;
		}
		else if(guibutton.field_146127_k == 1)
		{
			privateMode = true;
		}
		else if(guibutton.field_146127_k == 2)
		{
			int selection = scrollList.getSelection();
			
			if(selection != -1)
			{
				Frequency freq = privateMode ? tileEntity.privateCache.get(selection) : tileEntity.publicCache.get(selection);
				setFrequency(freq.name);
			}
		}
		else if(guibutton.field_146127_k == 3)
		{
			int selection = scrollList.getSelection();
			
			if(selection != -1)
			{
				Frequency freq = privateMode ? tileEntity.privateCache.get(selection) : tileEntity.publicCache.get(selection);
				
				ArrayList data = new ArrayList();
				data.add(1);
				data.add(freq.name);
				data.add(freq.publicFreq);
				
				Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				
				scrollList.selected = -1;
			}
		}
		
		updateButtons();
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX-(field_146294_l-field_146999_f)/2);
		int yAxis = (mouseY-(field_146295_m-field_147000_g)/2);

		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f/2)-(field_146289_q.func_78256_a(tileEntity.func_70005_c_())/2), 4, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.owner") + ": " + (tileEntity.getSecurity().getClientOwner() != null ? tileEntity.getSecurity().getClientOwner() : LangUtils.localize("gui.none")), 8, (field_147000_g-96)+4, 0x404040);

		field_146289_q.func_78276_b(LangUtils.localize("gui.freq") + ":", 32, 81, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.security") + ":", 32, 91, 0x404040);
		
		field_146289_q.func_78276_b(" " + (tileEntity.getFrequency(null) != null ? tileEntity.getFrequency(null).name : EnumColor.DARK_RED + LangUtils.localize("gui.none")), 32 + field_146289_q.func_78256_a(LangUtils.localize("gui.freq") + ":"), 81, 0x797979);
		field_146289_q.func_78276_b(" " + (tileEntity.getFrequency(null) != null ? getSecurity(tileEntity.getFrequency(null)) : EnumColor.DARK_RED + LangUtils.localize("gui.none")), 32 + field_146289_q.func_78256_a(LangUtils.localize("gui.security") + ":"), 91, 0x797979);
		
		String str = LangUtils.localize("gui.set") + ":";
		renderScaledText(str, 27, 104, 0x404040, 20);

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(resource);
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l-field_146999_f)/2;
		int guiHeight = (field_146295_m-field_147000_g)/2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		if(xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114)
		{
			func_73729_b(guiWidth + 137, guiHeight + 103, field_146999_f, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 137, guiHeight + 103, field_146999_f, 11, 11, 11);
		}

		super.func_146976_a(partialTick, mouseX, mouseY);
		
		frequencyField.func_146194_f();
	}
}
