package mekanism.client.gui;

import java.io.IOException;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter.EditFilterMessage;
import mekanism.common.network.PacketNewFilter.NewFilterMessage;
import mekanism.common.network.PacketSimpleGui.SimpleGuiMessage;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.TileEntityOredictionificator.OredictionificatorFilter;
import mekanism.common.util.ItemRegistryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiOredictionificatorFilter extends GuiMekanism
{
	public TileEntityOredictionificator tileEntity;
	
	public OredictionificatorFilter origFilter;

	public OredictionificatorFilter filter = new OredictionificatorFilter();
	
	public GuiTextField filterText;
	
	public boolean isNew;
	
	public ItemStack renderStack = ItemStack.field_190927_a;
	
	public GuiOredictionificatorFilter(EntityPlayer player, TileEntityOredictionificator tentity, int index)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;
		
		origFilter = tileEntity.filters.get(index);
		filter = ((OredictionificatorFilter)tentity.filters.get(index)).clone();
		
		updateRenderStack();
	}
	
	public GuiOredictionificatorFilter(EntityPlayer player, TileEntityOredictionificator tentity)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;
		
		isNew = true;
	}
	
	public void setFilter()
	{
		String newFilter = filterText.func_146179_b();
		boolean has = false;
		
		for(String s : TileEntityOredictionificator.possibleFilters)
		{
			if(newFilter.startsWith(s))
			{
				has = true;
				break;
			}
		}
		
		if(has)
		{
			filter.filter = newFilter;
			filter.index = 0;
			filterText.func_146180_a("");
			
			updateRenderStack();
		}
		
		updateButtons();
	}
	
	public void updateButtons()
	{
		if(filter.filter != null && !filter.filter.isEmpty())
		{
			((GuiButton)field_146292_n.get(0)).field_146124_l = true;
		}
		else {
			((GuiButton)field_146292_n.get(0)).field_146124_l = false;
		}
		
		if(!isNew)
		{
			((GuiButton)field_146292_n.get(1)).field_146124_l = true;
		}
		else {
			((GuiButton)field_146292_n.get(1)).field_146124_l = false;
		}
	}
	
	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		field_146292_n.add(new GuiButton(0, guiWidth + 31, guiHeight + 62, 54, 20, LangUtils.localize("gui.save")));
		field_146292_n.add(new GuiButton(1, guiWidth + 89, guiHeight + 62, 54, 20, LangUtils.localize("gui.delete")));

		if(isNew)
		{
			field_146292_n.get(1).field_146124_l = false;
		}

		filterText = new GuiTextField(2, field_146289_q, guiWidth + 33, guiHeight + 48, 96, 12);
		filterText.func_146203_f(TileEntityOredictionificator.MAX_LENGTH);
		filterText.func_146195_b(true);
		
		updateButtons();
	}
	
	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		String text = (isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.filter");
		field_146289_q.func_78276_b(text, (field_146999_f/2)-(field_146289_q.func_78256_a(text)/2), 6, 0x404040);
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.index") + ": " + filter.index, 79, 23, 0x404040);
		
		if(filter.filter != null)
		{
			renderScaledText(filter.filter, 32, 38, 0x404040, 111);
		}

		if(!renderStack.func_190926_b())
		{
			try {
				GlStateManager.func_179094_E();
				RenderHelper.func_74520_c();
				field_146296_j.func_180450_b(renderStack, 45, 19);
				RenderHelper.func_74518_a();
				GlStateManager.func_179121_F();
			} catch(Exception e) {}
		}
		
		if(xAxis >= 31 && xAxis <= 43 && yAxis >= 21 && yAxis <= 33)
		{
			func_146279_a(LangUtils.localize("gui.lastItem"), xAxis, yAxis);
		}
		
		if(xAxis >= 63 && xAxis <= 75 && yAxis >= 21 && yAxis <= 33)
		{
			func_146279_a(LangUtils.localize("gui.nextItem"), xAxis, yAxis);
		}
		
		if(xAxis >= 33 && xAxis <= 129 && yAxis >= 48 && yAxis <= 60)
		{
			func_146279_a(LangUtils.localize("gui.oreDictCompat"), xAxis, yAxis);
		}
		
		if(xAxis >= 45 && xAxis <= 61 && yAxis >= 19 && yAxis <= 35)
		{
			if(!renderStack.func_190926_b())
			{
				String name = ItemRegistryUtils.getMod(renderStack);
				String extra = name.equals("null") ? "" : " (" + name + ")";
				
				func_146279_a(renderStack.func_82833_r() + extra, xAxis, yAxis);
			}
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		super.func_146976_a(partialTick, mouseX, mouseY);

		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiOredictionificatorFilter.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
		{
			func_73729_b(guiWidth + 5, guiHeight + 5, 176 + 36, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 5, guiHeight + 5, 176 + 36, 11, 11, 11);
		}

		if(xAxis >= 31 && xAxis <= 43 && yAxis >= 21 && yAxis <= 33)
		{
			func_73729_b(guiWidth + 31, guiHeight + 21, 176 + 24, 0, 12, 12);
		}
		else {
			func_73729_b(guiWidth + 31, guiHeight + 21, 176 + 24, 12, 12, 12);
		}
		
		if(xAxis >= 63 && xAxis <= 75 && yAxis >= 21 && yAxis <= 33)
		{
			func_73729_b(guiWidth + 63, guiHeight + 21, 176 + 12, 0, 12, 12);
		}
		else {
			func_73729_b(guiWidth + 63, guiHeight + 21, 176 + 12, 12, 12, 12);
		}
		
		if(xAxis >= 130 && xAxis <= 142 && yAxis >= 48 && yAxis <= 60)
		{
			func_73729_b(guiWidth + 130, guiHeight + 48, 176, 0, 12, 12);
		}
		else {
			func_73729_b(guiWidth + 130, guiHeight + 48, 176, 12, 12, 12);
		}

		filterText.func_146194_f();
	}
	
	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!filterText.func_146206_l() || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(filterText.func_146206_l() && i == Keyboard.KEY_RETURN)
		{
			setFilter();
			return;
		}

		if(Character.isLetter(c) || Character.isDigit(c) || isTextboxKey(c, i))
		{
			filterText.func_146201_a(c, i);
		}
	}
	
	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);
		
		if(guibutton.field_146127_k == 0)
		{
			if(!filterText.func_146179_b().isEmpty())
			{
				setFilter();
			}

			if(filter.filter != null && !filter.filter.isEmpty())
			{
				if(isNew)
				{
					Mekanism.packetHandler.sendToServer(new NewFilterMessage(Coord4D.get(tileEntity), filter));
				}
				else {
					Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), false, origFilter, filter));
				}

				Mekanism.packetHandler.sendToServer(new SimpleGuiMessage(Coord4D.get(tileEntity), 0, 52));
			}
		}
		else if(guibutton.field_146127_k == 1)
		{
			Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), true, origFilter, null));
			Mekanism.packetHandler.sendToServer(new SimpleGuiMessage(Coord4D.get(tileEntity), 0, 52));
		}
	}
	
	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		filterText.func_146178_a();
	}
	
	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		filterText.func_146192_a(mouseX, mouseY, button);
		
		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new SimpleGuiMessage(Coord4D.get(tileEntity), 0, 52));
			}
			
			if(xAxis >= 130 && xAxis <= 142 && yAxis >= 48 && yAxis <= 60)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				setFilter();
			}

			if(xAxis >= 31 && xAxis <= 43 && yAxis >= 21 && yAxis <= 33)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				
				if(filter.filter != null)
				{
					List<ItemStack> ores = OreDictionary.getOres(filter.filter);
					
					if(filter.index > 0)
					{
						filter.index--;
					}
					else {
						filter.index = ores.size()-1;
					}
					
					updateRenderStack();
				}
			}
			
			if(xAxis >= 63 && xAxis <= 75 && yAxis >= 21 && yAxis <= 33)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				
				if(filter.filter != null)
				{
					List<ItemStack> ores = OreDictionary.getOres(filter.filter);
					
					if(filter.index < ores.size()-1)
					{
						filter.index++;
					}
					else {
						filter.index = 0;
					}
					
					updateRenderStack();
				}
			}
		}
	}
	
	public void updateRenderStack()
	{
		if(filter.filter == null || filter.filter.isEmpty())
		{
			renderStack = ItemStack.field_190927_a;
			return;
		}
		
		List<ItemStack> stacks = OreDictionary.getOres(filter.filter);
		
		if(stacks.isEmpty())
		{
			renderStack = ItemStack.field_190927_a;
			return;
		}
		
		if(stacks.size()-1 >= filter.index)
		{
			renderStack = stacks.get(filter.index).func_77946_l();
		}
		else {
			renderStack = ItemStack.field_190927_a;
			return;
		}
	}
}
