package mekanism.client.gui;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiProgress.IProgressInfoHandler;
import mekanism.client.gui.element.GuiProgress.ProgressBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerOredictionificator;
import mekanism.common.network.PacketOredictionificatorGui.OredictionificatorGuiMessage;
import mekanism.common.network.PacketOredictionificatorGui.OredictionificatorGuiPacket;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.TileEntityOredictionificator.OredictionificatorFilter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiOredictionificator extends GuiMekanism
{
	public TileEntityOredictionificator tileEntity;
	
	public Map<OredictionificatorFilter, ItemStack> renderStacks = new HashMap<OredictionificatorFilter, ItemStack>();
	
	public boolean isDragging = false;

	public int dragOffset = 0;
	
	public float scroll;
	
	public GuiOredictionificator(InventoryPlayer inventory, TileEntityOredictionificator tentity)
	{
		super(tentity, new ContainerOredictionificator(inventory, tentity));
		tileEntity = tentity;
		
		guiElements.add(new GuiRedstoneControl(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiOredictionificator.png")));
		guiElements.add(new GuiSecurityTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiOredictionificator.png")));
		guiElements.add(new GuiProgress(new IProgressInfoHandler()
		{
			@Override
			public double getProgress()
			{
				return tileEntity.didProcess ? 1 : 0;
			}
		}, ProgressBar.LARGE_RIGHT, this, MekanismUtils.getResource(ResourceType.GUI, "GuiOredictionificator.png"), 62, 118));
		guiElements.add(new GuiSlot(SlotType.NORMAL, this, MekanismUtils.getResource(ResourceType.GUI, "GuiOredictionificator.png"), 25, 114));
		guiElements.add(new GuiSlot(SlotType.NORMAL, this, MekanismUtils.getResource(ResourceType.GUI, "GuiOredictionificator.png"), 133, 114));
		
		field_147000_g+=64;
	}
	
	public int getScroll()
	{
		return Math.max(Math.min((int)(scroll*73), 73), 0);
	}
	
	public int getFilterIndex()
	{
		if(tileEntity.filters.size() <= 3)
		{
			return 0;
		}

		return (int)((tileEntity.filters.size()*scroll) - ((3F/(float)tileEntity.filters.size()))*scroll);
	}
	
	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		field_146292_n.add(new GuiButton(0, guiWidth + 10, guiHeight + 86, 142, 20, LangUtils.localize("gui.newFilter")));
	}
	
	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			Mekanism.packetHandler.sendToServer(new OredictionificatorGuiMessage(OredictionificatorGuiPacket.SERVER, Coord4D.get(tileEntity), 1, 0, 0));
		}
	}
	
	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f/2)-(field_146289_q.func_78256_a(tileEntity.func_70005_c_())/2), 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);

		for(int i = 0; i < 3; i++)
		{
			if(tileEntity.filters.get(getFilterIndex()+i) != null)
			{
				OredictionificatorFilter filter = tileEntity.filters.get(getFilterIndex()+i);
				int yStart = i*22 + 18;
				
				if(!renderStacks.containsKey(filter))
				{
					updateRenderStacks();
				}
				
				ItemStack stack = renderStacks.get(filter);
				
				if(!stack.func_190926_b())
				{
					GlStateManager.func_179094_E();
					RenderHelper.func_74520_c();
					field_146296_j.func_180450_b(stack, 13, yStart + 3);
					RenderHelper.func_74518_a();
					GlStateManager.func_179121_F();
				}

				field_146289_q.func_78276_b(LangUtils.localize("gui.filter"), 32, yStart + 2, 0x404040);
				renderScaledText(filter.filter, 32, yStart + 2 + 9, 0x404040, 117);
			}
		}
		
		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiOredictionificator.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = mouseX - guiWidth;
		int yAxis = mouseY - guiHeight;
		
		func_73729_b(guiWidth + 154, guiHeight + 18 + getScroll(), 232, 0, 12, 15);
		
		super.func_146976_a(partialTick, mouseX, mouseY);
		
		for(int i = 0; i < 3; i++)
		{
			if(tileEntity.filters.get(getFilterIndex()+i) != null)
			{
				int yStart = i*22 + 18;
				boolean mouseOver = xAxis > 10 && xAxis <= 152 && yAxis > yStart && yAxis <= yStart+22;
				
				if(mouseOver)
				{
					MekanismRenderer.color(EnumColor.GREY, 3.0F);
				}
				
				func_73729_b(guiWidth + 10, guiHeight + yStart, 0, 230, 142, 22);
				
				MekanismRenderer.resetColor();
			}
		}
	}
	
	@Override
	public void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 154 && xAxis <= 166 && yAxis >= getScroll()+18 && yAxis <= getScroll()+18+15)
			{
				if(tileEntity.filters.size()>3)
				{
					dragOffset = yAxis - (getScroll()+18);
					isDragging = true;
				}
				else {
					scroll = 0;
				}
			}

			for(int i = 0; i < 3; i++)
			{
				if(tileEntity.filters.get(getFilterIndex()+i) != null)
				{
					int yStart = i*22 + 18;

					if(xAxis > 10 && xAxis <= 152 && yAxis > yStart && yAxis <= yStart+22)
					{
						OredictionificatorFilter filter = tileEntity.filters.get(getFilterIndex()+i);

                        SoundHandler.playSound(SoundEvents.field_187909_gi);
						Mekanism.packetHandler.sendToServer(new OredictionificatorGuiMessage(OredictionificatorGuiPacket.SERVER_INDEX, Coord4D.get(tileEntity), 1, getFilterIndex()+i, 0));
					}
				}
			}
		}
	}
	
	@Override
	protected void func_146273_a(int mouseX, int mouseY, int button, long ticks)
	{
		super.func_146273_a(mouseX, mouseY, button, ticks);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(isDragging)
		{
			scroll = Math.min(Math.max((float)(yAxis-18-dragOffset)/73F, 0), 1);
		}
	}
	
	@Override
	protected void func_146286_b(int x, int y, int type)
	{
		super.func_146286_b(x, y, type);

		if(type == 0 && isDragging)
		{
			dragOffset = 0;
			isDragging = false;
		}
	}
	
	public void updateRenderStacks()
	{
		renderStacks.clear();
		
		for(OredictionificatorFilter filter : tileEntity.filters)
		{
			if(filter.filter == null || filter.filter.isEmpty())
			{
				renderStacks.put(filter, ItemStack.field_190927_a);
				continue;
			}
			
			List<ItemStack> stacks = OreDictionary.getOres(filter.filter);
			
			if(stacks.isEmpty())
			{
				renderStacks.put(filter, ItemStack.field_190927_a);
				continue;
			}
			
			if(stacks.size()-1 >= filter.index)
			{
				renderStacks.put(filter, stacks.get(filter.index).func_77946_l());
			}
			else {
				renderStacks.put(filter, ItemStack.field_190927_a);
			}
		}
	}
}
