package mekanism.client.gui;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiMekanism extends GuiContainer implements IGuiWrapper
{
	public Set<GuiElement> guiElements = new HashSet<GuiElement>();

	private TileEntityContainerBlock tileEntity;

	//Try not to use
	public GuiMekanism(Container container)
	{
		super(container);
	}

	public GuiMekanism(TileEntityContainerBlock tile, Container container)
	{
		super(container);
		tileEntity = tile;
	}
	
	public float getNeededScale(String text, int maxX)
	{
		int length = field_146289_q.func_78256_a(text);
		
		if(length <= maxX)
		{
			return 1;
		}
		else {
			return (float)maxX/length;
		}
	}
	
	/** returns scale */
	public void renderScaledText(String text, int x, int y, int color, int maxX)
	{
		int length = field_146289_q.func_78256_a(text);
		
		if(length <= maxX)
		{
			field_146289_q.func_78276_b(text, x, y, color);
		}
		else {
			float scale = (float)maxX/length;
			float reverse = 1/scale;
			float yAdd = 4-(scale*8)/2F;
			
			GlStateManager.func_179094_E();
			
			GlStateManager.func_179152_a(scale, scale, scale);
			field_146289_q.func_78276_b(text, (int)(x*reverse), (int)((y*reverse)+yAdd), color);
			
			GlStateManager.func_179121_F();
		}
	}
	
	public static boolean isTextboxKey(char c, int i)
	{
		if(i == Keyboard.KEY_BACK || i == Keyboard.KEY_DELETE || i == Keyboard.KEY_LEFT || i == Keyboard.KEY_RIGHT ||
				i == Keyboard.KEY_END || i == Keyboard.KEY_HOME || i == Keyboard.KEY_BACK || func_175278_g(i) || 
				func_175280_f(i) || func_175279_e(i) || func_175277_d(i))
		{
			return true;
		}
		
		return false;
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		super.func_146979_b(mouseX, mouseY);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		for(GuiElement element : guiElements)
		{
			element.renderForeground(xAxis, yAxis);
		}

		if(tileEntity instanceof ISideConfiguration)
		{
			Slot hovering = null;

			for(int i = 0; i < field_147002_h.field_75151_b.size(); i++)
			{
				Slot slot = (Slot)field_147002_h.field_75151_b.get(i);

				if(isMouseOverSlot(slot, mouseX, mouseY))
				{
					hovering = slot;
					break;
				}
			}

			ItemStack stack = field_146297_k.field_71439_g.field_71071_by.func_70445_o();

			if(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && hovering != null)
			{
				SideData data = getFromSlot(hovering);

				if(data != null)
				{
					func_146279_a(data.color + data.localize() + " (" + data.color.getColoredName() + ")", xAxis, yAxis);
				}
			}
		}
	}
	
	public TileEntityContainerBlock getTileEntity()
	{
		return tileEntity;
	}

	private SideData getFromSlot(Slot slot)
	{
		if(slot.field_75222_d < tileEntity.func_70302_i_())
		{
			ISideConfiguration config = (ISideConfiguration)tileEntity;

			for(SideData data : config.getConfig().getOutputs(TransmissionType.ITEM))
			{
				for(int id : data.availableSlots)
				{
					if(id == slot.getSlotIndex())
					{
						return data;
					}
				}
			}
		}

		return null;
	}

	protected boolean isMouseOverSlot(Slot slot, int mouseX, int mouseY)
	{
		return func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		int xAxis = mouseX - guiWidth;
		int yAxis = mouseY - guiHeight;

		for(GuiElement element : guiElements)
		{
			element.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
		}
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		for(GuiElement element : guiElements)
		{
			element.preMouseClicked(xAxis, yAxis, button);
		}

		super.func_73864_a(mouseX, mouseY, button);

		for(GuiElement element : guiElements)
		{
			element.mouseClicked(xAxis, yAxis, button);
		}
	}

	@Override
	public void drawTexturedRect(int x, int y, int u, int v, int w, int h)
	{
		func_73729_b(x, y, u, v, w, h);
	}

	@Override
	public void drawTexturedRectFromIcon(int x, int y, TextureAtlasSprite icon, int w, int h)
	{
		func_175175_a(x, y, icon, w, h);
	}

	@Override
	public void displayTooltip(String s, int x, int y)
	{
		func_146279_a(s, x, y);
	}

	@Override
	public void displayTooltips(List<String> list, int xAxis, int yAxis)
	{
		func_146283_a(list, xAxis, yAxis);
	}

	@Override
	public FontRenderer getFont()
	{
		return field_146289_q;
	}
	
	@Override
	protected void func_146273_a(int mouseX, int mouseY, int button, long ticks)
	{
		super.func_146273_a(mouseX, mouseY, button, ticks);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		for(GuiElement element : guiElements)
		{
			element.mouseClickMove(xAxis, yAxis, button, ticks);
		}
	}

	@Override
	protected void func_146286_b(int mouseX, int mouseY, int type)
	{
		super.func_146286_b(mouseX, mouseY, type);
		
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		for(GuiElement element : guiElements)
		{
			element.mouseReleased(xAxis, yAxis, type);
		}
	}
	
	public void handleMouse(Slot slot, int slotIndex, int button, ClickType modifier)
	{
		func_184098_a(slot, slotIndex, button, modifier);
	}
	
	@Override
	public void func_146274_d() throws java.io.IOException
	{
		super.func_146274_d();
		
		int xAxis = Mouse.getEventX() * field_146294_l / field_146297_k.field_71443_c - getXPos();
		int yAxis = field_146295_m - Mouse.getEventY() * field_146295_m / field_146297_k.field_71440_d - 1 - getYPos();
		int delta = Mouse.getEventDWheel();
		
		if(delta != 0) 
		{
			mouseWheel(xAxis, yAxis, delta);
		}
	}
	
	public void mouseWheel(int xAxis, int yAxis, int delta)
	{
		for(GuiElement element : guiElements)
		{
			element.mouseWheel(xAxis, yAxis, delta);
		}
	}
	
	public int getXPos()
	{
		return (field_146294_l - field_146999_f) / 2;
	}
	
	public int getYPos()
	{
		return (field_146295_m - field_147000_g) / 2;
	}

	protected FontRenderer getFontRenderer()
	{
		return field_146289_q;
	}
}
