package mekanism.client.gui;

import java.io.IOException;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketDigitalMinerGui.DigitalMinerGuiMessage;
import mekanism.common.network.PacketDigitalMinerGui.MinerGuiPacket;
import mekanism.common.network.PacketEditFilter.EditFilterMessage;
import mekanism.common.network.PacketNewFilter.NewFilterMessage;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiMItemStackFilter extends GuiMekanism
{
	public TileEntityDigitalMiner tileEntity;

	public boolean isNew = false;

	public MItemStackFilter origFilter;

	public MItemStackFilter filter = new MItemStackFilter();

	public String status = EnumColor.DARK_GREEN + LangUtils.localize("gui.allOK");

	public int ticker;

	public GuiMItemStackFilter(EntityPlayer player, TileEntityDigitalMiner tentity, int index)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;

		origFilter = (MItemStackFilter)tileEntity.filters.get(index);
		filter = ((MItemStackFilter)tileEntity.filters.get(index)).clone();
	}

	public GuiMItemStackFilter(EntityPlayer player, TileEntityDigitalMiner tentity)
	{
		super(tentity, new ContainerFilter(player.field_71071_by, tentity));
		tileEntity = tentity;

		isNew = true;
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		field_146292_n.add(new GuiButton(0, guiWidth + 27, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
		field_146292_n.add(new GuiButton(1, guiWidth + 89, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));

		if(isNew)
		{
			((GuiButton)field_146292_n.get(1)).field_146124_l = false;
		}
	}

	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			if(!filter.itemType.func_190926_b())
			{
				if(isNew)
				{
					Mekanism.packetHandler.sendToServer(new NewFilterMessage(Coord4D.get(tileEntity), filter));
				}
				else {
					Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), false, origFilter, filter));
				}

				Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER, Coord4D.get(tileEntity), 0, 0, 0));
			}
			else {
				status = EnumColor.DARK_RED + LangUtils.localize("gui.itemFilter.noItem");
				ticker = 20;
			}
		}
		else if(guibutton.field_146127_k == 1)
		{
			Mekanism.packetHandler.sendToServer(new EditFilterMessage(Coord4D.get(tileEntity), true, origFilter, null));
			Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER, Coord4D.get(tileEntity), 0, 0, 0));
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b((isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.itemFilter"), 43, 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + status, 35, 20, 0x00CD00);
		field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.details") + ":", 35, 32, 0x00CD00);

		if(!filter.itemType.func_190926_b())
		{
			renderScaledText(filter.itemType.func_82833_r(), 35, 41, 0x00CD00, 107);
			GlStateManager.func_179094_E();
			RenderHelper.func_74520_c();
			field_146296_j.func_180450_b(filter.itemType, 12, 19);
			RenderHelper.func_74518_a();
			GlStateManager.func_179121_F();
		}
		
		if(!filter.replaceStack.func_190926_b())
		{
			GlStateManager.func_179094_E();
			RenderHelper.func_74520_c();
			field_146296_j.func_180450_b(filter.replaceStack, 149, 19);
			RenderHelper.func_74518_a();
			GlStateManager.func_179121_F();
		}
		
		if(xAxis >= 148 && xAxis <= 162 && yAxis >= 45 && yAxis <= 59)
		{
			func_146279_a(LangUtils.localize("gui.digitalMiner.requireReplace") + ": " + LangUtils.transYesNo(filter.requireStack), xAxis, yAxis);
		}
		
		if(xAxis >= 15 && xAxis <= 29 && yAxis >= 45 && yAxis <= 59)
		{
			func_146279_a(LangUtils.localize("gui.digitalMiner.fuzzyMode") + ": " + LangUtils.transYesNo(filter.fuzzy), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		if(ticker > 0)
		{
			ticker--;
		}
		else {
			status = EnumColor.DARK_GREEN + LangUtils.localize("gui.allOK");
		}
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiMItemStackFilter.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
		{
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
		}
		
		if(xAxis >= 148 && xAxis <= 162 && yAxis >= 45 && yAxis <= 59)
		{
			func_73729_b(guiWidth + 148, guiHeight + 45, 176 + 23, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 148, guiHeight + 45, 176 + 23, 14, 14, 14);
		}
		
		if(xAxis >= 15 && xAxis <= 29 && yAxis >= 45 && yAxis <= 59)
		{
			func_73729_b(guiWidth + 15, guiHeight + 45, 176 + 37, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 15, guiHeight + 45, 176 + 37, 14, 14, 14);
		}

		if(xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179140_f();
			GlStateManager.func_179097_i();
			GlStateManager.func_179135_a(true, true, true, false);

			int x = guiWidth + 12;
			int y = guiHeight + 19;
			func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);

			GlStateManager.func_179135_a(true, true, true, true);
			GlStateManager.func_179145_e();
			GlStateManager.func_179126_j();
			GlStateManager.func_179121_F();
		}
		
		if(xAxis >= 149 && xAxis <= 165 && yAxis >= 19 && yAxis <= 35)
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179140_f();
			GlStateManager.func_179097_i();
			GlStateManager.func_179135_a(true, true, true, false);

			int x = guiWidth + 149;
			int y = guiHeight + 19;
			func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);

			GlStateManager.func_179135_a(true, true, true, true);
			GlStateManager.func_179145_e();
			GlStateManager.func_179126_j();
			GlStateManager.func_179121_F();
		}
		
		super.func_146976_a(partialTick, mouseX, mouseY);
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
			{
                SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER, Coord4D.get(tileEntity), isNew ? 5 : 0, 0, 0));
			}
			
			if(xAxis >= 148 && xAxis <= 162 && yAxis >= 45 && yAxis <= 59)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				filter.requireStack = !filter.requireStack;
			}
			
			if(xAxis >= 15 && xAxis <= 29 && yAxis >= 45 && yAxis <= 59)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				filter.fuzzy = !filter.fuzzy;
			}

			if(xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35)
			{
				ItemStack stack = field_146297_k.field_71439_g.field_71071_by.func_70445_o();

				if(!stack.func_190926_b() && !Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					if(stack.func_77973_b() instanceof ItemBlock)
					{
						if(Block.func_149634_a(stack.func_77973_b()) != Blocks.field_150357_h)
						{
							filter.itemType = stack.func_77946_l();
							filter.itemType.func_190920_e(1);
						}
					}
				}
				else if(stack.func_190926_b() && Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					filter.itemType = ItemStack.field_190927_a;
				}

                SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
			
			if(xAxis >= 149 && xAxis <= 165 && yAxis >= 19 && yAxis <= 35)
			{
				boolean doNull = false;
				ItemStack stack = field_146297_k.field_71439_g.field_71071_by.func_70445_o();
				ItemStack toUse = ItemStack.field_190927_a;

				if(!stack.func_190926_b() && !Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					if(stack.func_77973_b() instanceof ItemBlock)
					{
						if(Block.func_149634_a(stack.func_77973_b()) != Blocks.field_150357_h)
						{
							toUse = stack.func_77946_l();
							toUse.func_190920_e(1);
						}
					}
				}
				else if(stack.func_190926_b() && Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					doNull = true;
				}

				if(!toUse.func_190926_b() || doNull)
				{
					filter.replaceStack = toUse;
				}

                SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
		}
	}
}
