package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;

import mekanism.api.Coord4D;
import mekanism.client.gui.element.GuiAmplifierTab;
import mekanism.client.gui.element.GuiGauge.Type;
import mekanism.client.gui.element.GuiNumberGauge;
import mekanism.client.gui.element.GuiNumberGauge.INumberInfoHandler;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerLaserAmplifier;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiLaserAmplifier extends GuiMekanism
{
	public TileEntityLaserAmplifier tileEntity;

	public GuiTextField minField;
	public GuiTextField maxField;
	public GuiTextField timerField;

	public GuiLaserAmplifier(InventoryPlayer inventory, TileEntityLaserAmplifier tentity)
	{
		super(tentity, new ContainerLaserAmplifier(inventory, tentity));
		tileEntity = tentity;

		guiElements.add(new GuiNumberGauge(new INumberInfoHandler()
		{
			@Override
			public TextureAtlasSprite getIcon()
			{
				return MekanismRenderer.energyIcon;
			}

			@Override
			public double getLevel()
			{
				return tileEntity.collectedEnergy;
			}

			@Override
			public double getMaxLevel()
			{
				return tileEntity.MAX_ENERGY;
			}

			@Override
			public String getText(double level)
			{
				return LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(level, tileEntity.getMaxEnergy());
			}
		}, Type.STANDARD, this, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png"), 6, 10));
		guiElements.add(new GuiSecurityTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png")));
		guiElements.add(new GuiRedstoneControl(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png")));
		guiElements.add(new GuiAmplifierTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png")));
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), 55, 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);

		field_146289_q.func_78276_b(tileEntity.time > 0 ? LangUtils.localize("gui.delay") + ": " + tileEntity.time + "t" : LangUtils.localize("gui.noDelay"), 26, 30, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.min") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.minThreshold), 26, 45, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.max") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.maxThreshold), 26, 60, 0x404040);

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		super.func_146976_a(partialTick, mouseX, mouseY);

		minField.func_146194_f();
		maxField.func_146194_f();
		timerField.func_146194_f();
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		minField.func_146178_a();
		maxField.func_146178_a();
		timerField.func_146178_a();
	}

	@Override
	public void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		minField.func_146192_a(mouseX, mouseY, button);
		maxField.func_146192_a(mouseX, mouseY, button);
		timerField.func_146192_a(mouseX, mouseY, button);
	}

	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if(!(minField.func_146206_l() || maxField.func_146206_l() || timerField.func_146206_l()) || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(i == Keyboard.KEY_RETURN)
		{
			if(minField.func_146206_l())
			{
				setMinThreshold();
			}
			if(maxField.func_146206_l())
			{
				setMaxThreshold();
			}
			if(timerField.func_146206_l())
			{
				setTime();
			}
		}

		if(Character.isDigit(c) || c == '.' || c == 'E' || isTextboxKey(c, i))
		{
			minField.func_146201_a(c, i);
			maxField.func_146201_a(c, i);
			timerField.func_146201_a(c, i);
		}
	}

	private void setMinThreshold()
	{
		if(!minField.func_146179_b().isEmpty())
		{
			double toUse;

			try {
				toUse = Math.max(0, Double.parseDouble(minField.func_146179_b()));
			} catch(Exception e) {
				minField.func_146180_a("");
				return;
			}

			ArrayList data = new ArrayList();
			data.add(0);
			data.add(toUse);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));

			minField.func_146180_a("");
		}
	}

	private void setMaxThreshold()
	{
		if(!maxField.func_146179_b().isEmpty())
		{
			double toUse;

			try {
				toUse = Math.max(0, Double.parseDouble(maxField.func_146179_b()));
			} catch(Exception e) {
				maxField.func_146180_a("");
				return;
			}

			ArrayList data = new ArrayList();
			data.add(1);
			data.add(toUse);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));

			maxField.func_146180_a("");
		}
	}

	private void setTime()
	{
		if(!timerField.func_146179_b().isEmpty())
		{
			int toUse = Math.max(0, Integer.parseInt(timerField.func_146179_b()));

			ArrayList data = new ArrayList();
			data.add(2);
			data.add(toUse);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));

			timerField.func_146180_a("");
		}
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		String prevTime = timerField != null ? timerField.func_146179_b() : "";

		timerField = new GuiTextField(0, field_146289_q, guiWidth + 96, guiHeight + 28, 36, 11);
		timerField.func_146203_f(4);
		timerField.func_146180_a(prevTime);

		String prevMin = minField != null ? minField.func_146179_b() : "";
		minField = new GuiTextField(1, field_146289_q, guiWidth + 96, guiHeight + 43, 72, 11);
		minField.func_146203_f(10);
		minField.func_146180_a(prevMin);

		String prevMax = maxField != null ? maxField.func_146179_b() : "";

		maxField = new GuiTextField(2, field_146289_q, guiWidth + 96, guiHeight + 58, 72, 11);
		maxField.func_146203_f(10);
		maxField.func_146180_a(prevMax);
	}
}
