package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotOverlay;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFormulaicAssemblicator;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiFormulaicAssemblicator extends GuiMekanism
{
	public TileEntityFormulaicAssemblicator tileEntity;
	
	public ResourceLocation guiLocation = MekanismUtils.getResource(ResourceType.GUI, "GuiFormulaicAssemblicator.png");

	public GuiFormulaicAssemblicator(InventoryPlayer inventory, TileEntityFormulaicAssemblicator tentity)
	{
		super(tentity, new ContainerFormulaicAssemblicator(inventory, tentity));
		tileEntity = tentity;
		guiElements.add(new GuiSecurityTab(this, tileEntity, guiLocation));
		guiElements.add(new GuiUpgradeTab(this, tileEntity, guiLocation));
		guiElements.add(new GuiRedstoneControl(this, tileEntity, guiLocation));
		guiElements.add(new GuiSideConfigurationTab(this, tileEntity, guiLocation));
		guiElements.add(new GuiTransporterConfigTab(this, 34, tileEntity, guiLocation));
		guiElements.add(new GuiPowerBar(this, tileEntity, guiLocation, 159, 15));
		guiElements.add(new GuiEnergyInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				String multiplier = MekanismUtils.getEnergyDisplay(tileEntity.energyPerTick);
				return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.getMaxEnergy()-tileEntity.getEnergy()));
			}
		}, this, guiLocation));
		guiElements.add(new GuiSlot(SlotType.POWER, this, guiLocation, 151, 75).with(SlotOverlay.POWER));
		
		field_147000_g+=64;
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);
		
		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f/2)-(field_146289_q.func_78256_a(tileEntity.func_70005_c_())/2), 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);
		
		if(xAxis >= 44 && xAxis <= 60 && yAxis >= 75 && yAxis <= 91)
		{
			func_146279_a(LangUtils.localize("gui.fillEmpty"), xAxis, yAxis);
		}
		
		if(xAxis >= 7 && xAxis <= 21 && yAxis >= 45 && yAxis <= 59)
		{
			func_146279_a(LangUtils.localize("gui.encodeFormula"), xAxis, yAxis);
		}
		
		if(xAxis >= 71 && xAxis <= 87 && yAxis >= 75 && yAxis <= 91)
		{
			func_146279_a(LangUtils.localize("gui.craftSingle"), xAxis, yAxis);
		}
		
		if(xAxis >= 89 && xAxis <= 105 && yAxis >= 75 && yAxis <= 91)
		{
			func_146279_a(LangUtils.localize("gui.craftAvailable"), xAxis, yAxis);
		}
		
		if(xAxis >= 107 && xAxis <= 123 && yAxis >= 75 && yAxis <= 91)
		{
			func_146279_a(LangUtils.localize("gui.autoModeToggle") + ": " + LangUtils.transOnOff(tileEntity.autoMode), xAxis, yAxis);
		}
		
		if(xAxis >= 26 && xAxis <= 42 && yAxis >= 75 && yAxis <= 91)
		{
			func_146279_a(LangUtils.localize("gui.stockControl") + ": " + LangUtils.transOnOff(tileEntity.stockControl), xAxis, yAxis);
		}
		
		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(guiLocation);
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		int xAxis = mouseX - guiWidth;
		int yAxis = mouseY - guiHeight;
		
		if(!tileEntity.autoMode)
		{
			if(xAxis >= 44 && xAxis <= 60 && yAxis >= 75 && yAxis <= 91)
			{
				func_73729_b(guiWidth + 44, guiHeight + 75, 176 + 62, 0, 16, 16);
			}
			else {
				func_73729_b(guiWidth + 44, guiHeight + 75, 176 + 62, 16, 16, 16);
			}
		}
		else {
			func_73729_b(guiWidth + 44, guiHeight + 75, 176 + 62, 32, 16, 16);
		}
		
		if(!tileEntity.autoMode && tileEntity.isRecipe)
		{
			if(canEncode())
			{
				if(xAxis >= 7 && xAxis <= 21 && yAxis >= 45 && yAxis <= 59)
				{
					func_73729_b(guiWidth + 7, guiHeight + 45, 176, 0, 14, 14);
				}
				else {
					func_73729_b(guiWidth + 7, guiHeight + 45, 176, 14, 14, 14);
				}
			}
			else {
				func_73729_b(guiWidth + 7, guiHeight + 45, 176, 28, 14, 14);
			}
			
			if(xAxis >= 71 && xAxis <= 87 && yAxis >= 75 && yAxis <= 91)
			{
				func_73729_b(guiWidth + 71, guiHeight + 75, 176 + 14, 0, 16, 16);
			}
			else {
				func_73729_b(guiWidth + 71, guiHeight + 75, 176 + 14, 16, 16, 16);
			}
			
			if(xAxis >= 89 && xAxis <= 105 && yAxis >= 75 && yAxis <= 91)
			{
				func_73729_b(guiWidth + 89, guiHeight + 75, 176 + 30, 0, 16, 16);
			}
			else {
				func_73729_b(guiWidth + 89, guiHeight + 75, 176 + 30, 16, 16, 16);
			}
		}
		else {
			func_73729_b(guiWidth + 7, guiHeight + 45, 176, 28, 14, 14);
			func_73729_b(guiWidth + 71, guiHeight + 75, 176 + 14, 32, 16, 16);
			func_73729_b(guiWidth + 89, guiHeight + 75, 176 + 30, 32, 16, 16);
		}
		
		if(tileEntity.formula != null)
		{
			if(xAxis >= 107 && xAxis <= 123 && yAxis >= 75 && yAxis <= 91)
			{
				func_73729_b(guiWidth + 107, guiHeight + 75, 176 + 46, 0, 16, 16);
			}
			else {
				func_73729_b(guiWidth + 107, guiHeight + 75, 176 + 46, 16, 16, 16);
			}
			
			if(xAxis >= 26 && xAxis <= 42 && yAxis >= 75 && yAxis <= 91)
			{
				func_73729_b(guiWidth + 26, guiHeight + 75, 176 + 62, 48 + 0, 16, 16);
			}
			else {
				func_73729_b(guiWidth + 26, guiHeight + 75, 176 + 62, 48 + 16, 16, 16);
			}
		}
		else {
			func_73729_b(guiWidth + 107, guiHeight + 75, 176 + 46, 32, 16, 16);
			func_73729_b(guiWidth + 26, guiHeight + 75, 176 + 62, 48 + 32, 16, 16);
		}
		
		if(tileEntity.operatingTicks > 0)
		{
			int display = (int)((double)tileEntity.operatingTicks*22/(double)tileEntity.ticksRequired);
			func_73729_b(guiWidth + 86, guiHeight + 43, 176, 48, display, 16);
		}
		
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI_ELEMENT, "GuiSlot.png"));
		func_73729_b(guiWidth + 90, guiHeight + 25, tileEntity.isRecipe ? 2 : 20, 39, 14, 12);
		
		if(tileEntity.formula != null)
		{
			for(int i = 0; i < 9; i++)
			{
				ItemStack stack = tileEntity.formula.input.get(i);
				
				if(!stack.func_190926_b())
				{
					Slot slot = (Slot)field_147002_h.field_75151_b.get(i+20);
					GlStateManager.func_179094_E();
					
					if(slot.func_75211_c().func_190926_b() || !slot.func_75211_c().func_77969_a(stack))
					{
						func_73733_a(guiWidth + slot.field_75223_e, guiHeight + slot.field_75221_f, guiWidth + slot.field_75223_e + 16, guiHeight + slot.field_75221_f + 16, -2137456640, -2137456640);
					}
					
					RenderHelper.func_74520_c();
					field_146296_j.func_180450_b(stack, guiWidth + slot.field_75223_e, guiHeight + slot.field_75221_f);
					MekanismRenderer.resetColor();
					GlStateManager.func_179121_F();
				}
			}
		}

		super.func_146976_a(partialTick, mouseX, mouseY);
	}
	
	private boolean canEncode()
	{
		return tileEntity.formula == null && !tileEntity.inventory.get(2).func_190926_b() && tileEntity.inventory.get(2).func_77973_b() instanceof ItemCraftingFormula &&
				((ItemCraftingFormula)tileEntity.inventory.get(2).func_77973_b()).getInventory(tileEntity.inventory.get(2)) == null;
	}
	
	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(!tileEntity.autoMode)
			{
				if(xAxis >= 44 && xAxis <= 60 && yAxis >= 75 && yAxis <= 91)
				{
					SoundHandler.playSound(SoundEvents.field_187909_gi);
					
					ArrayList data = new ArrayList();
					data.add(4);

					Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				}
				
				if(tileEntity.isRecipe)
				{
					if(canEncode())
					{
						if(xAxis >= 7 && xAxis <= 21 && yAxis >= 45 && yAxis <= 59)
						{
							SoundHandler.playSound(SoundEvents.field_187909_gi);
							
							ArrayList data = new ArrayList();
							data.add(1);
		
							Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
						}
					}
					
					if(xAxis >= 71 && xAxis <= 87 && yAxis >= 75 && yAxis <= 91)
					{
						SoundHandler.playSound(SoundEvents.field_187909_gi);
						
						ArrayList data = new ArrayList();
						data.add(2);
	
						Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
					}
					
					if(xAxis >= 89 && xAxis <= 105 && yAxis >= 75 && yAxis <= 91)
					{
						SoundHandler.playSound(SoundEvents.field_187909_gi);
						
						ArrayList data = new ArrayList();
						data.add(3);
	
						Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
					}
				}
			}
			
			if(tileEntity.formula != null)
			{
				if(xAxis >= 107 && xAxis <= 123 && yAxis >= 75 && yAxis <= 91)
				{
					SoundHandler.playSound(SoundEvents.field_187909_gi);
					
					ArrayList data = new ArrayList();
					data.add(0);
	
					Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				}
				
				if(xAxis >= 26 && xAxis <= 42 && yAxis >= 75 && yAxis <= 91)
				{
					SoundHandler.playSound(SoundEvents.field_187909_gi);
					
					ArrayList data = new ArrayList();
					data.add(5);
					
					Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				}
			}
		}
	}
}
