package mekanism.client.gui;

import mekanism.client.gui.element.GuiContainerEditMode;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiFluidGauge.IFluidInfoHandler;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotOverlay;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.common.inventory.container.ContainerFluidTank;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

import mekanism.client.gui.element.GuiGauge;

@SideOnly(Side.CLIENT)
public class GuiFluidTank extends GuiMekanism
{
	public TileEntityFluidTank tileEntity;

	public GuiFluidTank(InventoryPlayer inventory, TileEntityFluidTank tentity)
	{
		super(tentity, new ContainerFluidTank(inventory, tentity));
		tileEntity = tentity;
		guiElements.add(new GuiContainerEditMode(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png")));
		guiElements.add(new GuiSecurityTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png")));
		guiElements.add(new GuiFluidGauge(new IFluidInfoHandler()
		{
			@Override
			public FluidTank getTank()
			{
				return tileEntity.fluidTank;
			}
		}, GuiFluidGauge.Type.WIDE, this, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png"), 48, 18));
		guiElements.add(new GuiSlot(SlotType.NORMAL, this, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png"), 145, 18).with(SlotOverlay.INPUT));
		guiElements.add(new GuiSlot(SlotType.NORMAL, this, MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png"), 145, 50).with(SlotOverlay.OUTPUT));
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), (field_146999_f/2)-(field_146289_q.func_78256_a(tileEntity.func_70005_c_())/2), 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, field_147000_g - 96 + 2, 0x404040);

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiBlank.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		super.func_146976_a(partialTick, mouseX, mouseY);
	}
}
