package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.content.miner.MMaterialFilter;
import mekanism.common.content.miner.MModIDFilter;
import mekanism.common.content.miner.MOreDictFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketDigitalMinerGui.DigitalMinerGuiMessage;
import mekanism.common.network.PacketDigitalMinerGui.MinerGuiPacket;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiDigitalMinerConfig extends GuiMekanism
{
	public TileEntityDigitalMiner tileEntity;

	public boolean isDragging = false;

	// Scrollbar dimensions
	private final int scrollX = 154;
	private final int scrollY = 18;

	private final int scrollW = 12;
	private final int scrollH = 138;

	// Filter dimensions
	private final int filterX = 56;
	private final int filterY = 18;

	private final int filterW = 96;
	private final int filterH = 29;

	public int dragOffset = 0;

	public int stackSwitch = 0;

	public Map<MOreDictFilter, StackData> oreDictStacks = new HashMap<MOreDictFilter, StackData>();
	public Map<MModIDFilter, StackData> modIDStacks = new HashMap<MModIDFilter, StackData>();

	public float scroll;

	private GuiTextField radiusField;
	private GuiTextField minField;
	private GuiTextField maxField;

	public GuiDigitalMinerConfig(EntityPlayer player, TileEntityDigitalMiner tentity)
	{
		super(tentity, new ContainerNull(player, tentity));
		tileEntity = tentity;
	}

	public int getScroll()
	{
		return Math.max(Math.min((int)(scroll*123), 123), 0);
	}

	public int getFilterIndex()
	{
		if(needsScrollBars())
		{
			final int scrollSize = tileEntity.filters.size() - 4;
			return (int)((scrollSize + 0.5) * scroll);
		}
		
		return 0;
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		radiusField.func_146178_a();
		minField.func_146178_a();
		maxField.func_146178_a();

		if(stackSwitch > 0)
		{
			stackSwitch--;
		}

		if(stackSwitch == 0)
		{
			for(Map.Entry<MOreDictFilter, StackData> entry : oreDictStacks.entrySet())
			{
				if(entry.getValue().iterStacks != null && entry.getValue().iterStacks.size() > 0)
				{
					if(entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size()-1)
					{
						entry.getValue().stackIndex = 0;
					}
					else if(entry.getValue().stackIndex < entry.getValue().iterStacks.size()-1)
					{
						entry.getValue().stackIndex++;
					}

					entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
				}
			}
			
			for(Map.Entry<MModIDFilter, StackData> entry : modIDStacks.entrySet())
			{
				if(entry.getValue().iterStacks != null && entry.getValue().iterStacks.size() > 0)
				{
					if(entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size()-1)
					{
						entry.getValue().stackIndex = 0;
					}
					else if(entry.getValue().stackIndex < entry.getValue().iterStacks.size()-1)
					{
						entry.getValue().stackIndex++;
					}

					entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
				}
			}

			stackSwitch = 20;
		}
		else {
			for(Map.Entry<MOreDictFilter, StackData> entry : oreDictStacks.entrySet())
			{
				if(entry.getValue().iterStacks != null && entry.getValue().iterStacks.size() == 0)
				{
					entry.getValue().renderStack = ItemStack.field_190927_a;
				}
			}
			
			for(Map.Entry<MModIDFilter, StackData> entry : modIDStacks.entrySet())
			{
				if(entry.getValue().iterStacks != null && entry.getValue().iterStacks.size() == 0)
				{
					entry.getValue().renderStack = ItemStack.field_190927_a;
				}
			}
		}

		Set<MOreDictFilter> oreDictFilters = new HashSet<MOreDictFilter>();
		Set<MModIDFilter> modIDFilters = new HashSet<MModIDFilter>();

		for(int i = 0; i < 4; i++)
		{
			if(tileEntity.filters.get(getFilterIndex()+i) instanceof MOreDictFilter)
			{
				oreDictFilters.add((MOreDictFilter)tileEntity.filters.get(getFilterIndex()+i));
			}
			else if(tileEntity.filters.get(getFilterIndex()+i) instanceof MModIDFilter)
			{
				modIDFilters.add((MModIDFilter)tileEntity.filters.get(getFilterIndex()+i));
			}
		}

		for(MinerFilter filter : tileEntity.filters)
		{
			if(filter instanceof MOreDictFilter && !oreDictFilters.contains(filter))
			{
				if(oreDictStacks.containsKey(filter))
				{
					oreDictStacks.remove(filter);
				}
			}
			else if(filter instanceof MModIDFilter && !modIDFilters.contains(filter))
			{
				if(modIDStacks.containsKey(filter))
				{
					modIDStacks.remove(filter);
				}
			}
		}
	}

	@Override
	public void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		radiusField.func_146192_a(mouseX, mouseY, button);
		minField.func_146192_a(mouseX, mouseY, button);
		maxField.func_146192_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 154 && xAxis <= 166 && yAxis >= getScroll()+18 && yAxis <= getScroll()+18+15)
			{
				if(needsScrollBars())
				{
					dragOffset = yAxis - (getScroll()+18);
					isDragging = true;
				}
				else {
					scroll = 0;
				}
			}

			for(int i = 0; i < 4; i++)
			{
				if(tileEntity.filters.get(getFilterIndex()+i) != null)
				{
					int yStart = i*29 + 18;

					// Check for sorting button
					final int arrowX = filterX + filterW - 12;
					
					if(getFilterIndex() + i > 0)
					{
						if(xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 14 && yAxis <= yStart + 20)
						{
							// Process up button click
							final ArrayList data = new ArrayList();
							data.add(11);
							data.add(getFilterIndex() + i);

							Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
							SoundHandler.playSound(SoundEvents.field_187909_gi);
							
							return;
						}
					}
					
					if(getFilterIndex() + i < tileEntity.filters.size() - 1)
					{
						if(xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 21 && yAxis <= yStart + 27)
						{
							// Process down button click
							final ArrayList data = new ArrayList();
							data.add(12);
							data.add(getFilterIndex() + i);

							Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
							SoundHandler.playSound(SoundEvents.field_187909_gi);
							
							return;
						}
					}

					if(xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart+29)
					{
						MinerFilter filter = tileEntity.filters.get(getFilterIndex()+i);

						if(filter instanceof MItemStackFilter)
						{
							SoundHandler.playSound(SoundEvents.field_187909_gi);
							Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER_INDEX, Coord4D.get(tileEntity), 1, getFilterIndex()+i, 0));
						}
						else if(filter instanceof MOreDictFilter)
						{
							SoundHandler.playSound(SoundEvents.field_187909_gi);
							Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER_INDEX, Coord4D.get(tileEntity), 2, getFilterIndex()+i, 0));
						}
						else if(filter instanceof MMaterialFilter)
						{
							SoundHandler.playSound(SoundEvents.field_187909_gi);
							Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER_INDEX, Coord4D.get(tileEntity), 3, getFilterIndex()+i, 0));
						}
						else if(filter instanceof MModIDFilter)
						{
							SoundHandler.playSound(SoundEvents.field_187909_gi);
							Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER_INDEX, Coord4D.get(tileEntity), 6, getFilterIndex()+i, 0));
						}
					}
				}
			}

			if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER, Coord4D.get(tileEntity), 4, 0, 0));
			}

			if(xAxis >= 39 && xAxis <= 50 && yAxis >= 67 && yAxis <= 78)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				setRadius();
			}

			if(xAxis >= 39 && xAxis <= 50 && yAxis >= 92 && yAxis <= 103)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				setMinY();
			}

			if(xAxis >= 39 && xAxis <= 50 && yAxis >= 117 && yAxis <= 128)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);
				setMaxY();
			}

			if(xAxis >= 11 && xAxis <= 25 && yAxis >= 141 && yAxis <= 155)
			{
				ArrayList data = new ArrayList();
				data.add(10);

				Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
				SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
		}
	}

	@Override
	protected void func_146273_a(int mouseX, int mouseY, int button, long ticks)
	{
		super.func_146273_a(mouseX, mouseY, button, ticks);

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(isDragging)
		{
			scroll = Math.min(Math.max((float)(yAxis-18-dragOffset)/123F, 0), 1);
		}
	}

	@Override
	protected void func_146286_b(int x, int y, int type)
	{
		super.func_146286_b(x, y, type);

		if(type == 0 && isDragging)
		{
			dragOffset = 0;
			isDragging = false;
		}
	}

	/**
	 * Handles mouse input.
	 */
	@Override
	public void func_146274_d() throws IOException
	{
		super.func_146274_d();
		
		int i = Mouse.getEventDWheel();

		if(i != 0 && needsScrollBars())
		{
			final int j = tileEntity.filters.size() - 4;

			if(i > 0)
			{
				i = 1;
			}

			if(i < 0)
			{
				i = -1;
			}

			scroll = (float)(scroll - (double) i / (double) j);

			if(scroll < 0.0F)
			{
				scroll = 0.0F;
			}

			if(scroll > 1.0F)
			{
				scroll = 1.0F;
			}
		}
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		field_146292_n.add(new GuiButton(0, guiWidth + 56, guiHeight + 136, 96, 20, LangUtils.localize("gui.newFilter")));

		String prevRad = radiusField != null ? radiusField.func_146179_b() : "";
		String prevMin = minField != null ? minField.func_146179_b() : "";
		String prevMax = maxField != null ? maxField.func_146179_b() : "";

		radiusField = new GuiTextField(1, field_146289_q, guiWidth + 12, guiHeight + 67, 26, 11);
		radiusField.func_146203_f(2);
		radiusField.func_146180_a(prevRad);

		minField = new GuiTextField(2, field_146289_q, guiWidth + 12, guiHeight + 92, 26, 11);
		minField.func_146203_f(3);
		minField.func_146180_a(prevMin);

		maxField = new GuiTextField(3, field_146289_q, guiWidth + 12, guiHeight + 117, 26, 11);
		maxField.func_146203_f(3);
		maxField.func_146180_a(prevMax);
	}

	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER, Coord4D.get(tileEntity), 5, 0, 0));
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMinerConfig"), 43, 6, 0x404040);

		field_146289_q.func_78276_b(LangUtils.localize("gui.filters") + ":", 11, 19, 0x00CD00);
		field_146289_q.func_78276_b("T: " + tileEntity.filters.size(), 11, 28, 0x00CD00);
		
		field_146289_q.func_78276_b("I: " + (tileEntity.inverse ? LangUtils.localize("gui.on") : LangUtils.localize("gui.off")), 11, 131, 0x00CD00);

		field_146289_q.func_78276_b("Radi: " + tileEntity.radius, 11, 58, 0x00CD00);

		field_146289_q.func_78276_b("Min: " + tileEntity.minY, 11, 83, 0x00CD00);

		field_146289_q.func_78276_b("Max: " + tileEntity.maxY, 11, 108, 0x00CD00);

		for(int i = 0; i < 4; i++)
		{
			if(tileEntity.filters.get(getFilterIndex()+i) != null)
			{
				MinerFilter filter = tileEntity.filters.get(getFilterIndex()+i);
				int yStart = i*29 + 18;

				if(filter instanceof MItemStackFilter)
				{
					MItemStackFilter itemFilter = (MItemStackFilter)filter;

					if(!itemFilter.itemType.func_190926_b())
					{
						GlStateManager.func_179094_E();
						RenderHelper.func_74520_c();
						field_146296_j.func_180450_b(itemFilter.itemType, 59, yStart + 3);
						RenderHelper.func_74518_a();
						GlStateManager.func_179121_F();
					}

					field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
				}
				else if(filter instanceof MOreDictFilter)
				{
					MOreDictFilter oreFilter = (MOreDictFilter)filter;

					if(!oreDictStacks.containsKey(oreFilter))
					{
						updateStackList(oreFilter);
					}

					ItemStack renderStack = oreDictStacks.get(filter).renderStack;
					
					if(!renderStack.func_190926_b())
					{
						try {
							GlStateManager.func_179094_E();
							RenderHelper.func_74520_c();
							field_146296_j.func_180450_b(renderStack, 59, yStart + 3);
							RenderHelper.func_74518_a();
							GlStateManager.func_179121_F();
						} catch(Exception e) {}
					}

					field_146289_q.func_78276_b(LangUtils.localize("gui.oredictFilter"), 78, yStart + 2, 0x404040);
				}
				else if(filter instanceof MMaterialFilter)
				{
					MMaterialFilter itemFilter = (MMaterialFilter)filter;

					if(!itemFilter.materialItem.func_190926_b())
					{
						GlStateManager.func_179094_E();
						RenderHelper.func_74520_c();
						field_146296_j.func_180450_b(itemFilter.materialItem, 59, yStart + 3);
						RenderHelper.func_74518_a();
						GlStateManager.func_179121_F();
					}

					field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter"), 78, yStart + 2, 0x404040);
				}
				else if(filter instanceof MModIDFilter)
				{
					MModIDFilter modFilter = (MModIDFilter)filter;

					if(!modIDStacks.containsKey(modFilter))
					{
						updateStackList(modFilter);
					}

					ItemStack renderStack = modIDStacks.get(filter).renderStack;
					
					if(!renderStack.func_190926_b())
					{
						try {
							GlStateManager.func_179094_E();
							RenderHelper.func_74520_c();
							field_146296_j.func_180450_b(renderStack, 59, yStart + 3);
							RenderHelper.func_74518_a();
							GlStateManager.func_179121_F();
						} catch(Exception e) {}
					}

					field_146289_q.func_78276_b(LangUtils.localize("gui.modIDFilter"), 78, yStart + 2, 0x404040);
				}
			}
		}

		if(xAxis >= 11 && xAxis <= 25 && yAxis >= 141 && yAxis <= 155)
		{
			func_146279_a(LangUtils.localize("gui.digitalMiner.inverse"), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		super.func_146976_a(partialTick, mouseX, mouseY);

		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMinerConfig.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		func_73729_b( field_147003_i + scrollX, field_147009_r + scrollY + getScroll(), 232 + ( needsScrollBars() ? 0 : 12 ), 0, 12, 15 );

		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		for(int i = 0; i < 4; i++)
		{
			if(tileEntity.filters.get(getFilterIndex()+i) != null)
			{
				MinerFilter filter = tileEntity.filters.get(getFilterIndex()+i);
				int yStart = i*29 + 18;

				boolean mouseOver = xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart+29;

				if(filter instanceof MItemStackFilter)
				{
					MekanismRenderer.color(EnumColor.INDIGO, 1.0F, 2.5F);
				}
				else if(filter instanceof MOreDictFilter)
				{
					MekanismRenderer.color(EnumColor.BRIGHT_GREEN, 1.0F, 2.5F);
				}
				else if(filter instanceof MMaterialFilter)
				{
					MekanismRenderer.color(EnumColor.PURPLE, 1.0F, 4F);
				}
				else if(filter instanceof MModIDFilter)
				{
					MekanismRenderer.color(EnumColor.PINK, 1.0F, 2.5F);
				}
				
				func_73729_b(guiWidth + 56, guiHeight + yStart, mouseOver ? 0 : 96, 166, 96, 29);
				MekanismRenderer.resetColor();

				// Draw sort buttons
				final int arrowX = filterX + filterW - 12;
				if( getFilterIndex() + i > 0 )
				{
					mouseOver = xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 14 && yAxis <= yStart + 20;
					func_73729_b( field_147003_i + arrowX, field_147009_r + yStart + 14, 190, mouseOver ? 143 : 115, 11, 7 );
				}
				if( getFilterIndex() + i < tileEntity.filters.size() - 1 )
				{
					mouseOver = xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 21 && yAxis <= yStart + 27;
					func_73729_b( field_147003_i + arrowX, field_147009_r + yStart + 21, 190, mouseOver ? 157 : 129, 11, 7 );
				}
			}
		}

		if(xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16)
		{
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
		}

		if(xAxis >= 39 && xAxis <= 50 && yAxis >= 67 && yAxis <= 78)
		{
			func_73729_b(guiWidth + 39, guiHeight + 67, 176 + 11, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 39, guiHeight + 67, 176 + 11, 11, 11, 11);
		}

		if(xAxis >= 39 && xAxis <= 50 && yAxis >= 92 && yAxis <= 103)
		{
			func_73729_b(guiWidth + 39, guiHeight + 92, 176 + 11, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 39, guiHeight + 92, 176 + 11, 11, 11, 11);
		}

		if(xAxis >= 39 && xAxis <= 50 && yAxis >= 117 && yAxis <= 128)
		{
			func_73729_b(guiWidth + 39, guiHeight + 117, 176 + 11, 0, 11, 11);
		}
		else {
			func_73729_b(guiWidth + 39, guiHeight + 117, 176 + 11, 11, 11, 11);
		}

		if(xAxis >= 11 && xAxis <= 25 && yAxis >= 141 && yAxis <= 155)
		{
			func_73729_b(guiWidth + 11, guiHeight + 141, 176 + 22, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 11, guiHeight + 141, 176 + 22, 14, 14, 14);
		}

		radiusField.func_146194_f();
		minField.func_146194_f();
		maxField.func_146194_f();
	}

	@Override
	public void func_73869_a(char c, int i) throws IOException
	{
		if((!radiusField.func_146206_l() && !minField.func_146206_l() && !maxField.func_146206_l()) || i == Keyboard.KEY_ESCAPE)
		{
			super.func_73869_a(c, i);
		}

		if(i == Keyboard.KEY_RETURN)
		{
			if(radiusField.func_146206_l())
			{
				setRadius();
			}
			else if(minField.func_146206_l())
			{
				setMinY();
			}
			else if(maxField.func_146206_l())
			{
				setMaxY();
			}
		}

		if(Character.isDigit(c) || isTextboxKey(c, i))
		{
			radiusField.func_146201_a(c, i);
			minField.func_146201_a(c, i);
			maxField.func_146201_a(c, i);
		}
	}

	private void setRadius()
	{
		if(!radiusField.func_146179_b().isEmpty())
		{
			int toUse = Math.max(0, Math.min(Integer.parseInt(radiusField.func_146179_b()), 32));

			ArrayList data = new ArrayList();
			data.add(6);
			data.add(toUse);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));

			radiusField.func_146180_a("");
		}
	}

	private void setMinY()
	{
		if(!minField.func_146179_b().isEmpty())
		{
			int toUse = Math.max(0, Math.min(Integer.parseInt(minField.func_146179_b()), tileEntity.maxY));

			ArrayList data = new ArrayList();
			data.add(7);
			data.add(toUse);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));

			minField.func_146180_a("");
		}
	}

	private void setMaxY()
	{
		if(!maxField.func_146179_b().isEmpty())
		{
			int toUse = Math.max(tileEntity.minY, Math.min(Integer.parseInt(maxField.func_146179_b()), 255));

			ArrayList data = new ArrayList();
			data.add(8);
			data.add(toUse);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));

			maxField.func_146180_a("");
		}
	}

	private void updateStackList(MOreDictFilter filter)
	{
		if(!oreDictStacks.containsKey(filter))
		{
			oreDictStacks.put(filter, new StackData());
		}
		
		oreDictStacks.get(filter).iterStacks = OreDictCache.getOreDictStacks(filter.oreDictName, true);

		stackSwitch = 0;
		func_73876_c();
		oreDictStacks.get(filter).stackIndex = -1;
	}
	
	private void updateStackList(MModIDFilter filter)
	{
		if(!modIDStacks.containsKey(filter))
		{
			modIDStacks.put(filter, new StackData());
		}
		
		modIDStacks.get(filter).iterStacks = OreDictCache.getModIDStacks(filter.modID, true);

		stackSwitch = 0;
		func_73876_c();
		modIDStacks.get(filter).stackIndex = -1;
	}

	public static class StackData
	{
		public List<ItemStack> iterStacks;
		public int stackIndex;
		public ItemStack renderStack = ItemStack.field_190927_a;
	}

	/**
	 * returns true if there are more filters than can fit in the gui
	 */
	private boolean needsScrollBars()
	{
		return tileEntity.filters.size() > 4;
	}
}
