package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotOverlay;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.gui.element.GuiVisualsTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.content.miner.ThreadMinerSearch.State;
import mekanism.common.inventory.container.ContainerDigitalMiner;
import mekanism.common.network.PacketDigitalMinerGui.DigitalMinerGuiMessage;
import mekanism.common.network.PacketDigitalMinerGui.MinerGuiPacket;
import mekanism.common.network.PacketTileEntity.TileEntityMessage;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

@SideOnly(Side.CLIENT)
public class GuiDigitalMiner extends GuiMekanism
{
	public TileEntityDigitalMiner tileEntity;

	public GuiButton startButton;
	public GuiButton stopButton;
	public GuiButton configButton;

	public GuiDigitalMiner(InventoryPlayer inventory, TileEntityDigitalMiner tentity)
	{
		super(tentity, new ContainerDigitalMiner(inventory, tentity));
		tileEntity = tentity;

		guiElements.add(new GuiRedstoneControl(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png")));
		guiElements.add(new GuiSecurityTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png")));
		guiElements.add(new GuiUpgradeTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png")));
		guiElements.add(new GuiPowerBar(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png"), 163, 23));
		guiElements.add(new GuiVisualsTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png")));
		guiElements.add(new GuiEnergyInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				String multiplier = MekanismUtils.getEnergyDisplay(tileEntity.getPerTick());
				return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.getMaxEnergy()-tileEntity.getEnergy()));
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png")));

		guiElements.add(new GuiSlot(SlotType.NORMAL, this, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png"), 151, 5).with(SlotOverlay.POWER));
		guiElements.add(new GuiSlot(SlotType.NORMAL, this, MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png"), 143, 26));

		field_147000_g+=64;
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();

		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;

		field_146292_n.clear();
		startButton = new GuiButton(0, guiWidth + 69, guiHeight + 17, 60, 20, LangUtils.localize("gui.start"));

		if(tileEntity.searcher.state != State.IDLE && tileEntity.running)
		{
			startButton.field_146124_l = false;
		}

		stopButton = new GuiButton(1, guiWidth + 69, guiHeight + 37, 60, 20, LangUtils.localize("gui.stop"));

		if(tileEntity.searcher.state == State.IDLE || !tileEntity.running)
		{
			stopButton.field_146124_l = false;
		}

		configButton = new GuiButton(2, guiWidth + 69, guiHeight + 57, 60, 20, LangUtils.localize("gui.config"));

		if(tileEntity.searcher.state != State.IDLE)
		{
			configButton.field_146124_l = false;
		}

		field_146292_n.add(startButton);
		field_146292_n.add(stopButton);
		field_146292_n.add(configButton);
	}

	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException
	{
		super.func_146284_a(guibutton);

		if(guibutton.field_146127_k == 0)
		{
			ArrayList<Object> data = new ArrayList<Object>();
			data.add(3);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
		}
		else if(guibutton.field_146127_k == 1)
		{
			ArrayList<Object> data = new ArrayList<Object>();
			data.add(4);

			Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
		}
		else if(guibutton.field_146127_k == 2)
		{
			Mekanism.packetHandler.sendToServer(new DigitalMinerGuiMessage(MinerGuiPacket.SERVER, Coord4D.get(tileEntity), 0, 0, 0));
		}
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		if(tileEntity.searcher.state != State.IDLE && tileEntity.running)
		{
			startButton.field_146124_l = false;
		}
		else {
			startButton.field_146124_l = true;
		}

		if(tileEntity.searcher.state == State.IDLE || !tileEntity.running)
		{
			stopButton.field_146124_l = false;
		}
		else {
			stopButton.field_146124_l = true;
		}

		if(tileEntity.searcher.state != State.IDLE)
		{
			configButton.field_146124_l = false;
		}
		else {
			configButton.field_146124_l = true;
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), 69, 6, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);

		field_146289_q.func_78276_b(tileEntity.running ? LangUtils.localize("gui.digitalMiner.running") : LangUtils.localize("gui.idle"), 9, 10, 0x00CD00);
		field_146289_q.func_78276_b(tileEntity.searcher.state.desc, 9, 19, 0x00CD00);

		field_146289_q.func_78276_b(LangUtils.localize("gui.eject") + ": " + LangUtils.localize("gui." + (tileEntity.doEject ? "on" : "off")), 9, 30, 0x00CD00);
		field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.pull") + ": " + LangUtils.localize("gui." + (tileEntity.doPull ? "on" : "off")), 9, 39, 0x00CD00);
		field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.silk") + ": " + LangUtils.localize("gui." + (tileEntity.silkTouch ? "on" : "off")), 9, 48, 0x00CD00);

		field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.toMine") + ":", 9, 59, 0x00CD00);
		field_146289_q.func_78276_b("" + tileEntity.clientToMine, 9, 68, 0x00CD00);

		if(!tileEntity.missingStack.func_190926_b())
		{
			GlStateManager.func_179094_E();
			GL11.glColor4f(1, 1, 1, 1);
			RenderHelper.func_74520_c();
			GL11.glEnable(GL12.GL_RESCALE_NORMAL);

			field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
			
			drawTexturedRectFromIcon(144, 27, MekanismRenderer.getColorIcon(EnumColor.DARK_RED), 16, 16);
			field_146296_j.func_180450_b(tileEntity.missingStack, 144, 27);
			
			RenderHelper.func_74518_a();
			GlStateManager.func_179121_F();
		}
		else {
			field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(ResourceType.GUI_ELEMENT, "GuiSlot.png"));
			func_73729_b(143, 26, SlotOverlay.CHECK.textureX, SlotOverlay.CHECK.textureY, 18, 18);
		}

		if(xAxis >= 164 && xAxis <= 168 && yAxis >= 25 && yAxis <= 77)
		{
			func_146279_a(MekanismUtils.getEnergyDisplay(tileEntity.getEnergy(), tileEntity.getMaxEnergy()), xAxis, yAxis);
		}

		if(xAxis >= 147 && xAxis <= 161 && yAxis >= 47 && yAxis <= 61)
		{
			func_146279_a(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
		}

		if(xAxis >= 147 && xAxis <= 161 && yAxis >= 63 && yAxis <= 77)
		{
			func_146279_a(LangUtils.localize("gui.digitalMiner.autoPull"), xAxis, yAxis);
		}

		if(xAxis >= 144 && xAxis <= 160 && yAxis >= 27 && yAxis <= 43)
		{
			if(!tileEntity.missingStack.func_190926_b())
			{
				func_146279_a(LangUtils.localize("gui.digitalMiner.missingBlock"), xAxis, yAxis);
			}
			else {
				func_146279_a(LangUtils.localize("gui.well"), xAxis, yAxis);
			}
		}

		if(xAxis >= 131 && xAxis <= 145 && yAxis >= 47 && yAxis <= 61)
		{
			func_146279_a(LangUtils.localize("gui.digitalMiner.reset"), xAxis, yAxis);
		}

		if(xAxis >= 131 && xAxis <= 145 && yAxis >= 63 && yAxis <= 77)
		{
			func_146279_a(LangUtils.localize("gui.digitalMiner.silkTouch"), xAxis, yAxis);
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiDigitalMiner.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = mouseX - guiWidth;
		int yAxis = mouseY - guiHeight;

		int displayInt;

		displayInt = tileEntity.getScaledEnergyLevel(52);
		func_73729_b(guiWidth + 164, guiHeight + 25 + 52 - displayInt, 176, 52 - displayInt, 4, displayInt);

		if(xAxis >= 147 && xAxis <= 161 && yAxis >= 47 && yAxis <= 61)
		{
			func_73729_b(guiWidth + 147, guiHeight + 47, 176 + 4, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 147, guiHeight + 47, 176 + 4, 14, 14, 14);
		}

		if(xAxis >= 147 && xAxis <= 161 && yAxis >= 63 && yAxis <= 77)
		{
			func_73729_b(guiWidth + 147, guiHeight + 63, 176 + 4 + 14, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 147, guiHeight + 63, 176 + 4 + 14, 14, 14, 14);
		}

		if(xAxis >= 131 && xAxis <= 145 && yAxis >= 47 && yAxis <= 61)
		{
			func_73729_b(guiWidth + 131, guiHeight + 47, 176 + 4 + 28, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 131, guiHeight + 47, 176 + 4 + 28, 14, 14, 14);
		}

		if(xAxis >= 131 && xAxis <= 145 && yAxis >= 63 && yAxis <= 77)
		{
			func_73729_b(guiWidth + 131, guiHeight + 63, 176 + 4 + 42, 0, 14, 14);
		}
		else {
			func_73729_b(guiWidth + 131, guiHeight + 63, 176 + 4 + 42, 14, 14, 14);
		}

		super.func_146976_a(partialTick, mouseX, mouseY);
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, button);

		if(button == 0)
		{
			int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
			int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

			if(xAxis >= 147 && xAxis <= 161 && yAxis >= 47 && yAxis <= 61)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);

				ArrayList<Object> data = new ArrayList<Object>();
				data.add(0);

				Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
			}

			if(xAxis >= 147 && xAxis <= 161 && yAxis >= 63 && yAxis <= 77)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);

				ArrayList<Object> data = new ArrayList<Object>();
				data.add(1);

				Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
			}

			if(xAxis >= 131 && xAxis <= 145 && yAxis >= 47 && yAxis <= 61)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);

				ArrayList<Object> data = new ArrayList<Object>();
				data.add(5);

				Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
			}

			if(xAxis >= 131 && xAxis <= 145 && yAxis >= 63 && yAxis <= 77)
			{
				SoundHandler.playSound(SoundEvents.field_187909_gi);

				ArrayList<Object> data = new ArrayList<Object>();
				data.add(9);

				Mekanism.packetHandler.sendToServer(new TileEntityMessage(Coord4D.get(tileEntity), data));
			}
		}
	}
}
