package mekanism.client.gui;

import java.io.IOException;

import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.sound.SoundHandler;
import mekanism.common.inventory.container.ContainerDictionary;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiDictionary extends GuiMekanism
{
	public ItemStack itemType = ItemStack.field_190927_a;
	
	public GuiScrollList scrollList;

	public GuiDictionary(InventoryPlayer inventory)
	{
		super(new ContainerDictionary(inventory));
		
		guiElements.add(scrollList = new GuiScrollList(this, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalOxidizer.png"), 8, 30, 160, 4));
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(LangUtils.localize("item.Dictionary.name"), 64, 5, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, field_147000_g - 96 + 2, 0x404040);

		if(!itemType.func_190926_b())
		{
			GlStateManager.func_179094_E();
			RenderHelper.func_74520_c();
			field_146296_j.func_180450_b(itemType, 6, 6);
			RenderHelper.func_74518_a();
			GlStateManager.func_179121_F();
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiDictionary.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		int xAxis = mouseX - guiWidth;
		int yAxis = mouseY - guiHeight;

		if(xAxis >= 6 && xAxis <= 22 && yAxis >= 6 && yAxis <= 22)
		{
			GlStateManager.func_179094_E();
			GL11.glDisable(GL11.GL_LIGHTING);
			GL11.glDisable(GL11.GL_DEPTH_TEST);

			int x = guiWidth + 6;
			int y = guiHeight + 6;
			func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);

			GL11.glEnable(GL11.GL_LIGHTING);
			GL11.glEnable(GL11.GL_DEPTH_TEST);
			GlStateManager.func_179121_F();
		}
		
		super.func_146976_a(partialTick, mouseX, mouseY);
	}

	@Override
	public boolean func_73868_f()
	{
		return false;
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		if(button == 0)
		{
			if(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
			{
				Slot hovering = null;

				for(int i = 0; i < field_147002_h.field_75151_b.size(); i++)
				{
					Slot slot = field_147002_h.field_75151_b.get(i);

					if(isMouseOverSlot(slot, mouseX, mouseY))
					{
						hovering = slot;
						break;
					}
				}

				if(hovering != null)
				{
					ItemStack stack = hovering.func_75211_c();

					if(!stack.func_190926_b())
					{
						itemType = stack.func_77946_l();
						itemType.func_190920_e(1);

						scrollList.setText(MekanismUtils.getOreDictName(itemType));
						SoundHandler.playSound(SoundEvents.field_187909_gi);
						
						return;
					}
				}
			}

			if(xAxis >= 6 && xAxis <= 22 && yAxis >= 6 && yAxis <= 22)
			{
				ItemStack stack = field_146297_k.field_71439_g.field_71071_by.func_70445_o();

				if(!stack.func_190926_b() && !Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					itemType = stack.func_77946_l();
					itemType.func_190920_e(1);

					scrollList.setText(MekanismUtils.getOreDictName(itemType));
				}
				else if(stack.func_190926_b() && Keyboard.isKeyDown(Keyboard.KEY_LSHIFT))
				{
					itemType = ItemStack.field_190927_a;
					
					scrollList.setText(null);
				}

				SoundHandler.playSound(SoundEvents.field_187909_gi);
			}
		}

		super.func_73864_a(mouseX, mouseY, button);
	}
}
