package mekanism.client.gui;

import mekanism.api.EnumColor;
import mekanism.client.ThreadClientUpdate;
import mekanism.common.Mekanism;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiCredits extends GuiScreen
{
	private static String updateProgress = "";

	@Override
	public void func_73866_w_()
	{
		field_146292_n.clear();
		field_146292_n.add(new GuiButton(0, field_146294_l / 2 - 100, field_146295_m / 4 + 72 + 12, "Update"));
		field_146292_n.add(new GuiButton(1, field_146294_l / 2 - 100, field_146295_m / 4 + 96 + 12, "Cancel"));
		((GuiButton)field_146292_n.get(0)).field_146124_l = !MekanismUtils.noUpdates() && !ThreadClientUpdate.hasUpdated;
	}

	public static void updateInfo(String info)
	{
		updateProgress = info;
	}

	@Override
	protected void func_146284_a(GuiButton guibutton)
	{
		if(guibutton.field_146127_k == 0)
		{
			if(!MekanismUtils.noUpdates())
			{
				updateProgress = "Preparing to update...";
				guibutton.field_146124_l = false;

				new ThreadClientUpdate();
			}
			else {
				updateProgress = "You already have the latest version.";
			}
		}
		else if(guibutton.field_146127_k == 1)
		{
			field_146297_k.func_147108_a(null);
		}
	}

	public void writeText(String text, int yAxis)
	{
		func_73731_b(field_146289_q, text, field_146294_l / 2 - 140, (field_146295_m / 4 - 60) + 20 + yAxis, 0xa0a0a0);
	}

	@Override
	public boolean func_73868_f()
	{
		return false;
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTick)
	{
		func_146276_q_();
		func_73732_a(field_146289_q, EnumColor.DARK_BLUE + "Mekanism" + EnumColor.GREY + " by aidancbrady", field_146294_l / 2, (field_146295_m / 4 - 60) + 20, 0xffffff);

		if(Mekanism.latestVersionNumber != null && !Mekanism.latestVersionNumber.equals("null"))
		{
			writeText(EnumColor.INDIGO + "Mekanism " + (Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) == -1 ? EnumColor.DARK_RED : EnumColor.GREY) + Mekanism.versionNumber, 36);
		}
		else {
			writeText(EnumColor.INDIGO + "Mekanism " + EnumColor.GREY + Mekanism.versionNumber, 36);
		}

		int size = 36;

		for(IModule module : Mekanism.modulesLoaded)
		{
			size += 9;

			if(Mekanism.latestVersionNumber != null && !Mekanism.latestVersionNumber.equals("null"))
			{
				writeText(EnumColor.INDIGO + "Mekanism" + module.getName() + (module.getVersion().comparedState(Version.get(Mekanism.latestVersionNumber)) == -1 ? EnumColor.DARK_RED : EnumColor.GREY) + " " + module.getVersion(), size);
			}
			else {
				writeText(EnumColor.INDIGO + "Mekanism" + module.getName() + EnumColor.GREY + " " + module.getVersion(), size);
			}
		}

		writeText(EnumColor.GREY + "Newest version: " + Mekanism.latestVersionNumber, size+9);
		writeText(EnumColor.GREY + "*Developed on Mac OS X 10.8 Mountain Lion", size+18);
		writeText(EnumColor.GREY + "*Code, textures, and ideas by aidancbrady", size+27);
		writeText(EnumColor.GREY + "Recent news: " + EnumColor.DARK_BLUE + (!Mekanism.recentNews.contains("null") ? Mekanism.recentNews : "couldn't access."), size+36);
		writeText(EnumColor.GREY + updateProgress, size+45);

		super.func_73863_a(mouseX, mouseY, partialTick);
	}
}
