package mekanism.client.gui;

import java.util.ArrayList;
import java.util.List;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.OreGas;
import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGasGauge.IGasInfoHandler;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiProgress.IProgressInfoHandler;
import mekanism.client.gui.element.GuiProgress.ProgressBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiSlot.SlotOverlay;
import mekanism.client.gui.element.GuiSlot.SlotType;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerChemicalCrystallizer;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiChemicalCrystallizer extends GuiMekanism
{
	public TileEntityChemicalCrystallizer tileEntity;

	public Gas prevGas;

	public ItemStack renderStack = ItemStack.field_190927_a;

	public int stackSwitch = 0;

	public int stackIndex = 0;

	public List<ItemStack> iterStacks = new ArrayList<ItemStack>();

	public GuiChemicalCrystallizer(InventoryPlayer inventory, TileEntityChemicalCrystallizer tentity)
	{
		super(tentity, new ContainerChemicalCrystallizer(inventory, tentity));
		tileEntity = tentity;

		guiElements.add(new GuiSecurityTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png")));
		guiElements.add(new GuiRedstoneControl(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png")));
		guiElements.add(new GuiUpgradeTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png")));
		guiElements.add(new GuiPowerBar(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png"), 160, 23));
		guiElements.add(new GuiSideConfigurationTab(this, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png")));
		guiElements.add(new GuiTransporterConfigTab(this, 34, tileEntity, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png")));
		guiElements.add(new GuiEnergyInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				String multiplier = MekanismUtils.getEnergyDisplay(tileEntity.energyPerTick);
				return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(tileEntity.getMaxEnergy()-tileEntity.getEnergy()));
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png")));
		guiElements.add(new GuiGasGauge(new IGasInfoHandler() {
			@Override
			public GasTank getTank()
			{
				return tileEntity.inputTank;
			}
		}, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png"), 5, 4));
		guiElements.add(new GuiSlot(SlotType.EXTRA, this, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png"), 5, 64).with(SlotOverlay.PLUS));
		guiElements.add(new GuiSlot(SlotType.POWER, this, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png"), 154, 4).with(SlotOverlay.POWER));
		guiElements.add(new GuiSlot(SlotType.OUTPUT, this, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png"), 130, 56));

		guiElements.add(new GuiProgress(new IProgressInfoHandler()
		{
			@Override
			public double getProgress()
			{
				return tileEntity.getScaledProgress();
			}
		}, ProgressBar.LARGE_RIGHT, this, MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png"), 51, 60));
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		field_146289_q.func_78276_b(tileEntity.func_70005_c_(), 37, 4, 0x404040);

		if(tileEntity.inputTank.getGas() != null)
		{
			field_146289_q.func_78276_b(tileEntity.inputTank.getGas().getGas().getLocalizedName(), 29, 15, 0x00CD00);

			if(tileEntity.inputTank.getGas().getGas() instanceof OreGas)
			{
				field_146289_q.func_78276_b("(" + ((OreGas)tileEntity.inputTank.getGas().getGas()).getOreName() + ")", 29, 24, 0x00CD00);
			}
			else {
				CrystallizerRecipe recipe = tileEntity.getRecipe();
				
				if(recipe == null)
				{
					field_146289_q.func_78276_b("(" + LangUtils.localize("gui.noRecipe") + ")", 29, 24, 0x00CD00);
				}
				else {
					field_146289_q.func_78276_b("(" + recipe.recipeOutput.output.func_82833_r() + ")", 29, 24, 0x00CD00);
				}
			}
		}

		if(!renderStack.func_190926_b())
		{
			try {
				GlStateManager.func_179094_E();
				RenderHelper.func_74520_c();
				field_146296_j.func_180450_b(renderStack, 131, 14);
				RenderHelper.func_74518_a();
				GlStateManager.func_179121_F();
			} catch(Exception e) {}
		}

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiChemicalCrystallizer.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);

		super.func_146976_a(partialTick, mouseX, mouseY);
	}

	private Gas getInputGas()
	{
		return tileEntity.inputTank.getGas() != null ? tileEntity.inputTank.getGas().getGas() : null;
	}

	private void resetStacks()
	{
		iterStacks.clear();
		renderStack = ItemStack.field_190927_a;
		stackSwitch = 0;
		stackIndex = -1;
	}

	@Override
	public void func_73876_c()
	{
		super.func_73876_c();

		if(prevGas != getInputGas())
		{
			prevGas = getInputGas();

			boolean reset = false;

			if(prevGas == null || !(prevGas instanceof OreGas) || !((OreGas)prevGas).isClean())
			{
				reset = true;
				resetStacks();
			}

			if(!reset)
			{
				OreGas gas = (OreGas)prevGas;
				String oreDictName = "ore" + gas.getName().substring(5);

				updateStackList(oreDictName);
			}
		}

		if(stackSwitch > 0)
		{
			stackSwitch--;
		}

		if(stackSwitch == 0 && iterStacks != null && iterStacks.size() > 0)
		{
			stackSwitch = 20;

			if(stackIndex == -1 || stackIndex == iterStacks.size()-1)
			{
				stackIndex = 0;
			}
			else if(stackIndex < iterStacks.size()-1)
			{
				stackIndex++;
			}

			renderStack = iterStacks.get(stackIndex);
		}
		else if(iterStacks != null && iterStacks.size() == 0)
		{
			renderStack = ItemStack.field_190927_a;
		}
	}

	private void updateStackList(String oreName)
	{
		if(iterStacks == null)
		{
			iterStacks = new ArrayList<ItemStack>();
		}
		else {
			iterStacks.clear();
		}

		List<String> keys = new ArrayList<String>();

		for(String s : OreDictionary.getOreNames())
		{
			if(oreName.equals(s) || oreName.equals("*"))
			{
				keys.add(s);
			}
			else if(oreName.endsWith("*") && !oreName.startsWith("*"))
			{
				if(s.startsWith(oreName.substring(0, oreName.length()-1)))
				{
					keys.add(s);
				}
			}
			else if(oreName.startsWith("*") && !oreName.endsWith("*"))
			{
				if(s.endsWith(oreName.substring(1)))
				{
					keys.add(s);
				}
			}
			else if(oreName.startsWith("*") && oreName.endsWith("*"))
			{
				if(s.contains(oreName.substring(1, oreName.length()-1)))
				{
					keys.add(s);
				}
			}
		}

		for(String key : keys)
		{
			for(ItemStack stack : OreDictionary.getOres(key))
			{
				ItemStack toAdd = stack.func_77946_l();

				if(!iterStacks.contains(stack) && toAdd.func_77973_b() instanceof ItemBlock)
				{
					iterStacks.add(stack.func_77946_l());
				}
			}
		}

		stackSwitch = 0;
		stackIndex = -1;
	}
}
