package mekanism.client.gui;

import java.util.List;

import mekanism.client.gui.element.GuiBoilerTab;
import mekanism.client.gui.element.GuiBoilerTab.BoilerTab;
import mekanism.client.gui.element.GuiElement.IInfoHandler;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.GuiGraph.GraphDataHandler;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.MekanismUtils.ResourceType;
import mekanism.common.util.UnitDisplayUtils.TemperatureUnit;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class GuiBoilerStats extends GuiMekanism
{
	public TileEntityBoilerCasing tileEntity;
	
	public GuiGraph boilGraph;
	public GuiGraph maxGraph;

	public GuiBoilerStats(InventoryPlayer inventory, TileEntityBoilerCasing tentity)
	{
		super(tentity, new ContainerNull(inventory.field_70458_d, tentity));
		tileEntity = tentity;
		guiElements.add(new GuiBoilerTab(this, tileEntity, BoilerTab.MAIN, 6, MekanismUtils.getResource(ResourceType.GUI, "GuiBoilerStats.png")));
		guiElements.add(new GuiHeatInfo(new IInfoHandler() {
			@Override
			public List<String> getInfo()
			{
				TemperatureUnit unit = TemperatureUnit.values()[general.tempUnit.ordinal()];
				String environment = UnitDisplayUtils.getDisplayShort(tileEntity.structure.lastEnvironmentLoss*unit.intervalSize, false, unit);
				return ListUtils.asList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
			}
		}, this, MekanismUtils.getResource(ResourceType.GUI, "GuiBoilerStats.png")));
		guiElements.add(boilGraph = new GuiGraph(this, MekanismUtils.getResource(ResourceType.GUI, "GuiBoilerStats.png"), 8, 83, 160, 36, new GraphDataHandler() {
			@Override
			public String getDataDisplay(int data)
			{
				return LangUtils.localize("gui.boilRate") + ": " + data + " mB/t";
			}
		}));
		guiElements.add(maxGraph = new GuiGraph(this, MekanismUtils.getResource(ResourceType.GUI, "GuiBoilerStats.png"), 8, 122, 160, 36, new GraphDataHandler() {
			@Override
			public String getDataDisplay(int data)
			{
				return LangUtils.localize("gui.maxBoil") + ": " + data + " mB/t";
			}
		}));
		maxGraph.enableFixedScale((int)((tentity.structure.superheatingElements*general.superheatingHeatTransfer)/SynchronizedBoilerData.getHeatEnthalpy()));
	}
	
	@Override
	protected void func_146979_b(int mouseX, int mouseY)
	{
		int xAxis = (mouseX - (field_146294_l - field_146999_f) / 2);
		int yAxis = (mouseY - (field_146295_m - field_147000_g) / 2);

		String stats = LangUtils.localize("gui.boilerStats");
		
		field_146289_q.func_78276_b(stats, (field_146999_f/2)-(field_146289_q.func_78256_a(stats)/2), 6, 0x404040);
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.maxWater") + ": " + tileEntity.clientWaterCapacity + " mB", 8, 26, 0x404040);
		field_146289_q.func_78276_b(LangUtils.localize("gui.maxSteam") + ": " + tileEntity.clientSteamCapacity + " mB", 8, 35, 0x404040);
		
		field_146289_q.func_78276_b(LangUtils.localize("gui.heatTransfer"), 8, 49, 0x797979);
		field_146289_q.func_78276_b(LangUtils.localize("gui.superheaters") + ": " + tileEntity.structure.superheatingElements, 14, 58, 0x404040);
		
		int boilCapacity = (int)((tileEntity.structure.superheatingElements*general.superheatingHeatTransfer)/SynchronizedBoilerData.getHeatEnthalpy());
		field_146289_q.func_78276_b(LangUtils.localize("gui.boilCapacity") + ": " + boilCapacity + " mB/t", 8, 72, 0x404040);
		
		super.func_146979_b(mouseX, mouseY);
	}
	
	@Override
	public void func_73876_c()
	{
		super.func_73876_c();
		
		boilGraph.addData(tileEntity.structure.lastBoilRate);
		maxGraph.addData(tileEntity.structure.lastMaxBoil);
	}
	
	@Override
	protected void func_146976_a(float partialTick, int mouseX, int mouseY)
	{
		field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(ResourceType.GUI, "GuiBoilerStats.png"));
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int guiWidth = (field_146294_l - field_146999_f) / 2;
		int guiHeight = (field_146295_m - field_147000_g) / 2;
		func_73729_b(guiWidth, guiHeight, 0, 0, field_146999_f, field_147000_g);
		
		super.func_146976_a(partialTick, mouseX, mouseY);
	}
}
