package mekanism.client.entity;

import mekanism.api.Pos3D;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class ParticleLaser extends Particle
{
	double length;
	EnumFacing direction;

	public ParticleLaser(World world, Pos3D start, Pos3D end, EnumFacing dir, double energy)
	{
		super(world, (start.field_72450_a + end.field_72450_a)/2D, (start.field_72448_b + end.field_72448_b)/2D, (start.field_72449_c+end.field_72449_c)/2D);
		field_70547_e = 5;
		field_70552_h = 1;
		field_70553_i = 0;
		field_70551_j = 0;
		field_82339_as = 0.1F;
		field_70544_f = (float) Math.min(energy / 50000, 0.6);
		length = end.distance(start);
		direction = dir;
		field_187119_C = MekanismRenderer.laserIcon;
	}

	@Override
	public void func_180434_a(VertexBuffer worldRendererIn, Entity entityIn, float partialTicks, float p_180434_4_, float p_180434_5_, float p_180434_6_, float p_180434_7_, float p_180434_8_)
	{
		Tessellator tessellator = Tessellator.func_178181_a();
		
		tessellator.func_78381_a();
        
		GlStateManager.func_179094_E();
		GL11.glPushAttrib(GL11.GL_POLYGON_BIT + GL11.GL_ENABLE_BIT);
		GL11.glDisable(GL11.GL_CULL_FACE);
		MekanismRenderer.glowOn();
		
		float newX = (float)(field_187123_c + (field_187126_f - field_187123_c) * (double)partialTicks - field_70556_an);
		float newY = (float)(field_187124_d + (field_187127_g - field_187124_d) * (double)partialTicks - field_70554_ao);
		float newZ = (float)(field_187125_e + (field_187128_h - field_187125_e) * (double)partialTicks - field_70555_ap);

		GlStateManager.func_179109_b(newX, newY, newZ);
		
		switch(direction)
		{
			case UP:
			case DOWN:
			default:
				break;
			case WEST:
			case EAST:
				GlStateManager.func_179114_b(90, 0, 0, 1);
				break;
			case NORTH:
			case SOUTH:
				GlStateManager.func_179114_b(90, 1, 0, 0);
				break;
		}
		
		float uMin = field_187119_C.func_94214_a(0);
		float uMax = field_187119_C.func_94214_a(16);
		float vMin = field_187119_C.func_94207_b(0);
		float vMax = field_187119_C.func_94207_b(16);
		
		GlStateManager.func_179114_b(45, 0, 1, 0);
		worldRendererIn.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181704_d);
		worldRendererIn.func_181662_b(-field_70544_f, -length/2, 0).func_187315_a(uMin, vMin).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		worldRendererIn.func_181662_b(-field_70544_f, length/2, 0).func_187315_a(uMin, vMax).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		worldRendererIn.func_181662_b(field_70544_f, length/2, 0).func_187315_a(uMax, vMax).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		worldRendererIn.func_181662_b(field_70544_f, -length/2, 0).func_187315_a(uMax, vMin).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		tessellator.func_78381_a();

		GlStateManager.func_179114_b(90, 0, 1, 0);
		worldRendererIn.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181704_d);
		worldRendererIn.func_181662_b(-field_70544_f, -length/2, 0).func_187315_a(uMin, vMin).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		worldRendererIn.func_181662_b(-field_70544_f, length/2, 0).func_187315_a(uMin, vMax).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		worldRendererIn.func_181662_b(field_70544_f, length/2, 0).func_187315_a(uMax, vMax).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		worldRendererIn.func_181662_b(field_70544_f, -length/2, 0).func_187315_a(uMax, vMin).func_181666_a(field_70552_h, field_70553_i, field_70551_j, field_82339_as).func_187314_a(240, 240).func_181675_d();
		tessellator.func_78381_a();
		
		MekanismRenderer.glowOff();
		GL11.glPopAttrib();
		GlStateManager.func_179121_F();
		
		worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_181704_d);
	}

	@Override
	public int func_70537_b()
	{
		return 1;
	}
}
