package mekanism.client;

import static mekanism.client.sound.SoundHandler.Channel.FLAMETHROWER;
import static mekanism.client.sound.SoundHandler.Channel.GASMASK;
import static mekanism.client.sound.SoundHandler.Channel.JETPACK;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;
import java.util.Set;

import mekanism.api.IClientTicker;
import mekanism.api.gas.GasStack;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.ObfuscatedNames;
import mekanism.common.config.MekanismConfig.client;
import mekanism.common.config.MekanismConfig.general;
import mekanism.common.frequency.Frequency;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemConfigurator.ConfiguratorMode;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemJetpack.JetpackMode;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketFlamethrowerData.FlamethrowerDataMessage;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack.ItemStackMessage;
import mekanism.common.network.PacketJetpackData.JetpackDataMessage;
import mekanism.common.network.PacketJetpackData.JetpackPacket;
import mekanism.common.network.PacketPortableTeleporter.PortableTeleporterMessage;
import mekanism.common.network.PacketPortableTeleporter.PortableTeleporterPacketType;
import mekanism.common.network.PacketScubaTankData.ScubaTankDataMessage;
import mekanism.common.network.PacketScubaTankData.ScubaTankPacket;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.ReflectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent.ClientTickEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent.Phase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;

/**
 * Client-side tick handler for Mekanism. Used mainly for the update check upon startup.
 * @author AidanBrady
 *
 */
@SideOnly(Side.CLIENT)
public class ClientTickHandler
{
	public boolean hasNotified = false;
	public boolean initHoliday = false;

	public boolean preloadedSounds = false;

	public boolean lastTickUpdate;

	public boolean shouldReset = false;

	public static Minecraft mc = FMLClientHandler.instance().getClient();
	public static Random rand = new Random();

	public static final String MIKE_CAPE = "https://dl.dropboxusercontent.com/s/ji06yflixnszcby/cape.png";
	public static final String DONATE_CAPE = "https://dl.dropboxusercontent.com/u/90411166/donate.png";
	public static final String AIDAN_CAPE = "https://dl.dropboxusercontent.com/u/90411166/aidan.png";

	private Map<String, CapeBufferDownload> mikeDownload = new HashMap<String, CapeBufferDownload>();
	private Map<String, CapeBufferDownload> donateDownload = new HashMap<String, CapeBufferDownload>();
	private Map<String, CapeBufferDownload> aidanDownload = new HashMap<String, CapeBufferDownload>();

	public static Set<IClientTicker> tickingSet = new HashSet<IClientTicker>();
	public static Map<EntityPlayer, TeleportData> portableTeleports = new HashMap<>();
	
	public static int wheelStatus = 0;

	@SubscribeEvent
	public void onTick(ClientTickEvent event)
	{
		if(event.phase == Phase.START)
		{
			tickStart();
		}
	}

	public void tickStart()
	{
		MekanismClient.ticksPassed++;

		if(!hasNotified && mc.field_71441_e != null && Mekanism.latestVersionNumber != null && Mekanism.recentNews != null)
		{
			MekanismUtils.checkForUpdates(mc.field_71439_g);
			hasNotified = true;
		}

		if(!Mekanism.proxy.isPaused())
		{
			for(Iterator<IClientTicker> iter = tickingSet.iterator(); iter.hasNext();)
			{
				IClientTicker ticker = iter.next();

				if(ticker.needsTicks())
				{
					ticker.clientTick();
				}
				else {
					iter.remove();
				}
			}
		}

		if(mc.field_71441_e != null)
		{
			shouldReset = true;
		}
		else if(shouldReset)
		{
			MekanismClient.reset();
			shouldReset = false;
		}

		if(mc.field_71441_e != null && mc.field_71439_g != null && !Mekanism.proxy.isPaused())
		{
			if((!initHoliday || MekanismClient.ticksPassed % 1200 == 0) && mc.field_71439_g != null)
			{
				HolidayManager.check();
				initHoliday = true;
			}

			for(EntityPlayer entityPlayer : mc.field_71441_e.field_73010_i)
			{
				if(entityPlayer instanceof AbstractClientPlayer)
				{
					AbstractClientPlayer player = (AbstractClientPlayer)entityPlayer;

					if(StringUtils.func_76338_a(player.func_70005_c_()).equals("mikeacttck"))
					{
						CapeBufferDownload download = mikeDownload.get(player.func_70005_c_());

						if(download == null)
						{
							download = new CapeBufferDownload(player.func_70005_c_(), MIKE_CAPE);
							mikeDownload.put(player.func_70005_c_(), download);

							download.start();
						}
						else {
							if(!download.downloaded)
							{
								continue;
							}
							
							setCape(player, download.getResourceLocation());
						}
					}
					else if(StringUtils.func_76338_a(player.func_70005_c_()).equals("aidancbrady"))
					{
						CapeBufferDownload download = aidanDownload.get(player.func_70005_c_());

						if(download == null)
						{
							download = new CapeBufferDownload(player.func_70005_c_(), AIDAN_CAPE);
							aidanDownload.put(player.func_70005_c_(), download);

							download.start();
						}
						else {
							if(!download.downloaded)
							{
								continue;
							}
							
							setCape(player, download.getResourceLocation());
						}
					}
					else if(Mekanism.donators.contains(StringUtils.func_76338_a(player.func_70005_c_())))
					{
						CapeBufferDownload download = donateDownload.get(player.func_70005_c_());

						if(download == null)
						{
							download = new CapeBufferDownload(player.func_70005_c_(), DONATE_CAPE);
							donateDownload.put(player.func_70005_c_(), download);

							download.start();
						}
						else {
							if(!download.downloaded)
							{
								continue;
							}
							
							setCape(player, download.getResourceLocation());
						}
					}
				}
			}

			if(Mekanism.freeRunnerOn.contains(mc.field_71439_g.func_70005_c_()) != isFreeRunnerOn(mc.field_71439_g))
			{
				if(isFreeRunnerOn(mc.field_71439_g) && mc.field_71462_r == null)
				{
					Mekanism.freeRunnerOn.add(mc.field_71439_g.func_70005_c_());
				}
				else
				{
					Mekanism.freeRunnerOn.remove(mc.field_71439_g.func_70005_c_());
				}

				Mekanism.packetHandler.sendToServer(new PacketFreeRunnerData.FreeRunnerDataMessage(PacketFreeRunnerData.FreeRunnerPacket.UPDATE, mc.field_71439_g.func_70005_c_(), isFreeRunnerOn(mc.field_71439_g)));
			}

			ItemStack bootStack = mc.field_71439_g.func_184582_a(EntityEquipmentSlot.FEET);

			if(!bootStack.func_190926_b() && bootStack.func_77973_b() instanceof ItemFreeRunners && isFreeRunnerOn(mc.field_71439_g))
			{
				mc.field_71439_g.field_70138_W = 1.002F;
			}
			else {
				if(mc.field_71439_g.field_70138_W == 1.002F)
				{
					mc.field_71439_g.field_70138_W = 0.5F;
				}
			}
			
			if(Mekanism.flamethrowerActive.contains(mc.field_71439_g.func_70005_c_()) != isFlamethrowerOn(mc.field_71439_g))
			{
				if(isFlamethrowerOn(mc.field_71439_g))
				{
					Mekanism.flamethrowerActive.add(mc.field_71439_g.func_70005_c_());
				}
				else {
					Mekanism.flamethrowerActive.remove(mc.field_71439_g.func_70005_c_());
				}
				
				Mekanism.packetHandler.sendToServer(new FlamethrowerDataMessage(PacketFlamethrowerData.FlamethrowerPacket.UPDATE, null, mc.field_71439_g.func_70005_c_(), isFlamethrowerOn(mc.field_71439_g)));
			}

			if(Mekanism.jetpackOn.contains(mc.field_71439_g.func_70005_c_()) != isJetpackOn(mc.field_71439_g))
			{
				if(isJetpackOn(mc.field_71439_g))
				{
					Mekanism.jetpackOn.add(mc.field_71439_g.func_70005_c_());
				}
				else {
					Mekanism.jetpackOn.remove(mc.field_71439_g.func_70005_c_());
				}

				Mekanism.packetHandler.sendToServer(new JetpackDataMessage(JetpackPacket.UPDATE, mc.field_71439_g.func_70005_c_(), isJetpackOn(mc.field_71439_g)));
			}

			if(Mekanism.gasmaskOn.contains(mc.field_71439_g.func_70005_c_()) != isGasMaskOn(mc.field_71439_g))
			{
				if(isGasMaskOn(mc.field_71439_g) && mc.field_71462_r == null)
				{
					Mekanism.gasmaskOn.add(mc.field_71439_g.func_70005_c_());
				}
				else {
					Mekanism.gasmaskOn.remove(mc.field_71439_g.func_70005_c_());
				}

				Mekanism.packetHandler.sendToServer(new ScubaTankDataMessage(ScubaTankPacket.UPDATE, mc.field_71439_g.func_70005_c_(), isGasMaskOn(mc.field_71439_g)));
			}

			if(client.enablePlayerSounds)
			{
				for(String username : Mekanism.jetpackOn)
				{
					EntityPlayer player = mc.field_71441_e.func_72924_a(username);

					if(player != null)
					{
						if(!SoundHandler.soundPlaying(player, JETPACK))
						{
							SoundHandler.addSound(player, JETPACK, client.replaceSoundsWhenResuming);
						}

						SoundHandler.playSound(player, JETPACK);
					}
				}

				for(String username : Mekanism.gasmaskOn)
				{
					EntityPlayer player = mc.field_71441_e.func_72924_a(username);

					if(player != null)
					{
						if(!SoundHandler.soundPlaying(player, GASMASK))
						{
							SoundHandler.addSound(player, GASMASK, client.replaceSoundsWhenResuming);
						}
						
						SoundHandler.playSound(player, GASMASK);
					}
				}

				for(EntityPlayer player : (List<EntityPlayer>)mc.field_71441_e.field_73010_i)
				{
					if(hasFlamethrower(player))
					{
						if(!SoundHandler.soundPlaying(player, FLAMETHROWER))
						{
							SoundHandler.addSound(player, FLAMETHROWER, client.replaceSoundsWhenResuming);
						}
						
						SoundHandler.playSound(player, FLAMETHROWER);
					}
				}
			}
			
			for(Iterator<Entry<EntityPlayer, TeleportData>> iter = portableTeleports.entrySet().iterator(); iter.hasNext();)
			{
				Entry<EntityPlayer, TeleportData> entry = iter.next();
				
				for(int i = 0; i < 100; i++)
				{
					double x = entry.getKey().field_70165_t + rand.nextDouble()-0.5D;
					double y = entry.getKey().field_70163_u + rand.nextDouble()*2-2D;
					double z = entry.getKey().field_70161_v + rand.nextDouble()-0.5D;
					
					mc.field_71441_e.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, 0, 1, 0);
				}
				
				if(mc.field_71441_e.func_72820_D() == entry.getValue().teleportTime)
				{
					Mekanism.packetHandler.sendToServer(new PortableTeleporterMessage(PortableTeleporterPacketType.TELEPORT, entry.getValue().hand, entry.getValue().freq));
					iter.remove();
				}
			}

			ItemStack chestStack = mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
			
			if(!chestStack.func_190926_b() && chestStack.func_77973_b() instanceof ItemJetpack)
			{
				MekanismClient.updateKey(mc.field_71474_y.field_74314_A, KeySync.ASCEND);
				MekanismClient.updateKey(mc.field_71474_y.field_74311_E, KeySync.DESCEND);
			}
			
			if(isFlamethrowerOn(mc.field_71439_g))
			{
				ItemFlamethrower flamethrower = (ItemFlamethrower)mc.field_71439_g.field_71071_by.func_70448_g().func_77973_b();
				
				if(!mc.field_71439_g.field_71075_bZ.field_75098_d)
				{
					flamethrower.useGas(mc.field_71439_g.field_71071_by.func_70448_g());
				}
			}
			
			if(isJetpackOn(mc.field_71439_g))
			{
				ItemJetpack jetpack = (ItemJetpack)chestStack.func_77973_b();

				if(jetpack.getMode(chestStack) == JetpackMode.NORMAL)
				{
					mc.field_71439_g.field_70181_x = Math.min(mc.field_71439_g.field_70181_x + 0.15D, 0.5D);
					mc.field_71439_g.field_70143_R = 0.0F;
				}
				else if(jetpack.getMode(chestStack) == JetpackMode.HOVER)
				{
					if((!mc.field_71474_y.field_74314_A.func_151470_d() && !mc.field_71474_y.field_74311_E.func_151470_d()) || (mc.field_71474_y.field_74314_A.func_151470_d() && mc.field_71474_y.field_74311_E.func_151470_d()) || mc.field_71462_r != null)
					{
						if(mc.field_71439_g.field_70181_x > 0)
						{
							mc.field_71439_g.field_70181_x = Math.max(mc.field_71439_g.field_70181_x - 0.15D, 0);
						}
						else if(mc.field_71439_g.field_70181_x < 0)
						{
							if(!CommonPlayerTickHandler.isOnGround(mc.field_71439_g))
							{
								mc.field_71439_g.field_70181_x = Math.min(mc.field_71439_g.field_70181_x + 0.15D, 0);
							}
						}
					}
					else {
						if(mc.field_71474_y.field_74314_A.func_151470_d() && mc.field_71462_r == null)
						{
							mc.field_71439_g.field_70181_x = Math.min(mc.field_71439_g.field_70181_x + 0.15D, 0.2D);
						}
						else if(mc.field_71474_y.field_74311_E.func_151470_d() && mc.field_71462_r == null)
						{
							if(!CommonPlayerTickHandler.isOnGround(mc.field_71439_g))
							{
								mc.field_71439_g.field_70181_x = Math.max(mc.field_71439_g.field_70181_x - 0.15D, -0.2D);
							}
						}
					}

					mc.field_71439_g.field_70143_R = 0.0F;
				}

				jetpack.useGas(chestStack);
			}

			if(isGasMaskOn(mc.field_71439_g))
			{
				ItemScubaTank tank = (ItemScubaTank)chestStack.func_77973_b();

				final int max = 300;
				
				tank.useGas(chestStack);
				GasStack received = tank.useGas(chestStack, max-mc.field_71439_g.func_70086_ai());

				if(received != null)
				{
					mc.field_71439_g.func_70050_g(mc.field_71439_g.func_70086_ai()+received.amount);
				}
				
				if(mc.field_71439_g.func_70086_ai() == max)
				{
					for(Object obj : mc.field_71439_g.func_70651_bq())
					{
						if(obj instanceof PotionEffect)
						{
							for(int i = 0; i < 9; i++)
							{
								((PotionEffect)obj).func_76455_a(mc.field_71439_g);
							}
						}
					}
				}
			}
		}
	}
	
	@SubscribeEvent
	public void onMouseEvent(MouseEvent event)
	{
		if(client.allowConfiguratorModeScroll && mc.field_71439_g != null && mc.field_71439_g.func_70093_af())
		{
			ItemStack stack = mc.field_71439_g.func_184614_ca();
			int delta = event.getDwheel();
			
			if(stack.func_77973_b() instanceof ItemConfigurator && delta != 0)
			{
				ItemConfigurator configurator = (ItemConfigurator)stack.func_77973_b();
				RenderTickHandler.modeSwitchTimer = 100;
				
				wheelStatus += event.getDwheel();
				int scaledDelta = wheelStatus/120;
				wheelStatus = wheelStatus % 120;
				int newVal = configurator.getState(stack).ordinal() + (scaledDelta % ConfiguratorMode.values().length);
				
				if(newVal > 0)
				{
					newVal = newVal % ConfiguratorMode.values().length;
				}
				else if(newVal < 0) 
				{
					newVal = ConfiguratorMode.values().length + newVal;
				}
				
				configurator.setState(stack, ConfiguratorMode.values()[newVal]);
				Mekanism.packetHandler.sendToServer(new ItemStackMessage(EnumHand.MAIN_HAND, ListUtils.asArrayList(newVal)));
				event.setCanceled(true);
			}
		}
	}
	
	public static void setCape(AbstractClientPlayer player, ResourceLocation cape)
	{
		try {
			Method m = ReflectionUtils.getPrivateMethod(AbstractClientPlayer.class, ObfuscatedNames.AbstractClientPlayer_getPlayerInfo);
			Object obj = m.invoke(player);
			
			if(obj instanceof NetworkPlayerInfo)
			{
				NetworkPlayerInfo info = (NetworkPlayerInfo)obj;
				Map<MinecraftProfileTexture.Type, ResourceLocation> map = (Map<MinecraftProfileTexture.Type, ResourceLocation>)ReflectionUtils.getPrivateValue(info, NetworkPlayerInfo.class, ObfuscatedNames.NetworkPlayerInfo_playerTextures);
				map.put(MinecraftProfileTexture.Type.CAPE, cape);
			}
		} catch(Exception e) {}
	}

	public static void killDeadNetworks()
	{
		for(Iterator<IClientTicker> iter = tickingSet.iterator(); iter.hasNext();)
		{
			if(!iter.next().needsTicks())
			{
				iter.remove();
			}
		}
	}

	public static boolean isJetpackOn(EntityPlayer player)
	{
		if(player != mc.field_71439_g)
		{
			return Mekanism.jetpackOn.contains(player.func_70005_c_());
		}

		ItemStack stack = player.field_71071_by.field_70460_b.get(2);

		if(!stack.func_190926_b() && !player.field_71075_bZ.field_75098_d)
		{
			if(stack.func_77973_b() instanceof ItemJetpack)
			{
				ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();

				if(jetpack.getGas(stack) != null)
				{
					if((mc.field_71474_y.field_74314_A.func_151470_d() && jetpack.getMode(stack) == JetpackMode.NORMAL) && mc.field_71462_r == null)
					{
						return true;
					}
					else if(jetpack.getMode(stack) == JetpackMode.HOVER)
					{
						if((!mc.field_71474_y.field_74314_A.func_151470_d() && !mc.field_71474_y.field_74311_E.func_151470_d()) || (mc.field_71474_y.field_74314_A.func_151470_d() && mc.field_71474_y.field_74311_E.func_151470_d()) || mc.field_71462_r != null)
						{
							return !CommonPlayerTickHandler.isOnGround(player);
						}
						else if(mc.field_71474_y.field_74311_E.func_151470_d() && mc.field_71462_r == null)
						{
							return !CommonPlayerTickHandler.isOnGround(player);
						}
						
						return true;
					}
				}
			}
		}

		return false;
	}

	public static boolean isGasMaskOn(EntityPlayer player)
	{
		if(player != mc.field_71439_g)
		{
			return Mekanism.gasmaskOn.contains(player.func_70005_c_());
		}

		ItemStack tank = player.field_71071_by.field_70460_b.get(2);
		ItemStack mask = player.field_71071_by.field_70460_b.get(3);

		if(!tank.func_190926_b() && !mask.func_190926_b())
		{
			if(tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemGasMask)
			{
				ItemScubaTank scubaTank = (ItemScubaTank)tank.func_77973_b();

				if(scubaTank.getGas(tank) != null)
				{
					if(scubaTank.getFlowing(tank))
					{
						return true;
					}
				}
			}
		}

		return false;
	}

	public static boolean isFreeRunnerOn(EntityPlayer player)
	{
		if(player != mc.field_71439_g)
		{
			return Mekanism.freeRunnerOn.contains(player.func_70005_c_());
		}

		ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);

		if(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFreeRunners)
		{
			ItemFreeRunners freeRunners = (ItemFreeRunners) stack.func_77973_b();

			if(/*freeRunners.getEnergy(stack) > 0 && */freeRunners.getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL)
			{
				return true;
			}
		}

		return false;
	}
	
	public static boolean isFlamethrowerOn(EntityPlayer player)
	{
		if(player != mc.field_71439_g)
		{
			return Mekanism.flamethrowerActive.contains(player.func_70005_c_());
		}
		
		if(hasFlamethrower(player))
		{
			if(mc.field_71474_y.field_74313_G.func_151470_d())
			{
				return true;
			}
		}
		
		return false;
	}
	
	public static boolean hasFlamethrower(EntityPlayer player)
	{
		if(!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemFlamethrower)
		{
			ItemFlamethrower flamethrower = (ItemFlamethrower)player.field_71071_by.func_70448_g().func_77973_b();
			
			if(flamethrower.getGas(player.field_71071_by.func_70448_g()) != null)
			{
				return true;
			}
		}
		
		return false;
	}
	
	public static void portableTeleport(EntityPlayer player, EnumHand hand, Frequency freq)
	{
		if(general.portableTeleporterDelay == 0)
		{
			Mekanism.packetHandler.sendToServer(new PortableTeleporterMessage(PortableTeleporterPacketType.TELEPORT, hand, freq));
		}
		else {
			portableTeleports.put(player, new TeleportData(hand, freq, mc.field_71441_e.func_72820_D()+general.portableTeleporterDelay));
		}
	}
	
	private static class TeleportData
	{
		private EnumHand hand;
		private Frequency freq;
		private long teleportTime;
		
		public TeleportData(EnumHand h, Frequency f, long t)
		{
			hand = h;
			freq = f;
			teleportTime = t;
		}
	}
}
