/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.voice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemWalkieTalkie;
import mekanism.common.voice.VoiceServerManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class VoiceConnection
extends Thread {
    public Socket socket;
    public String username;
    public boolean open = true;
    public DataInputStream input;
    public DataOutputStream output;
    public MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();

    public VoiceConnection(Socket s) {
        this.socket = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            VoiceServerManager voiceServerManager = Mekanism.voiceManager;
            synchronized (voiceServerManager) {
                int retryCount = 0;
                while (this.username == null && retryCount <= 100) {
                    try {
                        List l = Collections.synchronizedList((List)((ArrayList)this.server.func_184103_al().func_181057_v()).clone());
                        for (Object obj : l) {
                            if (!(obj instanceof EntityPlayerMP)) continue;
                            EntityPlayerMP playerMP = (EntityPlayerMP)obj;
                            String playerIP = playerMP.func_71114_r();
                            if (!this.server.func_71262_S() && playerIP.equals("local") && !Mekanism.voiceManager.foundLocal) {
                                Mekanism.voiceManager.foundLocal = true;
                                this.username = playerMP.func_70005_c_();
                                break;
                            }
                            if (!playerIP.equals(this.socket.getInetAddress().getHostAddress())) continue;
                            this.username = playerMP.func_70005_c_();
                            break;
                        }
                        ++retryCount;
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                if (this.username == null) {
                    Mekanism.logger.error("VoiceServer: Unable to trace connection's IP address.");
                    this.kill();
                    return;
                }
                Mekanism.logger.info("VoiceServer: Traced IP in " + retryCount + " attempts.");
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while starting server-based connection.");
            e.printStackTrace();
            this.open = false;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (VoiceConnection.this.open) {
                    try {
                        short byteCount = VoiceConnection.this.input.readShort();
                        byte[] audioData = new byte[byteCount];
                        VoiceConnection.this.input.readFully(audioData);
                        if (byteCount <= 0) continue;
                        Mekanism.voiceManager.sendToPlayers(byteCount, audioData, VoiceConnection.this);
                    }
                    catch (Exception e) {
                        VoiceConnection.this.open = false;
                    }
                }
                if (!VoiceConnection.this.open) {
                    VoiceConnection.this.kill();
                }
            }
        }).start();
    }

    public void kill() {
        try {
            this.input.close();
            this.output.close();
            this.socket.close();
            Mekanism.voiceManager.connections.remove(this);
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while stopping server-based connection.");
            e.printStackTrace();
        }
    }

    public void sendToPlayer(short byteCount, byte[] audioData, VoiceConnection connection) {
        if (!this.open) {
            this.kill();
        }
        try {
            this.output.writeShort(byteCount);
            this.output.write(audioData);
            this.output.flush();
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while sending data to player.");
            e.printStackTrace();
        }
    }

    public boolean canListen(int channel) {
        for (ItemStack itemStack : this.getPlayer().field_71071_by.field_70462_a) {
            if (!this.canListen(channel, itemStack)) continue;
            return true;
        }
        for (ItemStack itemStack : this.getPlayer().field_71071_by.field_184439_c) {
            if (!this.canListen(channel, itemStack)) continue;
            return true;
        }
        return false;
    }

    public boolean canListen(int channel, ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemWalkieTalkie && ((ItemWalkieTalkie)itemStack.func_77973_b()).getOn(itemStack) && ((ItemWalkieTalkie)itemStack.func_77973_b()).getChannel(itemStack) == channel;
    }

    public int getCurrentChannel() {
        ItemWalkieTalkie walkieTalkie;
        ItemStack itemStack = this.getPlayer().field_71071_by.func_70448_g();
        if (!itemStack.func_190926_b() && (walkieTalkie = (ItemWalkieTalkie)itemStack.func_77973_b()) != null && walkieTalkie.getOn(itemStack)) {
            return walkieTalkie.getChannel(itemStack);
        }
        return 0;
    }

    public EntityPlayerMP getPlayer() {
        return this.server.func_184103_al().func_152612_a(this.username);
    }
}

