/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import mekanism.api.Coord4D;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyOutputter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.ic2.IC2Integration;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class CableUtils {
    public static boolean isCable(TileEntity tileEntity) {
        if (tileEntity != null && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null)) {
            return TransmissionType.checkTransmissionType(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null), TransmissionType.ENERGY);
        }
        return false;
    }

    public static boolean[] getConnections(TileEntity tileEntity, Function<EnumFacing, Boolean> sideFunction) {
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        Coord4D coord = Coord4D.get(tileEntity);
        for (EnumFacing side : EnumFacing.values()) {
            if (!sideFunction.apply(side).booleanValue()) continue;
            TileEntity tile = coord.offset(side).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            connectable[side.ordinal()] = CableUtils.isValidAcceptorOnSide(tileEntity, tile, side);
            int n = side.ordinal();
            connectable[n] = connectable[n] | CableUtils.isCable(tile);
        }
        return connectable;
    }

    public static boolean isValidAcceptorOnSide(TileEntity cableEntity, TileEntity tile, EnumFacing side) {
        if (tile == null || CableUtils.isCable(tile)) {
            return false;
        }
        return CableUtils.isAcceptor(cableEntity, tile, side) || CableUtils.isOutputter(tile, side) || MekanismUtils.useRF() && tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(side.func_176734_d());
    }

    public static TileEntity[] getConnectedOutputters(TileEntity tileEntity) {
        return CableUtils.getConnectedOutputters(tileEntity.func_174877_v(), tileEntity.func_145831_w());
    }

    public static TileEntity[] getConnectedOutputters(BlockPos pos, World world) {
        TileEntity[] outputters = new TileEntity[]{null, null, null, null, null, null};
        for (EnumFacing orientation : EnumFacing.field_82609_l) {
            TileEntity outputter = world.func_175625_s(pos.func_177972_a(orientation));
            if (!CableUtils.isOutputter(outputter, orientation)) continue;
            outputters[orientation.ordinal()] = outputter;
        }
        return outputters;
    }

    public static boolean isOutputter(TileEntity tileEntity, EnumFacing side) {
        IStrictEnergyOutputter outputter;
        if (tileEntity == null) {
            return false;
        }
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_OUTPUTTER_CAPABILITY, side.func_176734_d()) && (outputter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_OUTPUTTER_CAPABILITY, side.func_176734_d())) != null && outputter.canOutputEnergy(side.func_176734_d())) {
            return true;
        }
        if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_PRODUCER_CAPABILITY, side.func_176734_d())) {
            return true;
        }
        if (MekanismUtils.useForge() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side.func_176734_d())) {
            return ((IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side.func_176734_d())).canExtract();
        }
        if (MekanismUtils.useRF() && tileEntity instanceof IEnergyProvider && ((IEnergyConnection)tileEntity).canConnectEnergy(side.func_176734_d())) {
            return true;
        }
        return MekanismUtils.useIC2() && IC2Integration.isOutputter(tileEntity, side);
    }

    public static boolean isAcceptor(TileEntity orig, TileEntity tileEntity, EnumFacing side) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side.func_176734_d())) {
            if (CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side.func_176734_d()).canReceiveEnergy(side.func_176734_d())) {
                return true;
            }
        } else {
            if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side.func_176734_d())) {
                return true;
            }
            if (MekanismUtils.useForge() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side.func_176734_d())) {
                return ((IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side.func_176734_d())).canReceive();
            }
            if (MekanismUtils.useIC2() && IC2Integration.isAcceptor(orig, tileEntity, side)) {
                return true;
            }
            if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver && ((IEnergyReceiver)tileEntity).canConnectEnergy(side.func_176734_d())) {
                return true;
            }
        }
        return false;
    }

    public static void emit(IEnergyWrapper emitter) {
        double energyToSend;
        if (!((TileEntity)emitter).func_145831_w().field_72995_K && MekanismUtils.canFunction((TileEntity)emitter) && (energyToSend = Math.min(emitter.getEnergy(), emitter.getMaxOutput())) > 0.0) {
            LinkedList<EnumFacing> outputtingSides = new LinkedList<EnumFacing>();
            boolean[] connectable = CableUtils.getConnections((TileEntity)emitter, side -> emitter.sideIsOutput((EnumFacing)side));
            for (EnumFacing side2 : EnumFacing.values()) {
                if (!connectable[side2.ordinal()]) continue;
                outputtingSides.add(side2);
            }
            if (!outputtingSides.isEmpty()) {
                double sent = 0.0;
                boolean tryAgain = false;
                int i = 0;
                do {
                    double prev = sent;
                    tryAgain = energyToSend - (sent += CableUtils.emit_do(emitter, outputtingSides, energyToSend - sent, tryAgain)) > 0.0 && sent - prev > 0.0 && i < 100;
                    ++i;
                } while (tryAgain);
                emitter.setEnergy(emitter.getEnergy() - sent);
            }
        }
    }

    private static double emit_do(IEnergyWrapper emitter, List<EnumFacing> outputtingSides, double totalToSend, boolean tryAgain) {
        double remains = totalToSend % (double)outputtingSides.size();
        double splitSend = (totalToSend - remains) / (double)outputtingSides.size();
        double sent = 0.0;
        Iterator<EnumFacing> it = outputtingSides.iterator();
        while (it.hasNext()) {
            EnumFacing side = it.next();
            TileEntity tileEntity = Coord4D.get((TileEntity)emitter).offset(side).getTileEntity((IBlockAccess)((TileEntity)emitter).func_145831_w());
            double toSend = splitSend + remains;
            remains = 0.0;
            double prev = sent;
            if ((sent += CableUtils.emit_do_do(emitter, tileEntity, side, toSend, tryAgain)) - prev != 0.0) continue;
            it.remove();
        }
        return sent;
    }

    private static double emit_do_do(IEnergyWrapper from, TileEntity tileEntity, EnumFacing side, double currentSending, boolean tryAgain) {
        double sent = 0.0;
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side.func_176734_d())) {
            IStrictEnergyAcceptor acceptor = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side.func_176734_d());
            if (acceptor.canReceiveEnergy(side.func_176734_d())) {
                sent += acceptor.acceptEnergy(side.func_176734_d(), currentSending, false);
            }
        } else if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side.func_176734_d())) {
            ITeslaConsumer consumer = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side.func_176734_d());
            sent += (double)consumer.givePower(Math.round(currentSending * MekanismConfig.general.TO_TESLA), false) * MekanismConfig.general.FROM_TESLA;
        } else if (MekanismUtils.useForge() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side.func_176734_d())) {
            IEnergyStorage storage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side.func_176734_d());
            sent += (double)storage.receiveEnergy((int)Math.round(Math.min(2.147483647E9, currentSending * MekanismConfig.general.TO_FORGE)), false) * MekanismConfig.general.FROM_FORGE;
        } else if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tileEntity;
            if (handler.canConnectEnergy(side.func_176734_d())) {
                int toSend = Math.min((int)Math.round(currentSending * MekanismConfig.general.TO_RF), Integer.MAX_VALUE);
                int used = handler.receiveEnergy(side.func_176734_d(), toSend, false);
                sent += (double)used * MekanismConfig.general.FROM_RF;
            }
        } else if (MekanismUtils.useIC2()) {
            sent += IC2Integration.emitEnergy(from, tileEntity, side, currentSending);
        }
        return sent;
    }
}

