/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Tier;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter<IFluidHandler, FluidNetwork>
implements IFluidHandlerWrapper {
    public Tier.PipeTier tier = Tier.PipeTier.BASIC;
    public float currentScale;
    public FluidTank buffer = new FluidTank(1000);
    public FluidStack lastWrite;
    public CapabilityWrapperManager manager = new CapabilityWrapperManager<IFluidHandlerWrapper, FluidHandlerWrapper>(IFluidHandlerWrapper.class, FluidHandlerWrapper.class);

    @Override
    public Tier.BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public void setBaseTier(Tier.BaseTier baseTier) {
        this.tier = Tier.PipeTier.get(baseTier);
        this.buffer.setCapacity(this.getCapacity());
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateShare();
            IFluidHandler[] connectedAcceptors = PipeUtils.getConnectedAcceptors(this.func_174877_v(), this.func_145831_w());
            for (EnumFacing side : this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)) {
                FluidStack received;
                IFluidHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drain(this.getPullAmount(), false)) == null || received.amount == 0) continue;
                container.drain(this.takeFluid(received, true), true);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void updateShare() {
        FluidStack last;
        if (this.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().getTransmitterNetworkSize() > 0 && ((last = this.getSaveShare()) != null && (this.lastWrite == null || this.lastWrite.amount != last.amount || this.lastWrite.getFluid() != last.getFluid()) || last == null && this.lastWrite != null)) {
            this.lastWrite = last;
            this.func_70296_d();
        }
    }

    private FluidStack getSaveShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            int remain = ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount % ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size();
            int toSave = ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount / ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size();
            if (((IGridTransmitter)((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.iterator().next()).equals(this.getTransmitter())) {
                toSave += remain;
            }
            return PipeUtils.copy(((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer, toSave);
        }
        return null;
    }

    @Override
    public void onChunkUnload() {
        if (!this.func_145831_w().field_72995_K && this.getTransmitter().hasTransmitterNetwork() && this.lastWrite != null && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount <= 0) {
                ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.PipeTier.values()[nbtTags.func_74762_e("tier")];
        }
        this.buffer.setCapacity(this.getCapacity());
        if (nbtTags.func_74764_b("cacheFluid")) {
            this.buffer.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cacheFluid")));
        } else {
            this.buffer.setFluid(null);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.lastWrite != null && this.lastWrite.amount > 0) {
            nbtTags.func_74782_a("cacheFluid", (NBTBase)this.lastWrite.writeToNBT(new NBTTagCompound()));
        } else {
            nbtTags.func_82580_o("cacheFluid");
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, EnumFacing side) {
        return PipeUtils.isValidAcceptorOnSide(acceptor, side);
    }

    @Override
    public FluidNetwork createNewNetwork() {
        return new FluidNetwork();
    }

    @Override
    public FluidNetwork createNetworkByMerging(Collection<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @Override
    public int getCapacity() {
        return this.tier.pipeCapacity;
    }

    public FluidStack getBuffer() {
        return this.buffer == null ? null : this.buffer.getFluid();
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null && this.lastWrite != null) {
            ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            this.buffer.setFluid(this.lastWrite);
        }
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.getConnectionType(from) == TileEntitySidedPipe.ConnectionType.NORMAL) {
            return this.takeFluid(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.getConnectionType(from) == TileEntitySidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from != null && this.getConnectionType(from) != TileEntitySidedPipe.ConnectionType.NONE) {
            return new FluidTankInfo[]{this.buffer.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    public int getPullAmount() {
        return this.tier.pipePullAmount;
    }

    @Override
    public IFluidHandler getCachedAcceptor(EnumFacing side) {
        TileEntity tile = this.getCachedTile(side);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            return (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    public int takeFluid(FluidStack fluid, boolean doEmit) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).emit(fluid, doEmit);
        }
        return this.buffer.fill(fluid, doEmit);
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.PipeTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        this.tier = Tier.PipeTier.values()[dataStream.readInt()];
        super.handlePacketData(dataStream);
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        return data;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.manager.getWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }
}

