/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TileEntityRotaryCondensentrator
extends TileEntityMachine
implements ISustainedData,
IFluidHandlerWrapper,
IGasHandler,
ITubeConnection,
Upgrade.IUpgradeInfoHandler,
ITankManager {
    public GasTank gasTank = new GasTank(10000);
    public FluidTank fluidTank = new FluidTank(10000);
    public static final int MAX_FLUID = 10000;
    public int mode;
    public int gasOutput = 256;
    public double clientEnergyUsed;

    public TileEntityRotaryCondensentrator() {
        super("machine.rotarycondensentrator", "RotaryCondensentrator", BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR.baseEnergy, MekanismConfig.usage.rotaryCondensentratorUsage, 5);
        this.inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(4, this);
            if (this.mode == 0) {
                if (!(((ItemStack)this.inventory.get(1)).func_190926_b() || this.gasTank.getGas() != null && this.gasTank.getStored() >= this.gasTank.getMaxGas())) {
                    this.gasTank.receive(GasUtils.removeGas((ItemStack)this.inventory.get(1), this.gasTank.getGasType(), this.gasTank.getNeeded()), true);
                }
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2))) {
                    FluidContainerUtils.handleContainerItemFill(this, this.fluidTank, 2, 3);
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidGas(this.gasTank.getGas()) && (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    int operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.fluidTank.fill(new FluidStack(this.gasTank.getGas().getGas().getFluid(), operations), true);
                    this.gasTank.draw(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            } else if (this.mode == 1) {
                if (!((ItemStack)this.inventory.get(0)).func_190926_b() && this.gasTank.getGas() != null) {
                    this.gasTank.draw(GasUtils.addGas((ItemStack)this.inventory.get(0), this.gasTank.getGas()), true);
                }
                if (this.gasTank.getGas() != null) {
                    GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getGas().amount, this.gasOutput));
                    this.gasTank.draw(GasUtils.emit(toSend, this, ListUtils.asList(MekanismUtils.getLeft(this.facing))), true);
                }
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2))) {
                    FluidContainerUtils.handleContainerItemEmpty(this, this.fluidTank, 2, 3);
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidFluid(this.fluidTank.getFluid()) && (this.gasTank.getGas() == null || this.gasTank.getStored() < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    int operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.gasTank.receive(new GasStack(GasRegistry.getGas(this.fluidTank.getFluid().getFluid()), operations), true);
                    this.fluidTank.drain(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public int getUpgradedUsage() {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        possibleProcess = this.mode == 0 ? Math.min(Math.min(this.gasTank.getStored(), this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount()), possibleProcess) : Math.min(Math.min(this.fluidTank.getFluidAmount(), this.gasTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    public boolean isValidGas(GasStack g) {
        return g != null && g.getGas().hasFluid();
    }

    public boolean gasEquals(GasStack gas, FluidStack fluid) {
        return fluid != null && gas != null && gas.getGas().hasFluid() && gas.getGas().getFluid() == fluid.getFluid();
    }

    public boolean isValidFluid(FluidStack f) {
        return f != null && GasRegistry.getGas(f.getFluid()) != null;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.mode = this.mode == 0 ? 1 : 0;
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.mode = dataStream.readInt();
            this.clientEnergyUsed = dataStream.readDouble();
            if (dataStream.readBoolean()) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)dataStream)), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            if (dataStream.readBoolean()) {
                this.gasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.gasTank.setGas(null);
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.mode);
        data.add(this.clientEnergyUsed);
        if (this.fluidTank.getFluid() != null) {
            data.add(true);
            data.add(FluidRegistry.getFluidName((FluidStack)this.fluidTank.getFluid()));
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(false);
        }
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.mode = nbtTags.func_74762_e("mode");
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("mode", this.mode);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbtTags;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return side == MekanismUtils.getLeft(this.facing);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return this.gasTank.receive(stack, doTransfer);
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return this.gasTank.draw(amount, doTransfer);
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.mode == 1 && side == MekanismUtils.getLeft(this.facing) && this.gasTank.canDraw(type);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.mode == 0 && side == MekanismUtils.getLeft(this.facing) && this.gasTank.canReceive(type);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.gasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasTank", this.gasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.gasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasTank")));
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid()) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.mode == 1 && from == MekanismUtils.getRight(this.facing) && (this.fluidTank.getFluid() == null ? this.isValidFluid(new FluidStack(fluid, 1)) : this.fluidTank.getFluid().getFluid() == fluid);
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.mode == 0 && from == MekanismUtils.getRight(this.facing);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == MekanismUtils.getRight(this.facing)) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.gasTank, this.fluidTank};
    }
}

