/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMultiblock<T extends SynchronizedData<T>>
extends TileEntityContainerBlock
implements IMultiblock<T> {
    public T structure;
    public boolean sendStructure;
    public boolean prevStructure;
    public boolean clientHasStructure;
    public boolean isRendering;
    public MultiblockCache cachedData = this.getNewCache();
    public String cachedID = null;

    public TileEntityMultiblock(String name) {
        super(name);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.structure = this.getNewStructure();
            }
            if (this.structure != null && this.clientHasStructure && this.isRendering && !this.prevStructure) {
                Mekanism.proxy.doMultiblockSparkle(this);
            }
            this.prevStructure = this.clientHasStructure;
        }
        if (this.playersUsing.size() > 0 && (this.field_145850_b.field_72995_K && !this.clientHasStructure || !this.field_145850_b.field_72995_K && this.structure == null)) {
            for (EntityPlayer player : this.playersUsing) {
                player.func_71053_j();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.isRendering = false;
                if (this.cachedID != null) {
                    this.getManager().updateCache(this);
                }
            }
            if (this.structure == null && this.ticker == 5) {
                this.doUpdate();
            }
            if (this.prevStructure == (this.structure == null)) {
                if (this.structure != null && !((SynchronizedData)this.getSynchronizedData()).hasRenderer) {
                    ((SynchronizedData)this.getSynchronizedData()).hasRenderer = true;
                    this.isRendering = true;
                    this.sendStructure = true;
                }
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    Coord4D obj = Coord4D.get(this).offset(side);
                    TileEntity tile = obj.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (obj.isAirBlock((IBlockAccess)this.field_145850_b) || tile != null && tile.getClass() == this.getClass()) continue;
                    obj.getBlock((IBlockAccess)this.field_145850_b).onNeighborChange((IBlockAccess)this.field_145850_b, obj.getPos(), this.func_174877_v());
                }
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            }
            boolean bl = this.prevStructure = this.structure != null;
            if (this.structure != null) {
                ((SynchronizedData)this.getSynchronizedData()).didTick = false;
                if (((SynchronizedData)this.getSynchronizedData()).inventoryID != null) {
                    this.cachedData.sync(this.getSynchronizedData());
                    this.cachedID = ((SynchronizedData)this.getSynchronizedData()).inventoryID;
                    this.getManager().updateCache(this);
                }
            }
        }
    }

    @Override
    public void doUpdate() {
        if (!(this.field_145850_b.field_72995_K || this.structure != null && ((SynchronizedData)this.getSynchronizedData()).didTick)) {
            this.getProtocol().doUpdate();
            if (this.structure != null) {
                ((SynchronizedData)this.getSynchronizedData()).didTick = true;
            }
        }
    }

    public void sendPacketToRenderer() {
        if (this.structure != null) {
            for (Coord4D obj : ((SynchronizedData)this.getSynchronizedData()).locations) {
                TileEntityMultiblock tileEntity = (TileEntityMultiblock)obj.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null || !tileEntity.isRendering) continue;
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
    }

    protected abstract T getNewStructure();

    public abstract MultiblockCache<T> getNewCache();

    protected abstract UpdateProtocol<T> getProtocol();

    public abstract MultiblockManager<T> getManager();

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isRendering);
        data.add(this.structure != null);
        if (this.structure != null && this.isRendering) {
            if (this.sendStructure) {
                this.sendStructure = false;
                data.add(true);
                data.add(((SynchronizedData)this.getSynchronizedData()).volHeight);
                data.add(((SynchronizedData)this.getSynchronizedData()).volWidth);
                data.add(((SynchronizedData)this.getSynchronizedData()).volLength);
                ((SynchronizedData)this.getSynchronizedData()).renderLocation.write(data);
                data.add(((SynchronizedData)this.getSynchronizedData()).inventoryID);
            } else {
                data.add(false);
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.structure == null) {
                this.structure = this.getNewStructure();
            }
            this.isRendering = dataStream.readBoolean();
            this.clientHasStructure = dataStream.readBoolean();
            if (this.clientHasStructure && this.isRendering && dataStream.readBoolean()) {
                ((SynchronizedData)this.getSynchronizedData()).volHeight = dataStream.readInt();
                ((SynchronizedData)this.getSynchronizedData()).volWidth = dataStream.readInt();
                ((SynchronizedData)this.getSynchronizedData()).volLength = dataStream.readInt();
                ((SynchronizedData)this.getSynchronizedData()).renderLocation = Coord4D.read(dataStream);
                ((SynchronizedData)this.getSynchronizedData()).inventoryID = PacketHandler.readString(dataStream);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (this.structure == null && nbtTags.func_74764_b("cachedID")) {
            this.cachedID = nbtTags.func_74779_i("cachedID");
            this.cachedData.load(nbtTags);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.cachedID != null) {
            nbtTags.func_74778_a("cachedID", this.cachedID);
            this.cachedData.save(nbtTags);
        }
        return nbtTags;
    }

    @Override
    protected NonNullList<ItemStack> getInventory() {
        return this.structure != null ? ((SynchronizedData)this.structure).getInventory() : null;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean handleInventory() {
        return false;
    }

    @Override
    public T getSynchronizedData() {
        return this.structure;
    }
}

