/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.LaserManager;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityNoisyBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityLaser
extends TileEntityNoisyBlock
implements IActiveState {
    public Coord4D digging;
    public double diggingProgress;
    public boolean isActive;
    public boolean clientActive;

    public TileEntityLaser() {
        super("machine.laser", "Laser", 2.0 * MekanismConfig.usage.laserUsage);
        this.inventory = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            if (this.isActive) {
                Coord4D hitCoord;
                RayTraceResult mop = LaserManager.fireLaserClient(this, this.facing, MekanismConfig.usage.laserUsage, this.field_145850_b);
                Coord4D coord4D = hitCoord = mop == null ? null : new Coord4D(mop, this.field_145850_b);
                if (hitCoord == null || !hitCoord.equals(this.digging)) {
                    this.digging = hitCoord;
                    this.diggingProgress = 0.0;
                }
                if (hitCoord != null) {
                    IBlockState blockHit = hitCoord.getBlockState((IBlockAccess)this.field_145850_b);
                    TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                    float hardness = blockHit.func_185887_b(this.field_145850_b, hitCoord.getPos());
                    if (!(hardness < 0.0f || LaserManager.isReceptor(tileHit, mop.field_178784_b) && !LaserManager.getReceptor(tileHit, mop.field_178784_b).canLasersDig())) {
                        this.diggingProgress += MekanismConfig.usage.laserUsage;
                        if (this.diggingProgress < (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                            Mekanism.proxy.addHitEffects(hitCoord, mop);
                        }
                    }
                }
            }
        } else if (this.getEnergy() >= MekanismConfig.usage.laserUsage) {
            Coord4D hitCoord;
            this.setActive(true);
            LaserManager.LaserInfo info = LaserManager.fireLaser(this, this.facing, MekanismConfig.usage.laserUsage, this.field_145850_b);
            Coord4D coord4D = hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos, this.field_145850_b);
            if (hitCoord == null || !hitCoord.equals(this.digging)) {
                this.digging = hitCoord;
                this.diggingProgress = 0.0;
            }
            if (hitCoord != null) {
                IBlockState blockHit = hitCoord.getBlockState((IBlockAccess)this.field_145850_b);
                TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                float hardness = blockHit.func_185887_b(this.field_145850_b, hitCoord.getPos());
                if (!(hardness < 0.0f || LaserManager.isReceptor(tileHit, info.movingPos.field_178784_b) && !LaserManager.getReceptor(tileHit, info.movingPos.field_178784_b).canLasersDig())) {
                    this.diggingProgress += MekanismConfig.usage.laserUsage;
                    if (this.diggingProgress >= (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                        LaserManager.breakBlock(hitCoord, true, this.field_145850_b);
                        this.diggingProgress = 0.0;
                    }
                }
            }
            this.setEnergy(this.getEnergy() - MekanismConfig.usage.laserUsage);
        } else {
            this.setActive(false);
            this.diggingProgress = 0.0;
        }
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return side == this.facing.func_176734_d();
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientActive = dataStream.readBoolean();
            if (this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        return nbtTags;
    }
}

