/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.MekanismFluids;
import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalDissolutionChamber
extends TileEntityMachine
implements ITubeConnection,
IGasHandler,
ISustainedData,
ITankManager {
    public GasTank injectTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public static final int BASE_INJECT_USAGE = 1;
    public double injectUsage = 1.0;
    public int injectUsageThisTick;
    public int gasOutput = 256;
    public int operatingTicks = 0;
    public int BASE_TICKS_REQUIRED = 100;
    public int ticksRequired = 100;
    public final double BASE_ENERGY_USAGE = MekanismConfig.usage.chemicalDissolutionChamberUsage;
    public DissolutionRecipe cachedRecipe;

    public TileEntityChemicalDissolutionChamber() {
        super("machine.dissolution", "ChemicalDissolutionChamber", BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.baseEnergy, MekanismConfig.usage.chemicalDissolutionChamberUsage, 4);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b() && this.injectTank.getNeeded() > 0) {
                this.injectTank.receive(GasUtils.removeGas((ItemStack)this.inventory.get(0), MekanismFluids.SulfuricAcid, this.injectTank.getNeeded()), true);
            }
            if (!((ItemStack)this.inventory.get(2)).func_190926_b() && this.outputTank.getGas() != null) {
                this.outputTank.draw(GasUtils.addGas((ItemStack)this.inventory.get(2), this.outputTank.getGas()), true);
            }
            boolean changed = false;
            DissolutionRecipe recipe = this.getRecipe();
            this.injectUsageThisTick = Math.max(1, StatUtils.inversePoisson(this.injectUsage));
            if (this.canOperate(recipe) && this.getEnergy() >= this.energyPerTick && this.injectTank.getStored() >= this.injectUsageThisTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyPerTick);
                this.minorOperate();
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                changed = true;
                this.setActive(false);
            }
            if (changed && !this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.outputTank.getGas() != null) {
                GasStack toSend = new GasStack(this.outputTank.getGas().getGas(), Math.min(this.outputTank.getStored(), this.gasOutput));
                this.outputTank.draw(GasUtils.emit(toSend, this, ListUtils.asList(MekanismUtils.getRight(this.facing))), true);
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return RecipeHandler.getDissolutionRecipe(new ItemStackInput(itemstack)) != null;
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 2) {
            return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing) || side == EnumFacing.UP) {
            return new int[]{1};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{0};
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return new int[]{2};
        }
        return InventoryUtils.EMPTY;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    public DissolutionRecipe getRecipe() {
        ItemStackInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ItemStackInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getDissolutionRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public ItemStackInput getInput() {
        return new ItemStackInput((ItemStack)this.inventory.get(1));
    }

    public boolean canOperate(DissolutionRecipe recipe) {
        return recipe != null && recipe.canOperate((NonNullList<ItemStack>)this.inventory, this.outputTank);
    }

    public void operate(DissolutionRecipe recipe) {
        recipe.operate((NonNullList<ItemStack>)this.inventory, this.outputTank);
        this.func_70296_d();
    }

    public void minorOperate() {
        this.injectTank.draw(this.injectUsageThisTick, true);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.operatingTicks = dataStream.readInt();
            if (dataStream.readBoolean()) {
                this.injectTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.injectTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.outputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.outputTank.setGas(null);
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.operatingTicks);
        if (this.injectTank.getGas() != null) {
            data.add(true);
            data.add(this.injectTank.getGas().getGas().getID());
            data.add(this.injectTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputTank.getGas() != null) {
            data.add(true);
            data.add(this.outputTank.getGas().getGas().getID());
            data.add(this.outputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.injectTank.read(nbtTags.func_74775_l("injectTank"));
        this.outputTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74782_a("injectTank", (NBTBase)this.injectTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("gasTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.injectTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return side == MekanismUtils.getLeft(this.facing) && type == MekanismFluids.SulfuricAcid;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.injectTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "injectTank", this.injectTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputTank", this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.injectTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "injectTank")));
        this.outputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputTank")));
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case GAS: {
                this.injectUsage = MekanismUtils.getSecondaryEnergyPerTickMean(this, 1);
                break;
            }
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.injectUsage = MekanismUtils.getSecondaryEnergyPerTickMean(this, 1);
                break;
            }
        }
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.injectTank, this.outputTank};
    }
}

