/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class AdvancedMachineInput
extends MachineInput<AdvancedMachineInput> {
    public ItemStack itemStack = ItemStack.field_190927_a;
    public Gas gasType;

    public AdvancedMachineInput(ItemStack item, Gas gas) {
        this.itemStack = item;
        this.gasType = gas;
    }

    public AdvancedMachineInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.itemStack = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("input"));
        this.gasType = Gas.readFromNBT(nbtTags.func_74775_l("gasType"));
    }

    @Override
    public AdvancedMachineInput copy() {
        return new AdvancedMachineInput(this.itemStack.func_77946_l(), this.gasType);
    }

    @Override
    public boolean isValid() {
        return !this.itemStack.func_190926_b() && this.gasType != null;
    }

    public boolean useItem(NonNullList<ItemStack> inventory, int index, boolean deplete) {
        if (AdvancedMachineInput.inputContains((ItemStack)inventory.get(index), this.itemStack)) {
            if (deplete) {
                inventory.set(index, (Object)StackUtils.subtract((ItemStack)inventory.get(index), this.itemStack));
            }
            return true;
        }
        return false;
    }

    public boolean useSecondary(GasTank gasTank, int amountToUse, boolean deplete) {
        if (gasTank.getGasType() == this.gasType && gasTank.getStored() >= amountToUse) {
            gasTank.draw(amountToUse, deplete);
            return true;
        }
        return false;
    }

    public boolean matches(AdvancedMachineInput input) {
        return StackUtils.equalsWildcard(this.itemStack, input.itemStack) && input.itemStack.func_190916_E() >= this.itemStack.func_190916_E();
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.itemStack) << 8 | this.gasType.getID();
    }

    @Override
    public boolean testEquality(AdvancedMachineInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return StackUtils.equalsWildcardWithNBT(this.itemStack, other.itemStack) && this.gasType.getID() == other.gasType.getID();
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof AdvancedMachineInput;
    }
}

